/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.linearAlgebra.careSolvers.schur;

import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.data.Matrix;
import org.ejml.dense.row.CommonOps_DDRM;
import org.ejml.dense.row.factory.DecompositionFactory_DDRM;
import org.ejml.interfaces.decomposition.QRDecomposition;
import us.ihmc.robotics.linearAlgebra.careSolvers.MatrixToolsLocal;
import us.ihmc.robotics.linearAlgebra.careSolvers.schur.SchurDecomposition;

public class QRBasedSchurDecomposition
implements SchurDecomposition<DMatrixRMaj> {
    private final QRDecomposition<DMatrixRMaj> qrDecomposition;
    private final DMatrixRMaj T;
    private final DMatrixRMaj Tprev;
    private final DMatrixRMaj Uprev;
    private final DMatrixRMaj U;
    private final DMatrixRMaj Q;
    private final DMatrixRMaj R;
    private int maxIterations = 1000000;
    private double epsilon = 1.0E-6;

    public QRBasedSchurDecomposition(int size) {
        this.qrDecomposition = DecompositionFactory_DDRM.qr((int)size, (int)size);
        this.T = new DMatrixRMaj(size, size);
        this.Tprev = new DMatrixRMaj(size, size);
        this.Uprev = new DMatrixRMaj(size, size);
        this.Q = new DMatrixRMaj(size, size);
        this.R = new DMatrixRMaj(size, size);
        this.U = new DMatrixRMaj(size, size);
    }

    public void setMaxIterations(int maxIterations) {
        this.maxIterations = maxIterations;
    }

    public void setConvergenceEpsilon(double epsilon) {
        this.epsilon = epsilon;
    }

    public boolean decompose(DMatrixRMaj A) {
        if (A.getNumRows() != A.getNumCols()) {
            throw new IllegalArgumentException("A matrix is not square.");
        }
        boolean converged = false;
        int iterations = 0;
        this.R.reshape(A.getNumRows(), A.getNumCols());
        this.Q.reshape(A.getNumRows(), A.getNumCols());
        this.T.reshape(A.getNumRows(), A.getNumCols());
        this.U.reshape(A.getNumRows(), A.getNumCols());
        this.Uprev.reshape(A.getNumRows(), A.getNumCols());
        this.Tprev.set((DMatrixD1)A);
        CommonOps_DDRM.setIdentity((DMatrix1Row)this.Uprev);
        while (!converged) {
            if (iterations > this.maxIterations) {
                return false;
            }
            this.qrDecomposition.decompose((Matrix)this.Tprev);
            this.qrDecomposition.getQ((Matrix)this.Q, false);
            this.qrDecomposition.getR((Matrix)this.R, false);
            CommonOps_DDRM.mult((DMatrix1Row)this.R, (DMatrix1Row)this.Q, (DMatrix1Row)this.T);
            CommonOps_DDRM.mult((DMatrix1Row)this.Uprev, (DMatrix1Row)this.Q, (DMatrix1Row)this.U);
            double TDistance = MatrixToolsLocal.distance(this.T, this.Tprev);
            double UDistance = MatrixToolsLocal.distance(this.U, this.Uprev);
            converged = TDistance < this.epsilon;
            converged &= UDistance < this.epsilon;
            this.Tprev.set((DMatrixD1)this.T);
            this.Uprev.set((DMatrixD1)this.U);
            ++iterations;
        }
        return true;
    }

    @Override
    public DMatrixRMaj getU(DMatrixRMaj UToPack) {
        if (UToPack != null) {
            UToPack.set((DMatrixD1)this.U);
            return null;
        }
        return new DMatrixRMaj(this.U);
    }

    @Override
    public DMatrixRMaj getT(DMatrixRMaj TToPack) {
        if (TToPack != null) {
            TToPack.set((DMatrixD1)this.T);
            return null;
        }
        return new DMatrixRMaj(this.T);
    }

    public boolean inputModified() {
        return false;
    }
}

