/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.linearAlgebra.careSolvers;

import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import us.ihmc.matrixlib.NativeCommonOps;
import us.ihmc.robotics.linearAlgebra.careSolvers.AbstractCARESolver;
import us.ihmc.robotics.linearAlgebra.careSolvers.CARESolver;
import us.ihmc.robotics.linearAlgebra.careSolvers.EigenvectorCARESolver;
import us.ihmc.robotics.linearAlgebra.careSolvers.LyapunovEquationSolver;
import us.ihmc.robotics.linearAlgebra.careSolvers.MatrixToolsLocal;

public class NewtonCARESolver
extends AbstractCARESolver {
    private static final int defaultMaxIterations = 100000;
    private final int maxIterations;
    private static final double defaultConvergenceEpsilon = 1.0E-8;
    private final double convergenceEpsilon;
    private final DMatrixRMaj PE = new DMatrixRMaj(0, 0);
    private final DMatrixRMaj Ak = new DMatrixRMaj(0, 0);
    private final DMatrixRMaj Qk = new DMatrixRMaj(0, 0);
    private final DMatrixRMaj EInverse = new DMatrixRMaj(0, 0);
    private final LyapunovEquationSolver lyapunovSolver = new LyapunovEquationSolver();
    private final CARESolver backendSolver;

    public NewtonCARESolver() {
        this(new EigenvectorCARESolver());
    }

    public NewtonCARESolver(CARESolver backendSolver) {
        this(backendSolver, 100000, 1.0E-8);
    }

    public NewtonCARESolver(CARESolver backendSolver, int maxIterations, double convergenceEpsilon) {
        this.backendSolver = backendSolver;
        this.maxIterations = maxIterations;
        this.convergenceEpsilon = convergenceEpsilon;
    }

    @Override
    public DMatrixRMaj computeP() {
        this.backendSolver.setMatrices(this.A, this.hasE ? this.E : null, this.M, this.Q);
        this.backendSolver.computeP();
        if (this.hasE) {
            this.PE.reshape(this.n, this.n);
            CommonOps_DDRM.mult((DMatrix1Row)this.backendSolver.getP(), (DMatrix1Row)this.E, (DMatrix1Row)this.PE);
        } else {
            this.PE.set((DMatrixD1)this.backendSolver.getP());
        }
        this.Ak.reshape(this.n, this.n);
        this.Qk.reshape(this.n, this.n);
        double error = 1.0;
        int i = 1;
        while (error > this.convergenceEpsilon) {
            CommonOps_DDRM.mult((double)-1.0, (DMatrix1Row)this.M, (DMatrix1Row)this.PE, (DMatrix1Row)this.Ak);
            CommonOps_DDRM.addEquals((DMatrixD1)this.Ak, (DMatrixD1)this.A);
            NativeCommonOps.multQuad((DMatrix1Row)this.PE, (DMatrix1Row)this.M, (DMatrix1Row)this.Qk);
            CommonOps_DDRM.addEquals((DMatrixD1)this.Qk, (DMatrixD1)this.Q);
            CommonOps_DDRM.scale((double)-1.0, (DMatrixD1)this.Q);
            this.lyapunovSolver.setMatrices(this.Ak, this.Qk);
            this.lyapunovSolver.solve();
            DMatrixRMaj Pk = this.lyapunovSolver.getX();
            error = MatrixToolsLocal.distance(this.PE, Pk);
            this.PE.set((DMatrixD1)Pk);
            if (++i <= this.maxIterations) continue;
            throw new RuntimeException("Convergence failed.");
        }
        if (this.hasE) {
            this.EInverse.reshape(this.n, this.n);
            this.P.reshape(this.n, this.n);
            NativeCommonOps.invert((DMatrix1Row)this.E, (DMatrix1Row)this.EInverse);
            CommonOps_DDRM.mult((DMatrix1Row)this.PE, (DMatrix1Row)this.EInverse, (DMatrix1Row)this.P);
        } else {
            this.P.set((DMatrixD1)this.PE);
        }
        this.isUpToDate = true;
        return this.P;
    }
}

