/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.linearAlgebra.careSolvers;

import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import us.ihmc.matrixlib.NativeCommonOps;
import us.ihmc.robotics.linearAlgebra.careSolvers.AbstractCARESolver;
import us.ihmc.robotics.linearAlgebra.careSolvers.CARESolver;
import us.ihmc.robotics.linearAlgebra.careSolvers.CARETools;
import us.ihmc.robotics.linearAlgebra.careSolvers.LyapunovEquationSolver;
import us.ihmc.robotics.linearAlgebra.careSolvers.MatrixToolsLocal;

public class Newton2CARESolver
extends AbstractCARESolver {
    private static final int defaultMaxIterations = 10000;
    private static final double defaultConvergenceEpsilon = 1.0E-12;
    private final int maxIterations;
    private final double convergenceEpsilon;
    private final DMatrixRMaj PE = new DMatrixRMaj(0, 0);
    private final DMatrixRMaj PDotk = new DMatrixRMaj(0, 0);
    private final DMatrixRMaj EInverse = new DMatrixRMaj(0, 0);
    private final DMatrixRMaj Ak = new DMatrixRMaj(0, 0);
    private final CARESolver backendSolver;
    private final LyapunovEquationSolver lyapunovSolver = new LyapunovEquationSolver();

    public Newton2CARESolver(CARESolver backendSolver) {
        this.backendSolver = backendSolver;
        this.maxIterations = 10000;
        this.convergenceEpsilon = 1.0E-12;
    }

    @Override
    public DMatrixRMaj computeP() {
        int n = this.A.getNumRows();
        this.Ak.reshape(n, n);
        this.PDotk.reshape(n, n);
        this.PE.reshape(n, n);
        this.backendSolver.setMatrices(this.A, this.hasE ? this.E : null, this.M, this.Q);
        if (this.hasE) {
            CommonOps_DDRM.mult((DMatrix1Row)this.backendSolver.getP(), (DMatrix1Row)this.E, (DMatrix1Row)this.PE);
        } else {
            this.PE.set((DMatrixD1)this.backendSolver.getP());
        }
        int iteration = 0;
        boolean converged = false;
        while (!converged) {
            CARETools.computeRiccatiRate(this.PE, this.A, this.Q, this.M, this.PDotk);
            CommonOps_DDRM.mult((double)-1.0, (DMatrix1Row)this.M, (DMatrix1Row)this.PE, (DMatrix1Row)this.Ak);
            CommonOps_DDRM.addEquals((DMatrixD1)this.Ak, (DMatrixD1)this.A);
            this.lyapunovSolver.setMatrices(this.Ak, this.PDotk);
            DMatrixRMaj Pk = this.lyapunovSolver.getX();
            converged = MatrixToolsLocal.isZero(Pk, this.convergenceEpsilon);
            CommonOps_DDRM.addEquals((DMatrixD1)this.PE, (DMatrixD1)Pk);
            if (++iteration <= this.maxIterations) continue;
            throw new RuntimeException("Convergence failed.");
        }
        if (this.hasE) {
            this.P.reshape(n, n);
            this.EInverse.reshape(n, n);
            NativeCommonOps.invert((DMatrix1Row)this.E, (DMatrix1Row)this.EInverse);
            CommonOps_DDRM.mult((DMatrix1Row)this.PE, (DMatrix1Row)this.EInverse, (DMatrix1Row)this.P);
        } else {
            this.P.set((DMatrixD1)this.PE);
        }
        this.isUpToDate = true;
        return this.P;
    }
}

