/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.linearAlgebra.careSolvers;

import org.ejml.data.DMatrixRMaj;
import us.ihmc.commons.MathTools;
import us.ihmc.robotics.linearAlgebra.careSolvers.MatrixChecking;

public class MatrixToolsLocal {
    public static void setMatrixBlockToIdentity(DMatrixRMaj dest, int row, int col, int sizeToSet) {
        MatrixToolsLocal.setMatrixBlockToConstant(dest, row, col, sizeToSet, 1.0);
    }

    public static void setMatrixBlockToConstant(DMatrixRMaj dest, int row, int col, int sizeToSet, double value) {
        for (int i = 0; i < sizeToSet; ++i) {
            dest.set(row + i, col + i, value);
        }
    }

    public static double distance(DMatrixRMaj A, DMatrixRMaj B) {
        MatrixChecking.assertRowDimensionsMatch(A, B);
        MatrixChecking.assertColDimensionsMatch(A, B);
        double norm = 0.0;
        for (int col = 0; col < A.getNumCols(); ++col) {
            double rowSum = 0.0;
            for (int row = 0; row < A.getNumRows(); ++row) {
                rowSum += MathTools.square((double)(A.get(row, col) - B.get(row, col)));
            }
            norm += MathTools.square((double)rowSum);
        }
        return norm;
    }

    public static double normSquared(DMatrixRMaj A) {
        double normSquared = 0.0;
        for (int col = 0; col < A.getNumCols(); ++col) {
            double rowSum = 0.0;
            for (int row = 0; row < A.getNumRows(); ++row) {
                rowSum += MathTools.square((double)A.get(row, col));
            }
            normSquared += MathTools.square((double)rowSum);
        }
        return normSquared;
    }

    public static double norm(DMatrixRMaj A) {
        return Math.sqrt(MatrixToolsLocal.normSquared(A));
    }

    static boolean isZero(DMatrixRMaj P, double epsilon) {
        return MatrixToolsLocal.normSquared(P) < epsilon;
    }
}

