/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.linearAlgebra.careSolvers;

import org.ejml.data.DMatrix;
import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.data.Matrix;
import org.ejml.dense.row.CommonOps_DDRM;
import org.ejml.dense.row.factory.DecompositionFactory_DDRM;
import org.ejml.interfaces.decomposition.EigenDecomposition_F64;
import us.ihmc.matrixlib.MatrixTools;
import us.ihmc.matrixlib.NativeCommonOps;
import us.ihmc.robotics.linearAlgebra.careSolvers.AbstractCARESolver;

public class EigenvectorCARESolver
extends AbstractCARESolver {
    private final EigenDecomposition_F64<DMatrixRMaj> eigen = DecompositionFactory_DDRM.eig((int)0, (boolean)true);
    private final DMatrixRMaj EInverse = new DMatrixRMaj(0, 0);
    private final DMatrixRMaj EInverseTranspose = new DMatrixRMaj(0, 0);
    private final DMatrixRMaj EInverseA = new DMatrixRMaj(0, 0);
    private final DMatrixRMaj EInverseATranspose = new DMatrixRMaj(0, 0);
    private final DMatrixRMaj EInverseMEInverseTranspose = new DMatrixRMaj(0, 0);
    private final DMatrixRMaj hamiltonian = new DMatrixRMaj(0, 0);
    private final DMatrixRMaj u = new DMatrixRMaj(0, 0);
    private final DMatrixRMaj u1 = new DMatrixRMaj(0, 0);
    private final DMatrixRMaj u2 = new DMatrixRMaj(0, 0);
    private final DMatrixRMaj u1Inv = new DMatrixRMaj(0, 0);

    @Override
    public DMatrixRMaj computeP() {
        this.EInverseATranspose.reshape(this.n, this.n);
        if (this.hasE) {
            this.EInverse.reshape(this.n, this.n);
            this.EInverseA.reshape(this.n, this.n);
            this.EInverseTranspose.reshape(this.n, this.n);
            NativeCommonOps.invert((DMatrix1Row)this.E, (DMatrix1Row)this.EInverse);
            CommonOps_DDRM.mult((DMatrix1Row)this.E, (DMatrix1Row)this.A, (DMatrix1Row)this.EInverseA);
            CommonOps_DDRM.transpose((DMatrixRMaj)this.EInverse, (DMatrixRMaj)this.EInverseTranspose);
            NativeCommonOps.multQuad((DMatrix1Row)this.EInverseTranspose, (DMatrix1Row)this.M, (DMatrix1Row)this.EInverseMEInverseTranspose);
        } else {
            this.EInverseA.set((DMatrixD1)this.A);
            this.EInverseMEInverseTranspose.set((DMatrixD1)this.M);
        }
        CommonOps_DDRM.transpose((DMatrixRMaj)this.EInverseA, (DMatrixRMaj)this.EInverseATranspose);
        this.hamiltonian.reshape(2 * this.n, 2 * this.n);
        MatrixTools.setMatrixBlock((DMatrix)this.hamiltonian, (int)0, (int)0, (DMatrix)this.EInverseA, (int)0, (int)0, (int)this.n, (int)this.n, (double)1.0);
        MatrixTools.setMatrixBlock((DMatrix)this.hamiltonian, (int)0, (int)this.n, (DMatrix)this.EInverseMEInverseTranspose, (int)0, (int)0, (int)this.n, (int)this.n, (double)1.0);
        MatrixTools.setMatrixBlock((DMatrix)this.hamiltonian, (int)this.n, (int)0, (DMatrix)this.Q, (int)0, (int)0, (int)this.n, (int)this.n, (double)1.0);
        MatrixTools.setMatrixBlock((DMatrix)this.hamiltonian, (int)this.n, (int)this.n, (DMatrix)this.EInverseATranspose, (int)0, (int)0, (int)this.n, (int)this.n, (double)-1.0);
        this.eigen.decompose((Matrix)this.hamiltonian);
        this.u.reshape(2 * this.n, this.n);
        this.u1.reshape(this.n, this.n);
        this.u2.reshape(this.n, this.n);
        int valueIdx = 0;
        for (int i = 0; i < 2 * this.n; ++i) {
            if (this.eigen.getEigenvalue(i).getImaginary() != 0.0) {
                throw new IllegalArgumentException("The imaginary part of the eigenvalue must be equal to zero.");
            }
            if (this.eigen.getEigenvalue(i).getReal() < 0.0) {
                MatrixTools.setMatrixBlock((DMatrix)this.u, (int)0, (int)valueIdx++, (DMatrix)((DMatrix)this.eigen.getEigenVector(i)), (int)0, (int)0, (int)(2 * this.n), (int)1, (double)1.0);
            }
            if (valueIdx == this.n) break;
        }
        MatrixTools.setMatrixBlock((DMatrix)this.u1, (int)0, (int)0, (DMatrix)this.u, (int)0, (int)0, (int)this.n, (int)this.n, (double)1.0);
        MatrixTools.setMatrixBlock((DMatrix)this.u2, (int)0, (int)0, (DMatrix)this.u, (int)this.n, (int)0, (int)this.n, (int)this.n, (double)-1.0);
        this.u1Inv.reshape(this.n, this.n);
        NativeCommonOps.invert((DMatrix1Row)this.u1, (DMatrix1Row)this.u1Inv);
        this.P.reshape(this.n, this.n);
        CommonOps_DDRM.mult((DMatrix1Row)this.u2, (DMatrix1Row)this.u1Inv, (DMatrix1Row)this.P);
        this.isUpToDate = true;
        return this.P;
    }
}

