/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.linearAlgebra.careSolvers;

import org.ejml.data.DMatrix;
import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import us.ihmc.matrixlib.MatrixTools;
import us.ihmc.matrixlib.NativeCommonOps;

public class CARETools {
    public static void computeM(DMatrixRMaj BTranspose, DMatrixRMaj R, DMatrixRMaj RinvToPack, DMatrixRMaj SToPack) {
        int n = BTranspose.getNumCols();
        if (RinvToPack == null) {
            RinvToPack = new DMatrixRMaj(n, n);
        } else {
            RinvToPack.reshape(n, n);
        }
        SToPack.reshape(n, n);
        NativeCommonOps.invert((DMatrix1Row)R, (DMatrix1Row)RinvToPack);
        NativeCommonOps.multQuad((DMatrix1Row)BTranspose, (DMatrix1Row)RinvToPack, (DMatrix1Row)SToPack);
    }

    public static void assembleHamiltonian(DMatrixRMaj A, DMatrixRMaj ATranspose, DMatrixRMaj Q, DMatrixRMaj S, DMatrixRMaj hamiltonianToPack) {
        int n = A.getNumRows();
        if (ATranspose == null) {
            ATranspose = new DMatrixRMaj(n, n);
            CommonOps_DDRM.transpose((DMatrixRMaj)A, (DMatrixRMaj)ATranspose);
        }
        hamiltonianToPack.reshape(2 * n, 2 * n);
        MatrixTools.setMatrixBlock((DMatrix)hamiltonianToPack, (int)0, (int)0, (DMatrix)A, (int)0, (int)0, (int)n, (int)n, (double)1.0);
        MatrixTools.setMatrixBlock((DMatrix)hamiltonianToPack, (int)n, (int)0, (DMatrix)Q, (int)0, (int)0, (int)n, (int)n, (double)-1.0);
        MatrixTools.setMatrixBlock((DMatrix)hamiltonianToPack, (int)0, (int)n, (DMatrix)S, (int)0, (int)0, (int)n, (int)n, (double)-1.0);
        MatrixTools.setMatrixBlock((DMatrix)hamiltonianToPack, (int)n, (int)n, (DMatrix)ATranspose, (int)0, (int)0, (int)n, (int)n, (double)-1.0);
    }

    public static void computeRiccatiRate(DMatrixRMaj P, DMatrixRMaj A, DMatrixRMaj Q, DMatrixRMaj S, DMatrixRMaj PDotToPack) {
        NativeCommonOps.multQuad((DMatrix1Row)P, (DMatrix1Row)S, (DMatrix1Row)PDotToPack);
        CommonOps_DDRM.scale((double)-1.0, (DMatrixD1)PDotToPack);
        CommonOps_DDRM.multAddTransA((DMatrix1Row)A, (DMatrix1Row)P, (DMatrix1Row)PDotToPack);
        CommonOps_DDRM.multAdd((DMatrix1Row)P, (DMatrix1Row)A, (DMatrix1Row)PDotToPack);
        CommonOps_DDRM.addEquals((DMatrixD1)PDotToPack, (DMatrixD1)Q);
    }
}

