/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.linearAlgebra;

import org.ejml.data.DMatrix;
import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.data.Matrix;
import org.ejml.dense.row.CommonOps_DDRM;
import org.ejml.dense.row.factory.DecompositionFactory_DDRM;
import org.ejml.interfaces.decomposition.SingularValueDecomposition_F64;
import us.ihmc.commons.MathTools;
import us.ihmc.matrixlib.MatrixTools;
import us.ihmc.robotics.linearAlgebra.ConfigurableSolvePseudoInverseSVD;
import us.ihmc.robotics.linearAlgebra.NullspaceCalculator;

public class SVDNullspaceCalculator
implements NullspaceCalculator {
    private final ConfigurableSolvePseudoInverseSVD iMinusNNTSolver;
    private final SingularValueDecomposition_F64<DMatrixRMaj> decomposer;
    private final DMatrixRMaj sigma;
    private final DMatrixRMaj v;
    private final DMatrixRMaj nullspace;
    private final DMatrixRMaj Q;
    private final DMatrixRMaj iMinusNNT;
    private final DMatrixRMaj nullspaceProjector;
    private final DMatrixRMaj tempMatrixForProjectionInPlace;
    private final boolean makeLargestComponentPositive;

    public SVDNullspaceCalculator(int matrixSize, boolean makeLargestComponentPositive) {
        MathTools.checkIntervalContains((long)matrixSize, (long)1L, (long)Integer.MAX_VALUE);
        this.iMinusNNT = new DMatrixRMaj(matrixSize, matrixSize);
        double singularValueLimit = 0.5;
        this.iMinusNNTSolver = new ConfigurableSolvePseudoInverseSVD(matrixSize, matrixSize, singularValueLimit);
        this.nullspaceProjector = new DMatrixRMaj(matrixSize, matrixSize);
        this.tempMatrixForProjectionInPlace = new DMatrixRMaj(matrixSize, matrixSize);
        this.decomposer = DecompositionFactory_DDRM.svd((int)matrixSize, (int)matrixSize, (boolean)false, (boolean)true, (boolean)false);
        this.sigma = new DMatrixRMaj(matrixSize, matrixSize);
        this.v = new DMatrixRMaj(matrixSize, matrixSize);
        this.nullspace = new DMatrixRMaj(matrixSize, matrixSize);
        this.Q = new DMatrixRMaj(matrixSize, matrixSize);
        this.makeLargestComponentPositive = makeLargestComponentPositive;
    }

    @Override
    public void projectOntoNullspace(DMatrixRMaj matrixToProjectOntoNullspace, DMatrixRMaj matrixToComputeNullspaceOf) {
        this.tempMatrixForProjectionInPlace.set((DMatrixD1)matrixToProjectOntoNullspace);
        this.projectOntoNullspace(this.tempMatrixForProjectionInPlace, matrixToComputeNullspaceOf, matrixToProjectOntoNullspace);
    }

    @Override
    public void projectOntoNullspace(DMatrixRMaj matrixToProjectOntoNullspace, DMatrixRMaj matrixToComputeNullspaceOf, DMatrixRMaj projectedMatrixToPack) {
        this.computeNullspaceProjector(matrixToComputeNullspaceOf, this.nullspaceProjector);
        CommonOps_DDRM.mult((DMatrix1Row)matrixToProjectOntoNullspace, (DMatrix1Row)this.nullspaceProjector, (DMatrix1Row)projectedMatrixToPack);
    }

    @Override
    public void computeNullspaceProjector(DMatrixRMaj matrixToComputeNullspaceOf, DMatrixRMaj nullspaceProjectorToPack) {
        int nullity = Math.max(matrixToComputeNullspaceOf.getNumCols() - matrixToComputeNullspaceOf.getNumRows(), 0);
        this.setMatrix(matrixToComputeNullspaceOf, nullity);
        nullspaceProjectorToPack.reshape(matrixToComputeNullspaceOf.getNumCols(), matrixToComputeNullspaceOf.getNumCols());
        CommonOps_DDRM.multOuter((DMatrix1Row)this.nullspace, (DMatrix1Row)nullspaceProjectorToPack);
    }

    public void setMatrix(DMatrixRMaj matrix, int nullity) {
        this.computeNullspace(this.nullspace, matrix, nullity);
    }

    public void removeNullspaceComponent(DMatrixRMaj vectorToHaveNullspaceRemoved, DMatrixRMaj vectorWithNullspaceRemovedToPack) {
        this.iMinusNNT.reshape(this.nullspace.getNumRows(), this.nullspace.getNumRows());
        CommonOps_DDRM.multOuter((DMatrix1Row)this.nullspace, (DMatrix1Row)this.iMinusNNT);
        CommonOps_DDRM.scale((double)-1.0, (DMatrixD1)this.iMinusNNT);
        MatrixTools.addDiagonal((DMatrix)this.iMinusNNT, (double)1.0);
        this.iMinusNNTSolver.setA(this.iMinusNNT);
        this.iMinusNNTSolver.solve(vectorToHaveNullspaceRemoved, vectorWithNullspaceRemovedToPack);
    }

    public void removeNullspaceComponent(DMatrixRMaj vectorToHaveNullspaceRemoved) {
        this.tempMatrixForProjectionInPlace.set((DMatrixD1)vectorToHaveNullspaceRemoved);
        this.removeNullspaceComponent(this.tempMatrixForProjectionInPlace, vectorToHaveNullspaceRemoved);
    }

    public void addNullspaceComponent(DMatrixRMaj x, DMatrixRMaj nullspaceMultipliers) {
        CommonOps_DDRM.multAdd((DMatrix1Row)this.nullspace, (DMatrix1Row)nullspaceMultipliers, (DMatrix1Row)x);
    }

    public DMatrixRMaj getNullspace() {
        return this.nullspace;
    }

    private void computeNullspace(DMatrixRMaj nullspaceToPack, DMatrixRMaj matrixToComputeNullspaceOf, int nullity) {
        nullspaceToPack.reshape(matrixToComputeNullspaceOf.getNumCols(), nullity);
        this.Q.reshape(matrixToComputeNullspaceOf.getNumCols(), matrixToComputeNullspaceOf.getNumCols() - nullity);
        this.decomposer.decompose((Matrix)matrixToComputeNullspaceOf);
        this.sigma.reshape(matrixToComputeNullspaceOf.getNumCols(), matrixToComputeNullspaceOf.getNumRows());
        this.decomposer.getW((Matrix)this.sigma);
        this.v.reshape(matrixToComputeNullspaceOf.getNumCols(), matrixToComputeNullspaceOf.getNumCols());
        boolean transposed = false;
        this.decomposer.getV((Matrix)this.v, transposed);
        CommonOps_DDRM.extract((DMatrix)this.v, (int)0, (int)this.v.getNumRows(), (int)0, (int)(this.v.getNumCols() - nullity), (DMatrix)this.Q, (int)0, (int)0);
        CommonOps_DDRM.extract((DMatrix)this.v, (int)0, (int)this.v.getNumRows(), (int)(this.v.getNumCols() - nullity), (int)this.v.getNumCols(), (DMatrix)nullspaceToPack, (int)0, (int)0);
        if (this.makeLargestComponentPositive) {
            SVDNullspaceCalculator.makeLargestComponentInEachRowPositive(nullspaceToPack);
        }
    }

    public static void makeLargestComponentInEachRowPositive(DMatrixRMaj nullspace) {
        for (int column = 0; column < nullspace.getNumCols(); ++column) {
            int row;
            int largestAbsoluteComponentRow = -1;
            double largestAbsoluteComponentValue = 0.0;
            for (row = 0; row < nullspace.getNumRows(); ++row) {
                double absoluteComponentValue = Math.abs(nullspace.get(row, column));
                if (!(absoluteComponentValue > largestAbsoluteComponentValue)) continue;
                largestAbsoluteComponentRow = row;
                largestAbsoluteComponentValue = absoluteComponentValue;
            }
            if (!(nullspace.get(largestAbsoluteComponentRow, column) < 0.0)) continue;
            for (row = 0; row < nullspace.getNumRows(); ++row) {
                nullspace.set(row, column, -nullspace.get(row, column));
            }
        }
    }

    public static void makeLargestComponentInEachColumnPositive(DMatrixRMaj nullspaceTranspose) {
        for (int row = 0; row < nullspaceTranspose.getNumRows(); ++row) {
            int column;
            int largestAbsoluteComponentColumn = -1;
            double largestAbsoluteComponentValue = 0.0;
            for (column = 0; column < nullspaceTranspose.getNumCols(); ++column) {
                double absoluteComponentValue = Math.abs(nullspaceTranspose.get(row, column));
                if (!(absoluteComponentValue > largestAbsoluteComponentValue)) continue;
                largestAbsoluteComponentColumn = column;
                largestAbsoluteComponentValue = absoluteComponentValue;
            }
            if (!(nullspaceTranspose.get(row, largestAbsoluteComponentColumn) < 0.0)) continue;
            for (column = 0; column < nullspaceTranspose.getNumCols(); ++column) {
                nullspaceTranspose.set(row, column, -nullspaceTranspose.get(row, column));
            }
        }
    }
}

