/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.linearAlgebra;

import org.ejml.data.DMatrix;
import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.data.Matrix;
import org.ejml.dense.row.CommonOps_DDRM;
import org.ejml.dense.row.factory.DecompositionFactory_DDRM;
import org.ejml.interfaces.decomposition.QRDecomposition;
import us.ihmc.commons.MathTools;
import us.ihmc.robotics.linearAlgebra.NullspaceCalculator;

public class QRNullspaceCalculator
implements NullspaceCalculator {
    private final QRDecomposition<DMatrixRMaj> decomposer;
    private final DMatrixRMaj nullspace;
    private final DMatrixRMaj Q;
    private final DMatrixRMaj R;
    private final DMatrixRMaj nullspaceProjector;
    private final DMatrixRMaj tempMatrixForProjectionInPlace;
    private final DMatrixRMaj transposed = new DMatrixRMaj(0, 0);

    public QRNullspaceCalculator(int matrixSize) {
        MathTools.checkIntervalContains((long)matrixSize, (long)1L, (long)Integer.MAX_VALUE);
        this.nullspaceProjector = new DMatrixRMaj(matrixSize, matrixSize);
        this.tempMatrixForProjectionInPlace = new DMatrixRMaj(matrixSize, matrixSize);
        this.decomposer = DecompositionFactory_DDRM.qr((int)matrixSize, (int)matrixSize);
        this.nullspace = new DMatrixRMaj(matrixSize, matrixSize);
        this.Q = new DMatrixRMaj(matrixSize, matrixSize);
        this.R = new DMatrixRMaj(matrixSize, matrixSize);
    }

    @Override
    public void projectOntoNullspace(DMatrixRMaj matrixToProjectOntoNullspace, DMatrixRMaj matrixToComputeNullspaceOf) {
        this.tempMatrixForProjectionInPlace.set((DMatrixD1)matrixToProjectOntoNullspace);
        this.projectOntoNullspace(this.tempMatrixForProjectionInPlace, matrixToComputeNullspaceOf, matrixToProjectOntoNullspace);
    }

    @Override
    public void projectOntoNullspace(DMatrixRMaj matrixToProjectOntoNullspace, DMatrixRMaj matrixToComputeNullspaceOf, DMatrixRMaj projectedMatrixToPack) {
        this.computeNullspaceProjector(matrixToComputeNullspaceOf, this.nullspaceProjector);
        CommonOps_DDRM.mult((DMatrix1Row)matrixToProjectOntoNullspace, (DMatrix1Row)this.nullspaceProjector, (DMatrix1Row)projectedMatrixToPack);
    }

    @Override
    public void computeNullspaceProjector(DMatrixRMaj matrixToComputeNullspaceOf, DMatrixRMaj nullspaceProjectorToPack) {
        int nullity = Math.max(matrixToComputeNullspaceOf.getNumCols() - matrixToComputeNullspaceOf.getNumRows(), 0);
        this.computeNullspace(this.nullspace, matrixToComputeNullspaceOf, nullity);
        nullspaceProjectorToPack.reshape(matrixToComputeNullspaceOf.getNumCols(), matrixToComputeNullspaceOf.getNumCols());
        CommonOps_DDRM.multOuter((DMatrix1Row)this.nullspace, (DMatrix1Row)nullspaceProjectorToPack);
    }

    private void computeNullspace(DMatrixRMaj nullspaceToPack, DMatrixRMaj matrixToComputeNullspaceOf, int nullity) {
        int size = matrixToComputeNullspaceOf.getNumCols();
        int rank = matrixToComputeNullspaceOf.getNumRows();
        nullspaceToPack.reshape(size, nullity);
        this.Q.reshape(size, size);
        this.R.reshape(size, rank);
        this.transposed.reshape(size, rank);
        CommonOps_DDRM.transpose((DMatrixRMaj)matrixToComputeNullspaceOf, (DMatrixRMaj)this.transposed);
        this.decomposer.decompose((Matrix)this.transposed);
        this.decomposer.getQ((Matrix)this.Q, false);
        CommonOps_DDRM.extract((DMatrix)this.Q, (int)0, (int)this.Q.getNumRows(), (int)(this.Q.getNumCols() - nullity), (int)this.Q.getNumCols(), (DMatrix)nullspaceToPack, (int)0, (int)0);
    }
}

