/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.linearAlgebra;

import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.data.Matrix;
import org.ejml.dense.row.CommonOps_DDRM;
import org.ejml.dense.row.NormOps_DDRM;
import org.ejml.dense.row.factory.LinearSolverFactory_DDRM;
import org.ejml.interfaces.linsol.LinearSolverDense;
import us.ihmc.matrixlib.MatrixTools;

public class MatrixExponentialCalculator {
    private int size;
    private final DMatrixRMaj As = new DMatrixRMaj(0, 0);
    private final DMatrixRMaj As_2 = new DMatrixRMaj(0, 0);
    private final DMatrixRMaj As_4 = new DMatrixRMaj(0, 0);
    private final DMatrixRMaj As_6 = new DMatrixRMaj(0, 0);
    private final DMatrixRMaj U = new DMatrixRMaj(0, 0);
    private final DMatrixRMaj V = new DMatrixRMaj(0, 0);
    private final DMatrixRMaj AV = new DMatrixRMaj(0, 0);
    private final DMatrixRMaj N = new DMatrixRMaj(0, 0);
    private final DMatrixRMaj D = new DMatrixRMaj(0, 0);
    private final DMatrixRMaj temp = new DMatrixRMaj(0, 0);
    private final LinearSolverDense<DMatrixRMaj> solver;
    private static final double c0 = 1.0;
    private static final double c1 = 0.5;
    private static final double c2 = 0.12;
    private static final double c3 = 0.01833333333333333;
    private static final double c4 = 0.0019927536231884053;
    private static final double c5 = 1.630434782608695E-4;
    private static final double c6 = 1.0351966873706E-5;
    private static final double c7 = 5.175983436853E-7;
    private static final double c8 = 2.0431513566525E-8;
    private static final double c9 = 6.306022705717593E-10;
    private static final double c10 = 1.4837700484041396E-11;
    private static final double c11 = 2.5291534915979653E-13;
    private static final double c12 = 2.8101705462199615E-15;
    private static final double c13 = 1.5440497506703084E-17;

    public MatrixExponentialCalculator(int size) {
        this.reshape(size);
        this.solver = LinearSolverFactory_DDRM.linear((int)size);
    }

    public void reshape(int size) {
        this.size = size;
        this.As.reshape(size, size);
        this.As_2.reshape(size, size);
        this.As_4.reshape(size, size);
        this.As_6.reshape(size, size);
        this.U.reshape(size, size);
        this.V.reshape(size, size);
        this.AV.reshape(size, size);
        this.N.reshape(size, size);
        this.D.reshape(size, size);
        this.temp.reshape(size, size);
    }

    public void compute(DMatrixRMaj result, DMatrixRMaj A) {
        MatrixTools.checkMatrixDimensions((DMatrix1Row)A, (int)this.size, (int)this.size);
        int j = Math.max(0, 1 + (int)Math.floor(Math.log(NormOps_DDRM.normPInf((DMatrixRMaj)A)) / Math.log(2.0)));
        this.As.set((DMatrixD1)A);
        CommonOps_DDRM.scale((double)(1.0 / Math.pow(2.0, j)), (DMatrixD1)this.As);
        CommonOps_DDRM.mult((DMatrix1Row)this.As, (DMatrix1Row)this.As, (DMatrix1Row)this.As_2);
        CommonOps_DDRM.mult((DMatrix1Row)this.As_2, (DMatrix1Row)this.As_2, (DMatrix1Row)this.As_4);
        CommonOps_DDRM.mult((DMatrix1Row)this.As_4, (DMatrix1Row)this.As_2, (DMatrix1Row)this.As_6);
        MatrixTools.setDiagonal((DMatrix1Row)this.U, (double)1.0);
        CommonOps_DDRM.addEquals((DMatrixD1)this.U, (double)0.12, (DMatrixD1)this.As_2);
        CommonOps_DDRM.addEquals((DMatrixD1)this.U, (double)0.0019927536231884053, (DMatrixD1)this.As_4);
        MatrixTools.setDiagonal((DMatrix1Row)this.temp, (double)1.0351966873706E-5);
        CommonOps_DDRM.addEquals((DMatrixD1)this.temp, (double)2.0431513566525E-8, (DMatrixD1)this.As_2);
        CommonOps_DDRM.addEquals((DMatrixD1)this.temp, (double)1.4837700484041396E-11, (DMatrixD1)this.As_4);
        CommonOps_DDRM.addEquals((DMatrixD1)this.temp, (double)2.8101705462199615E-15, (DMatrixD1)this.As_6);
        CommonOps_DDRM.multAdd((DMatrix1Row)this.temp, (DMatrix1Row)this.As_6, (DMatrix1Row)this.U);
        MatrixTools.setDiagonal((DMatrix1Row)this.V, (double)0.5);
        CommonOps_DDRM.addEquals((DMatrixD1)this.V, (double)0.01833333333333333, (DMatrixD1)this.As_2);
        CommonOps_DDRM.addEquals((DMatrixD1)this.V, (double)1.630434782608695E-4, (DMatrixD1)this.As_4);
        MatrixTools.setDiagonal((DMatrix1Row)this.temp, (double)5.175983436853E-7);
        CommonOps_DDRM.addEquals((DMatrixD1)this.temp, (double)6.306022705717593E-10, (DMatrixD1)this.As_2);
        CommonOps_DDRM.addEquals((DMatrixD1)this.temp, (double)2.5291534915979653E-13, (DMatrixD1)this.As_4);
        CommonOps_DDRM.addEquals((DMatrixD1)this.temp, (double)1.5440497506703084E-17, (DMatrixD1)this.As_6);
        CommonOps_DDRM.multAdd((DMatrix1Row)this.temp, (DMatrix1Row)this.As_6, (DMatrix1Row)this.V);
        CommonOps_DDRM.mult((DMatrix1Row)this.As, (DMatrix1Row)this.V, (DMatrix1Row)this.AV);
        CommonOps_DDRM.add((DMatrixD1)this.U, (DMatrixD1)this.AV, (DMatrixD1)this.N);
        CommonOps_DDRM.subtract((DMatrixD1)this.U, (DMatrixD1)this.AV, (DMatrixD1)this.D);
        this.solver.setA((Matrix)this.D);
        this.solver.solve((Matrix)this.N, (Matrix)result);
        for (int k = 0; k < j; ++k) {
            this.temp.set((DMatrixD1)result);
            CommonOps_DDRM.mult((DMatrix1Row)this.temp, (DMatrix1Row)this.temp, (DMatrix1Row)result);
        }
    }
}

