/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.linearAlgebra;

import org.ejml.data.DMatrix;
import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.data.Matrix;
import org.ejml.dense.row.CommonOps_DDRM;
import org.ejml.dense.row.factory.DecompositionFactory_DDRM;
import org.ejml.interfaces.decomposition.SingularValueDecomposition_F64;
import us.ihmc.commons.MathTools;
import us.ihmc.matrixlib.DiagonalMatrixTools;
import us.ihmc.matrixlib.MatrixTools;
import us.ihmc.robotics.linearAlgebra.DampedNullspaceCalculator;

public class DampedSVDNullspaceCalculator
implements DampedNullspaceCalculator {
    private final SingularValueDecomposition_F64<DMatrixRMaj> decomposer;
    private final DMatrixRMaj sigma;
    private final DMatrixRMaj sigmaDampedSigma;
    private final DMatrixRMaj v;
    private final DMatrixRMaj nullspace;
    private final DMatrixRMaj Q;
    private final DMatrixRMaj nullspaceProjector;
    private final DMatrixRMaj tempMatrixForProjectionInPlace;
    private final DMatrixRMaj tempMatrix = new DMatrixRMaj(0, 0);
    private double alpha = 0.0;

    public DampedSVDNullspaceCalculator(int matrixSize, double alpha) {
        MathTools.checkIntervalContains((long)matrixSize, (long)1L, (long)Integer.MAX_VALUE);
        this.alpha = alpha;
        this.nullspaceProjector = new DMatrixRMaj(matrixSize, matrixSize);
        this.tempMatrixForProjectionInPlace = new DMatrixRMaj(matrixSize, matrixSize);
        this.decomposer = DecompositionFactory_DDRM.svd((int)matrixSize, (int)matrixSize, (boolean)false, (boolean)true, (boolean)false);
        this.sigma = new DMatrixRMaj(matrixSize, matrixSize);
        this.sigmaDampedSigma = new DMatrixRMaj(matrixSize, matrixSize);
        this.v = new DMatrixRMaj(matrixSize, matrixSize);
        this.nullspace = new DMatrixRMaj(matrixSize, matrixSize);
        this.Q = new DMatrixRMaj(matrixSize, matrixSize);
    }

    @Override
    public void setPseudoInverseAlpha(double alpha) {
        this.alpha = alpha;
    }

    @Override
    public void projectOntoNullspace(DMatrixRMaj matrixToProjectOntoNullspace, DMatrixRMaj matrixToComputeNullspaceOf) {
        this.tempMatrixForProjectionInPlace.set((DMatrixD1)matrixToProjectOntoNullspace);
        this.projectOntoNullspace(this.tempMatrixForProjectionInPlace, matrixToComputeNullspaceOf, matrixToProjectOntoNullspace);
    }

    @Override
    public void projectOntoNullspace(DMatrixRMaj matrixToProjectOntoNullspace, DMatrixRMaj matrixToComputeNullspaceOf, DMatrixRMaj projectedMatrixToPack) {
        this.computeNullspaceProjector(matrixToComputeNullspaceOf, this.nullspaceProjector);
        CommonOps_DDRM.mult((DMatrix1Row)matrixToProjectOntoNullspace, (DMatrix1Row)this.nullspaceProjector, (DMatrix1Row)projectedMatrixToPack);
    }

    @Override
    public void computeNullspaceProjector(DMatrixRMaj matrixToComputeNullspaceOf, DMatrixRMaj nullspaceProjectorToPack) {
        int nullity = Math.max(matrixToComputeNullspaceOf.getNumCols() - matrixToComputeNullspaceOf.getNumRows(), 0);
        this.computeNullspace(this.nullspace, this.Q, matrixToComputeNullspaceOf, nullity);
        nullspaceProjectorToPack.reshape(matrixToComputeNullspaceOf.getNumCols(), matrixToComputeNullspaceOf.getNumCols());
        if (this.alpha == 0.0) {
            nullspaceProjectorToPack.reshape(matrixToComputeNullspaceOf.getNumCols(), matrixToComputeNullspaceOf.getNumCols());
            CommonOps_DDRM.multOuter((DMatrix1Row)this.nullspace, (DMatrix1Row)nullspaceProjectorToPack);
        } else {
            this.computeDampedSigmaOperator(this.sigmaDampedSigma, this.sigma, this.alpha);
            this.tempMatrix.reshape(this.v.getNumRows(), this.sigmaDampedSigma.getNumCols());
            DiagonalMatrixTools.postMult((DMatrix1Row)this.Q, (DMatrix1Row)this.sigmaDampedSigma, (DMatrix1Row)this.tempMatrix);
            CommonOps_DDRM.multTransB((double)-1.0, (DMatrix1Row)this.tempMatrix, (DMatrix1Row)this.Q, (DMatrix1Row)nullspaceProjectorToPack);
            MatrixTools.addDiagonal((DMatrix)nullspaceProjectorToPack, (double)1.0);
        }
    }

    private void computeNullspace(DMatrixRMaj nullspaceToPack, DMatrixRMaj QToPack, DMatrixRMaj matrixToComputeNullspaceOf, int nullity) {
        nullspaceToPack.reshape(matrixToComputeNullspaceOf.getNumCols(), nullity);
        this.decomposer.decompose((Matrix)matrixToComputeNullspaceOf);
        this.sigma.reshape(matrixToComputeNullspaceOf.getNumCols(), matrixToComputeNullspaceOf.getNumRows());
        this.decomposer.getW((Matrix)this.sigma);
        this.v.reshape(matrixToComputeNullspaceOf.getNumCols(), matrixToComputeNullspaceOf.getNumCols());
        QToPack.reshape(matrixToComputeNullspaceOf.getNumCols(), matrixToComputeNullspaceOf.getNumCols() - nullity);
        boolean transposed = false;
        this.decomposer.getV((Matrix)this.v, transposed);
        CommonOps_DDRM.extract((DMatrix)this.v, (int)0, (int)this.v.getNumRows(), (int)0, (int)(this.v.getNumCols() - nullity), (DMatrix)QToPack, (int)0, (int)0);
        CommonOps_DDRM.extract((DMatrix)this.v, (int)0, (int)this.v.getNumRows(), (int)(this.v.getNumCols() - nullity), (int)this.v.getNumCols(), (DMatrix)nullspaceToPack, (int)0, (int)0);
    }

    private void computeDampedSigmaOperator(DMatrixRMaj dampedSigmaToPack, DMatrixRMaj sigma, double alpha) {
        int minor = Math.min(sigma.getNumRows(), sigma.getNumCols());
        dampedSigmaToPack.reshape(minor, minor);
        dampedSigmaToPack.zero();
        for (int i = 0; i < minor; ++i) {
            double sigmaValue = sigma.get(i, i);
            double dampedSigma = sigmaValue * sigmaValue / (sigmaValue * sigmaValue + alpha * alpha);
            dampedSigmaToPack.set(i, i, dampedSigma);
        }
    }
}

