/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.linearAlgebra;

import org.ejml.data.DMatrix;
import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import us.ihmc.matrixlib.MatrixTools;
import us.ihmc.robotics.functionApproximation.DampedLeastSquaresSolver;
import us.ihmc.robotics.linearAlgebra.DampedNullspaceCalculator;

public class DampedLeastSquaresNullspaceCalculator
implements DampedNullspaceCalculator {
    private final DampedLeastSquaresSolver pseudoInverseSolver;
    private final DMatrixRMaj nullspaceProjector;
    private final DMatrixRMaj tempMatrixForProjectionInPlace;

    public DampedLeastSquaresNullspaceCalculator(int matrixSize, double alpha) {
        this.pseudoInverseSolver = new DampedLeastSquaresSolver(matrixSize, alpha);
        this.nullspaceProjector = new DMatrixRMaj(matrixSize, matrixSize);
        this.tempMatrixForProjectionInPlace = new DMatrixRMaj(matrixSize, matrixSize);
    }

    @Override
    public void setPseudoInverseAlpha(double alpha) {
        this.pseudoInverseSolver.setAlpha(alpha);
    }

    @Override
    public void computeNullspaceProjector(DMatrixRMaj matrixToComputeNullspaceOf, DMatrixRMaj nullspaceProjectorToPack) {
        this.pseudoInverseSolver.setA(matrixToComputeNullspaceOf);
        this.pseudoInverseSolver.solve(matrixToComputeNullspaceOf, nullspaceProjectorToPack);
        CommonOps_DDRM.scale((double)-1.0, (DMatrixD1)nullspaceProjectorToPack);
        MatrixTools.addDiagonal((DMatrix)nullspaceProjectorToPack, (double)1.0);
    }

    @Override
    public void projectOntoNullspace(DMatrixRMaj matrixToProjectOntoNullspace, DMatrixRMaj matrixToComputeNullspaceOf) {
        this.tempMatrixForProjectionInPlace.set((DMatrixD1)matrixToProjectOntoNullspace);
        this.projectOntoNullspace(this.tempMatrixForProjectionInPlace, matrixToComputeNullspaceOf, matrixToProjectOntoNullspace);
    }

    @Override
    public void projectOntoNullspace(DMatrixRMaj matrixToProjectOntoNullspace, DMatrixRMaj matrixToComputeNullspaceOf, DMatrixRMaj projectedMatrixToPack) {
        int nullSize = matrixToComputeNullspaceOf.getNumCols();
        this.nullspaceProjector.reshape(nullSize, nullSize);
        projectedMatrixToPack.reshape(matrixToProjectOntoNullspace.getNumRows(), nullSize);
        this.computeNullspaceProjector(matrixToComputeNullspaceOf, this.nullspaceProjector);
        CommonOps_DDRM.mult((DMatrix1Row)matrixToProjectOntoNullspace, (DMatrix1Row)this.nullspaceProjector, (DMatrix1Row)projectedMatrixToPack);
    }
}

