/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.lidar;

import java.util.Random;

public class LidarScanParameters {
    public long timestamp;
    public float sweepYawMax;
    public float sweepYawMin;
    public float heightPitchMax;
    public float heightPitchMin;
    public float timeIncrement;
    public float scanTime;
    public float minRange;
    public float maxRange;
    public int pointsPerSweep;
    public int scanHeight;

    public LidarScanParameters() {
    }

    public LidarScanParameters(LidarScanParameters p, long timestamp) {
        this(p.pointsPerSweep, p.scanHeight, p.sweepYawMin, p.sweepYawMax, p.heightPitchMin, p.heightPitchMax, p.timeIncrement, p.minRange, p.maxRange, p.scanTime, timestamp);
    }

    public LidarScanParameters(int pointsPerSweep, float sweepYawMin, float sweepYawMax, float timeIncrement, float minRange, float maxRange, float scanTime) {
        this(pointsPerSweep, 1, sweepYawMin, sweepYawMax, timeIncrement, minRange, maxRange, scanTime, 0L);
    }

    public LidarScanParameters(int pointsPerSweep, float sweepYawMin, float sweepYawMax, float minRange, float maxRange) {
        this(pointsPerSweep, 1, sweepYawMin, sweepYawMax, 0.0f, minRange, maxRange, 0.0f, 0L);
    }

    public LidarScanParameters(int pointsPerSweep, double sweepYawMin, double sweepYawMax, double timeIncrement, double minRange, double maxRange, double scanTime) {
        this(pointsPerSweep, 1, (float)sweepYawMin, (float)sweepYawMax, (float)timeIncrement, (float)minRange, (float)maxRange, (float)scanTime, 0L);
    }

    public LidarScanParameters(int pointsPerSweep, double sweepYawMin, double sweepYawMax, double minRange, double maxRange) {
        this(pointsPerSweep, 1, (float)sweepYawMin, (float)sweepYawMax, 0.0f, (float)minRange, (float)maxRange, 0.0f, 0L);
    }

    public LidarScanParameters(int pointsPerSweep, double fieldOfView, double minRange, double maxRange) {
        this(pointsPerSweep, 1, (float)(-fieldOfView / 2.0), (float)(fieldOfView / 2.0), 0.0f, (float)minRange, (float)maxRange, 0.0f, 0L);
    }

    public LidarScanParameters(int pointsPerSweep, int scanHeight, float sweepYawMin, float sweepYawMax, float timeIncrement, float minRange, float maxRange, float scanTime, long timestamp) {
        this(pointsPerSweep, scanHeight, sweepYawMin, sweepYawMax, 0.0f, 0.0f, timeIncrement, minRange, maxRange, scanTime, timestamp);
    }

    public LidarScanParameters(int pointsPerSweep, int scanHeight, float sweepYawMin, float sweepYawMax, float heightPitchMin, float heightPitchMax, float timeIncrement, float minRange, float maxRange, float scanTime, long timestamp) {
        this.timestamp = timestamp;
        this.sweepYawMax = sweepYawMax;
        this.sweepYawMin = sweepYawMin;
        this.heightPitchMax = heightPitchMax;
        this.heightPitchMin = heightPitchMin;
        this.timeIncrement = timeIncrement;
        this.scanTime = scanTime;
        this.minRange = minRange;
        this.maxRange = maxRange;
        this.pointsPerSweep = pointsPerSweep;
        this.scanHeight = scanHeight;
    }

    public LidarScanParameters(Random random) {
        this.timestamp = random.nextLong();
        this.sweepYawMax = random.nextFloat();
        this.sweepYawMin = random.nextFloat();
        this.timeIncrement = random.nextFloat();
        this.scanTime = random.nextFloat();
        this.minRange = random.nextFloat();
        this.maxRange = random.nextFloat();
        this.pointsPerSweep = random.nextInt();
    }

    public String toString() {
        return "PolarLidarScanParameters{\n sweepYawMax=" + this.sweepYawMax + ",\n sweepYawMin=" + this.sweepYawMin + ",\n angleIncrement=,\n timeIncrement=" + this.timeIncrement + ",\n scanTime=" + this.scanTime + ",\n minRange=" + this.minRange + ",\n maxRange=" + this.maxRange + ",\n pointsPerSweep=" + this.pointsPerSweep + '}';
    }

    public float getFieldOfView() {
        return this.sweepYawMax - this.sweepYawMin;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public float getTimeIncrement() {
        return this.timeIncrement;
    }

    public float getScanTime() {
        return this.scanTime;
    }

    public long getScanTimeNanos() {
        return (long)(this.scanTime * 1.0E9f);
    }

    public float getSweepYawMax() {
        return this.sweepYawMax;
    }

    public float getSweepYawMin() {
        return this.sweepYawMin;
    }

    public float getAngleIncrement() {
        return (this.sweepYawMax - this.sweepYawMin) / (float)this.pointsPerSweep;
    }

    public float getMinRange() {
        return this.minRange;
    }

    public float getMaxRange() {
        return this.maxRange;
    }

    public int getPointsPerSweep() {
        return this.pointsPerSweep;
    }

    public int getScanHeight() {
        return this.scanHeight;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public void setSweepYawMax(double sweepYawMax) {
        this.sweepYawMax = (float)sweepYawMax;
    }

    public void setSweepYawMin(double sweepYawMin) {
        this.sweepYawMin = (float)sweepYawMin;
    }

    public void setHeightPitchMax(double heightPitchMax) {
        this.heightPitchMax = (float)heightPitchMax;
    }

    public void setHeightPitchMin(double heightPitchMin) {
        this.heightPitchMin = (float)heightPitchMin;
    }

    public void setTimeIncrement(double timeIncrement) {
        this.timeIncrement = (float)timeIncrement;
    }

    public void setScanTime(double scanTime) {
        this.scanTime = (float)scanTime;
    }

    public void setMinRange(double minRange) {
        this.minRange = (float)minRange;
    }

    public void setMaxRange(double maxRange) {
        this.maxRange = (float)maxRange;
    }

    public void setPointsPerSweep(int pointsPerSweep) {
        this.pointsPerSweep = pointsPerSweep;
    }

    public void setScanHeight(int scanHeight) {
        this.scanHeight = scanHeight;
    }

    public void setFieldOfView(double fieldOfView) {
        this.sweepYawMin = (float)(-(fieldOfView / 2.0));
        this.sweepYawMax = (float)(fieldOfView / 2.0);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Float.floatToIntBits(this.maxRange);
        result = 31 * result + Float.floatToIntBits(this.minRange);
        result = 31 * result + this.pointsPerSweep;
        result = 31 * result + Float.floatToIntBits(this.scanTime);
        result = 31 * result + Float.floatToIntBits(this.sweepYawMax);
        result = 31 * result + Float.floatToIntBits(this.sweepYawMin);
        result = 31 * result + Float.floatToIntBits(this.timeIncrement);
        result = 31 * result + (int)(this.timestamp ^ this.timestamp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LidarScanParameters other = (LidarScanParameters)obj;
        if (Float.floatToIntBits(this.maxRange) != Float.floatToIntBits(other.maxRange)) {
            return false;
        }
        if (Float.floatToIntBits(this.minRange) != Float.floatToIntBits(other.minRange)) {
            return false;
        }
        if (this.pointsPerSweep != other.pointsPerSweep) {
            return false;
        }
        if (Float.floatToIntBits(this.scanTime) != Float.floatToIntBits(other.scanTime)) {
            return false;
        }
        if (Float.floatToIntBits(this.sweepYawMax) != Float.floatToIntBits(other.sweepYawMax)) {
            return false;
        }
        if (Float.floatToIntBits(this.sweepYawMin) != Float.floatToIntBits(other.sweepYawMin)) {
            return false;
        }
        if (Float.floatToIntBits(this.timeIncrement) != Float.floatToIntBits(other.timeIncrement)) {
            return false;
        }
        return this.timestamp == other.timestamp;
    }
}

