/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.kinematics.fourbar;

import java.util.Objects;
import us.ihmc.robotics.kinematics.fourbar.FourBarAngle;
import us.ihmc.robotics.kinematics.fourbar.FourBarDiagonal;
import us.ihmc.robotics.kinematics.fourbar.FourBarEdge;
import us.ihmc.robotics.kinematics.fourbar.FourBarTools;

public class FourBarVertex {
    private final String name;
    private final FourBarAngle fourBarAngle;
    private double angle;
    private double angleDot;
    private double angleDDot;
    protected double minAngle;
    protected double maxAngle;
    private boolean convex = true;
    private FourBarEdge nextEdge;
    private FourBarEdge previousEdge;
    private FourBarDiagonal diagonal;

    FourBarVertex(String name, FourBarAngle fourBarAngle) {
        this.name = name;
        this.fourBarAngle = fourBarAngle;
    }

    void setup(FourBarEdge previousEdge, FourBarEdge nextEdge, FourBarDiagonal diagonal) {
        this.nextEdge = nextEdge;
        this.previousEdge = previousEdge;
        this.diagonal = diagonal;
    }

    void checkProperlySetup() {
        Objects.requireNonNull(this.nextEdge);
        Objects.requireNonNull(this.previousEdge);
        Objects.requireNonNull(this.diagonal);
        if (this.nextEdge.getStart() != this) {
            throw new IllegalStateException("Improper configuration of the four bar.");
        }
        if (this.previousEdge.getEnd() != this) {
            throw new IllegalStateException("Improper configuration of the four bar.");
        }
        if (this.diagonal.getStart() != this && this.diagonal.getEnd() != this) {
            throw new IllegalStateException("Improper configuration of the four bar.");
        }
    }

    protected void updateLimits() {
        FourBarTools.updateLimits(this);
    }

    public void setToNaN() {
        this.angle = Double.NaN;
        this.angleDot = Double.NaN;
        this.angleDDot = Double.NaN;
        this.minAngle = Double.NaN;
        this.maxAngle = Double.NaN;
    }

    public void setToMin() {
        this.angle = this.getMinAngle();
        this.angleDot = 0.0;
        this.angleDDot = 0.0;
    }

    public void setToMax() {
        this.angle = this.getMaxAngle();
        this.angleDot = 0.0;
        this.angleDDot = 0.0;
    }

    void setAngle(double angle) {
        this.angle = angle;
    }

    void setAngleDot(double angleDot) {
        this.angleDot = angleDot;
    }

    void setAngleDDot(double angleDDot) {
        this.angleDDot = angleDDot;
    }

    void setMinAngle(double minAngle) {
        this.minAngle = minAngle;
    }

    void setMaxAngle(double maxAngle) {
        this.maxAngle = maxAngle;
    }

    void setConvex(boolean convex) {
        this.convex = convex;
    }

    public String getName() {
        return this.name;
    }

    public FourBarAngle getFourBarAngle() {
        return this.fourBarAngle;
    }

    public double getAngle() {
        return this.angle;
    }

    public double getAngleDot() {
        return this.angleDot;
    }

    public double getAngleDDot() {
        return this.angleDDot;
    }

    public double getMinAngle() {
        if (Double.isNaN(this.minAngle)) {
            this.updateLimits();
        }
        return this.minAngle;
    }

    public double getMaxAngle() {
        if (Double.isNaN(this.maxAngle)) {
            this.updateLimits();
        }
        return this.maxAngle;
    }

    public boolean isConvex() {
        return this.convex;
    }

    public FourBarEdge getNextEdge() {
        return this.nextEdge;
    }

    public FourBarEdge getPreviousEdge() {
        return this.previousEdge;
    }

    public FourBarDiagonal getDiagonal() {
        return this.diagonal;
    }

    public FourBarVertex getNextVertex() {
        return this.nextEdge.getEnd();
    }

    public FourBarVertex getPreviousVertex() {
        return this.previousEdge.getStart();
    }

    public FourBarVertex getOppositeVertex() {
        return this.nextEdge.getNext().getEnd();
    }

    public String toString() {
        return String.format("%s: [angle=%f, angleDot=%f, angleDDot=%f, convex=%b]", this.getName(), this.getAngle(), this.getAngleDot(), this.getAngleDDot(), this.isConvex());
    }
}

