/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.kinematics.fourbar;

import java.util.Objects;
import us.ihmc.robotics.kinematics.fourbar.FourBarVertex;

public class FourBarEdge {
    private final String name;
    private double length;
    private FourBarVertex start;
    private FourBarVertex end;
    private FourBarEdge next;
    private FourBarEdge previous;

    FourBarEdge(String name) {
        this.name = name;
    }

    void setup(FourBarVertex start, FourBarVertex end, FourBarEdge previous, FourBarEdge next) {
        this.start = start;
        this.end = end;
        this.previous = previous;
        this.next = next;
    }

    void checkProperlySetup() {
        Objects.requireNonNull(this.start);
        Objects.requireNonNull(this.end);
        Objects.requireNonNull(this.next);
        Objects.requireNonNull(this.previous);
        if (this.start.getNextEdge() != this) {
            throw new IllegalStateException("Improper configuration of the four bar.");
        }
        if (this.end.getPreviousEdge() != this) {
            throw new IllegalStateException("Improper configuration of the four bar.");
        }
        if (this.next.getPrevious() != this) {
            throw new IllegalStateException("Improper configuration of the four bar.");
        }
        if (this.previous.getNext() != this) {
            throw new IllegalStateException("Improper configuration of the four bar.");
        }
    }

    public void setToNaN() {
        this.length = Double.NaN;
    }

    void setLength(double length) {
        this.length = length;
    }

    public String getName() {
        return this.name;
    }

    public double getLength() {
        return this.length;
    }

    public boolean isFlipped() {
        return !this.start.isConvex() && !this.end.isConvex();
    }

    public boolean isCrossing() {
        return this.next.isFlipped() || this.previous.isFlipped();
    }

    public FourBarVertex getStart() {
        return this.start;
    }

    public FourBarVertex getEnd() {
        return this.end;
    }

    public FourBarEdge getNext() {
        return this.next;
    }

    public FourBarEdge getPrevious() {
        return this.previous;
    }

    public String toString() {
        return String.format("%s: [length=%f, flipped=%b, crossing=%b]", this.getName(), this.getLength(), this.isFlipped(), this.isCrossing());
    }
}

