/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.kinematics.fourbar;

import java.util.Objects;
import us.ihmc.robotics.kinematics.fourbar.FourBarVertex;

public class FourBarDiagonal {
    private final String name;
    private double length;
    private double lengthDot;
    private double lengthDDot;
    private FourBarVertex start;
    private FourBarVertex end;
    private FourBarDiagonal other;

    FourBarDiagonal(String name) {
        this.name = name;
    }

    void setup(FourBarVertex start, FourBarVertex end, FourBarDiagonal other) {
        this.start = start;
        this.end = end;
        this.other = other;
    }

    void checkProperlySetup() {
        Objects.requireNonNull(this.start);
        Objects.requireNonNull(this.end);
        Objects.requireNonNull(this.other);
        if (this.start.getDiagonal() != this) {
            throw new IllegalStateException("Improper configuration of the four bar.");
        }
        if (this.end.getDiagonal() != this) {
            throw new IllegalStateException("Improper configuration of the four bar.");
        }
        if (this.other.getOther() != this) {
            throw new IllegalStateException("Improper configuration of the four bar.");
        }
    }

    public void setToNaN() {
        this.length = Double.NaN;
        this.lengthDot = Double.NaN;
        this.lengthDDot = Double.NaN;
    }

    void setLength(double length) {
        this.length = length;
    }

    void setLengthDot(double lengthDot) {
        this.lengthDot = lengthDot;
    }

    public void setLengthDDot(double lengthDDot) {
        this.lengthDDot = lengthDDot;
    }

    public String getName() {
        return this.name;
    }

    public double getLength() {
        return this.length;
    }

    public double getLengthDot() {
        return this.lengthDot;
    }

    public double getLengthDDot() {
        return this.lengthDDot;
    }

    public FourBarVertex getStart() {
        return this.start;
    }

    public FourBarVertex getEnd() {
        return this.end;
    }

    public FourBarDiagonal getOther() {
        return this.other;
    }

    public String toString() {
        return String.format("%s [length=%f, lengthDot=%f, lengthDDot=%f]", this.getName(), this.getLength(), this.getLengthDot(), this.getLengthDDot());
    }
}

