/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.kinematics;

import java.util.Random;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.data.Matrix;
import org.ejml.dense.row.CommonOps_DDRM;
import org.ejml.dense.row.NormOps_DDRM;
import org.ejml.dense.row.factory.LinearSolverFactory_DDRM;
import org.ejml.interfaces.linsol.LinearSolverDense;
import us.ihmc.commons.MathTools;
import us.ihmc.commons.RandomNumbers;
import us.ihmc.euclid.axisAngle.AxisAngle;
import us.ihmc.euclid.geometry.Pose3D;
import us.ihmc.euclid.geometry.interfaces.Pose3DBasics;
import us.ihmc.euclid.matrix.RotationMatrix;
import us.ihmc.euclid.matrix.interfaces.RotationMatrixReadOnly;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.JointReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointBasics;
import us.ihmc.mecano.spatial.Twist;
import us.ihmc.mecano.spatial.interfaces.TwistReadOnly;
import us.ihmc.mecano.tools.MultiBodySystemStateIntegrator;
import us.ihmc.mecano.tools.MultiBodySystemTools;
import us.ihmc.robotics.kinematics.InverseKinematicsCalculator;
import us.ihmc.robotics.kinematics.InverseKinematicsStepListener;
import us.ihmc.robotics.screwTheory.GeometricJacobian;

public class ReNumericalInverseKinematicsCalculator
implements InverseKinematicsCalculator {
    private final GeometricJacobian jacobian;
    private final LinearSolverDense<DMatrixRMaj> solver;
    private final OneDoFJointBasics[] oneDoFJoints;
    private final OneDoFJointBasics[] oneDoFJointsSeed;
    private final double tolerance;
    private final int maxIterations;
    private final double maxStepSize;
    private final Random random = new Random(1251253L);
    private int iterationNumber;
    private double errorScalar;
    private double bestErrorScalar;
    private final RigidBodyTransform actualTransform = new RigidBodyTransform();
    private final RigidBodyTransform errorTransform = new RigidBodyTransform();
    private final AxisAngle errorAxisAngle = new AxisAngle();
    private final RotationMatrix errorRotationMatrix = new RotationMatrix();
    private final Vector3D errorRotationVector = new Vector3D();
    private final Vector3D axis = new Vector3D();
    private final Vector3D errorTranslationVector = new Vector3D();
    private final DMatrixRMaj error = new DMatrixRMaj(6, 1);
    private final DMatrixRMaj correction;
    private final DMatrixRMaj current;
    private final DMatrixRMaj best;
    private final double minRandomSearchScalar;
    private final double maxRandomSearchScalar;
    private int counter;
    private boolean useSeed;

    public ReNumericalInverseKinematicsCalculator(GeometricJacobian jacobian, double tolerance, int maxIterations, double maxStepSize, double minRandomSearchScalar, double maxRandomSearchScalar) {
        if (jacobian.getJacobianFrame() != jacobian.getEndEffectorFrame()) {
            throw new RuntimeException("jacobian.getJacobianFrame() != jacobian.getEndEffectorFrame()");
        }
        this.jacobian = jacobian;
        this.solver = LinearSolverFactory_DDRM.leastSquares((int)6, (int)jacobian.getNumberOfColumns());
        this.oneDoFJoints = (OneDoFJointBasics[])MultiBodySystemTools.filterJoints((JointReadOnly[])jacobian.getJointsInOrder(), OneDoFJointBasics.class);
        this.oneDoFJointsSeed = (OneDoFJointBasics[])this.oneDoFJoints.clone();
        if (this.oneDoFJoints.length != jacobian.getJointsInOrder().length) {
            throw new RuntimeException("Can currently only handle OneDoFJoints");
        }
        int nDoF = MultiBodySystemTools.computeDegreesOfFreedom((JointReadOnly[])this.oneDoFJoints);
        this.correction = new DMatrixRMaj(nDoF, 1);
        this.current = new DMatrixRMaj(nDoF, 1);
        this.best = new DMatrixRMaj(nDoF, 1);
        this.tolerance = tolerance;
        this.maxIterations = maxIterations;
        this.maxStepSize = maxStepSize;
        this.minRandomSearchScalar = minRandomSearchScalar;
        this.maxRandomSearchScalar = maxRandomSearchScalar;
        this.counter = 0;
    }

    @Override
    public boolean solve(RigidBodyTransform desiredTransform) {
        this.iterationNumber = 0;
        this.bestErrorScalar = Double.POSITIVE_INFINITY;
        do {
            this.computeError(desiredTransform);
            this.updateBest();
            this.computeCorrection();
            this.applyCorrection();
            ++this.iterationNumber;
        } while (this.errorScalar > this.tolerance && this.iterationNumber < this.maxIterations);
        this.updateBest();
        this.setJointAngles(this.best);
        if (this.iterationNumber < this.maxIterations) {
            this.useSeed = false;
            return true;
        }
        if (this.iterationNumber >= this.maxIterations && this.counter++ < 100) {
            this.introduceRandomArmePose(desiredTransform);
        }
        this.counter = 0;
        return false;
    }

    public void introduceRandomArmePose(RigidBodyTransform desiredTransform) {
        for (int i = 0; i < this.oneDoFJoints.length; ++i) {
            this.oneDoFJoints[i].setQ(this.random.nextDouble());
        }
        this.solve(desiredTransform);
    }

    private void getJointAngles(DMatrixRMaj angles) {
        for (int i = 0; i < angles.getNumRows(); ++i) {
            angles.set(i, 0, this.oneDoFJoints[i].getQ());
        }
    }

    private void setJointAngles(DMatrixRMaj angles) {
        for (int i = 0; i < angles.getNumRows(); ++i) {
            this.oneDoFJoints[i].setQ(angles.get(i, 0));
        }
    }

    private void updateBest() {
        this.getJointAngles(this.current);
        if (this.errorScalar < this.bestErrorScalar) {
            this.best.set((DMatrixD1)this.current);
            this.bestErrorScalar = this.errorScalar;
        }
    }

    private void computeError(RigidBodyTransform desiredTransform) {
        this.jacobian.getEndEffectorFrame().getTransformToDesiredFrame(this.actualTransform, this.jacobian.getBaseFrame());
        this.errorTransform.setAndInvert((RigidBodyTransformReadOnly)desiredTransform);
        this.errorTransform.multiply((RigidBodyTransformReadOnly)this.actualTransform);
        this.errorRotationMatrix.set((RotationMatrixReadOnly)this.errorTransform.getRotation());
        this.errorAxisAngle.set((Orientation3DReadOnly)this.errorRotationMatrix);
        this.axis.set(this.errorAxisAngle.getX(), this.errorAxisAngle.getY(), this.errorAxisAngle.getZ());
        this.errorRotationVector.set(this.axis);
        this.errorRotationVector.scale(this.errorAxisAngle.getAngle());
        this.errorTranslationVector.set((Tuple3DReadOnly)this.errorTransform.getTranslation());
        this.errorRotationVector.get(0, (DMatrix)this.error);
        this.errorTranslationVector.get(3, (DMatrix)this.error);
        this.errorScalar = NormOps_DDRM.normP2((DMatrixRMaj)this.error);
        assert (this.exponentialCoordinatesOK());
    }

    private boolean exponentialCoordinatesOK() {
        Twist twist = new Twist(this.jacobian.getEndEffectorFrame(), this.jacobian.getBaseFrame(), this.jacobian.getJacobianFrame(), (DMatrix)this.error);
        Pose3D poseCheck = new Pose3D();
        new MultiBodySystemStateIntegrator(1.0).integrate((TwistReadOnly)twist, (Pose3DBasics)poseCheck);
        RigidBodyTransform transformCheck = new RigidBodyTransform((Orientation3DReadOnly)poseCheck.getOrientation(), (Tuple3DReadOnly)poseCheck.getPosition());
        return transformCheck.epsilonEquals(this.errorTransform, 1.0E-5);
    }

    private void computeCorrection() {
        this.jacobian.compute();
        DMatrixRMaj dampenedJ = this.jacobian.getJacobianMatrix().copy();
        for (int i = 0; i < dampenedJ.getNumCols(); ++i) {
            dampenedJ.add(i, i, 0.0);
        }
        if (!this.solver.setA((Matrix)dampenedJ)) {
            // empty if block
        }
        this.solver.solve((Matrix)this.error, (Matrix)this.correction);
        double correctionScale = RandomNumbers.nextDouble((Random)this.random, (double)this.minRandomSearchScalar, (double)this.maxRandomSearchScalar);
        CommonOps_DDRM.scale((double)correctionScale, (DMatrixD1)this.correction);
        for (int i = 0; i < this.correction.getNumRows(); ++i) {
            this.correction.set(i, 0, MathTools.clamp((double)this.correction.get(i, 0), (double)(-this.maxStepSize), (double)this.maxStepSize));
        }
    }

    private void applyCorrection() {
        for (int i = 0; i < this.oneDoFJoints.length; ++i) {
            OneDoFJointBasics oneDoFJoint = this.useSeed ? this.oneDoFJointsSeed[i] : this.oneDoFJoints[i];
            double newQ = oneDoFJoint.getQ() - this.correction.get(i, 0);
            newQ = MathTools.clamp((double)newQ, (double)oneDoFJoint.getJointLimitLower(), (double)oneDoFJoint.getJointLimitUpper());
            oneDoFJoint.setQ(newQ);
            oneDoFJoint.getFrameAfterJoint().update();
        }
    }

    @Override
    public int getNumberOfIterations() {
        return this.iterationNumber;
    }

    @Override
    public double getErrorScalar() {
        return this.errorScalar;
    }

    @Override
    public void attachInverseKinematicsStepListener(InverseKinematicsStepListener stepListener) {
    }

    @Override
    public void setLimitJointAngles(boolean limitJointAngles) {
    }
}

