/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.kinematics;

import java.util.Random;
import org.ejml.data.DMatrixRMaj;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.mecano.multiBodySystem.interfaces.JointReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointBasics;
import us.ihmc.mecano.tools.JointStateType;
import us.ihmc.mecano.tools.MultiBodySystemRandomTools;
import us.ihmc.mecano.tools.MultiBodySystemTools;
import us.ihmc.robotics.kinematics.InverseKinematicsCalculator;
import us.ihmc.robotics.kinematics.InverseKinematicsStepListener;
import us.ihmc.robotics.kinematics.NumericalInverseKinematicsCalculator;
import us.ihmc.robotics.screwTheory.GeometricJacobian;

public class RandomRestartInverseKinematicsCalculator
implements InverseKinematicsCalculator {
    private final Random random = new Random(1984L);
    private final NumericalInverseKinematicsCalculator inverseKinematicsCalculator;
    private final OneDoFJointBasics[] joints;
    private final int maxRestarts;
    private final double restartTolerance;
    private double bestErrorScalar;
    private final DMatrixRMaj best = new DMatrixRMaj(1, 1);

    public RandomRestartInverseKinematicsCalculator(int maxRestarts, double restartTolerance, GeometricJacobian jacobian, NumericalInverseKinematicsCalculator inverseKinematicsCalculator) {
        this.inverseKinematicsCalculator = inverseKinematicsCalculator;
        this.joints = (OneDoFJointBasics[])MultiBodySystemTools.filterJoints((JointReadOnly[])jacobian.getJointsInOrder(), OneDoFJointBasics.class);
        this.maxRestarts = maxRestarts;
        this.restartTolerance = restartTolerance;
    }

    @Override
    public boolean solve(RigidBodyTransform desiredTransform) {
        this.bestErrorScalar = Double.POSITIVE_INFINITY;
        boolean foundSolution = false;
        for (int restart = 0; restart < this.maxRestarts && !foundSolution; ++restart) {
            foundSolution = this.inverseKinematicsCalculator.solve(desiredTransform);
            double errorScalar = this.inverseKinematicsCalculator.getErrorScalar();
            boolean bl = foundSolution = foundSolution || errorScalar < this.restartTolerance;
            if (errorScalar < this.bestErrorScalar) {
                this.bestErrorScalar = errorScalar;
                this.inverseKinematicsCalculator.getBest(this.best);
            }
            if (foundSolution) continue;
            MultiBodySystemRandomTools.nextState((Random)this.random, (JointStateType)JointStateType.CONFIGURATION, (double)-1.5707963267948966, (double)1.5707963267948966, (OneDoFJointBasics[])this.joints);
        }
        this.inverseKinematicsCalculator.setJointAngles(this.best);
        return foundSolution;
    }

    @Override
    public double getErrorScalar() {
        return this.inverseKinematicsCalculator.getErrorScalar();
    }

    @Override
    public int getNumberOfIterations() {
        return this.inverseKinematicsCalculator.getNumberOfIterations();
    }

    @Override
    public void attachInverseKinematicsStepListener(InverseKinematicsStepListener stepListener) {
        this.inverseKinematicsCalculator.attachInverseKinematicsStepListener(stepListener);
    }

    @Override
    public void setLimitJointAngles(boolean limitJointAngles) {
        this.inverseKinematicsCalculator.setLimitJointAngles(limitJointAngles);
    }
}

