/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.kinematics;

import georegression.geometry.ConvertRotation3D_F64;
import georegression.metric.UtilAngle;
import georegression.struct.EulerType;
import java.util.Random;
import org.ddogleg.optimization.FactoryOptimization;
import org.ddogleg.optimization.UnconstrainedLeastSquares;
import org.ddogleg.optimization.functions.FunctionNtoM;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrixRMaj;
import us.ihmc.commons.MathTools;
import us.ihmc.euclid.matrix.RotationMatrix;
import us.ihmc.euclid.matrix.interfaces.RotationMatrixReadOnly;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.JointReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointBasics;
import us.ihmc.mecano.tools.MultiBodySystemTools;
import us.ihmc.robotics.kinematics.InverseKinematicsCalculator;
import us.ihmc.robotics.kinematics.InverseKinematicsStepListener;
import us.ihmc.robotics.screwTheory.GeometricJacobian;

public class DdoglegInverseKinematicsCalculator
implements InverseKinematicsCalculator {
    private final ReferenceFrame baseFrame;
    private final ReferenceFrame endEffectorFrame;
    private final OneDoFJointBasics[] oneDoFJoints;
    private final int maxIterations;
    private final Random random = new Random(1251253L);
    private double errorScalar;
    private final RigidBodyTransform actualTransform = new RigidBodyTransform();
    private final RotationMatrix rotationMatrix = new RotationMatrix();
    private final Vector3D actualT = new Vector3D();
    private final Vector3D actualR = new Vector3D();
    private final Vector3D desiredT = new Vector3D();
    private final Vector3D desiredR = new Vector3D();
    private final DMatrixRMaj m = new DMatrixRMaj(3, 3);
    private int numberOfIterations;
    private final boolean solveOrientation;
    private final double positionCost;
    private final double orientationCost;
    private final double convergeTolerance;
    private double[] originalParam;
    private final double acceptTolLoc;
    private final double acceptTolAngle;
    private final double parameterChangePenalty;
    private final double[] euler = new double[3];
    private InverseKinematicsStepListener stepListener = null;

    public DdoglegInverseKinematicsCalculator(GeometricJacobian jacobian, double positionCost, double orientationCost, int maxIterations, boolean solveOrientation, double convergeTolerance, double acceptTolLoc, double acceptTolAngle, double parameterChangePenalty) {
        if (jacobian.getJacobianFrame() != jacobian.getEndEffectorFrame()) {
            throw new RuntimeException("jacobian.getJacobianFrame() != jacobian.getEndEffectorFrame()");
        }
        this.baseFrame = jacobian.getBaseFrame();
        this.endEffectorFrame = jacobian.getEndEffectorFrame();
        this.positionCost = positionCost;
        this.orientationCost = orientationCost;
        this.solveOrientation = solveOrientation;
        this.oneDoFJoints = (OneDoFJointBasics[])MultiBodySystemTools.filterJoints((JointReadOnly[])jacobian.getJointsInOrder(), OneDoFJointBasics.class);
        if (this.oneDoFJoints.length != jacobian.getJointsInOrder().length) {
            throw new RuntimeException("Can currently only handle OneDoFJoints");
        }
        this.maxIterations = maxIterations;
        this.acceptTolLoc = acceptTolLoc;
        this.acceptTolAngle = acceptTolAngle;
        this.convergeTolerance = convergeTolerance;
        this.parameterChangePenalty = parameterChangePenalty;
    }

    @Override
    public void attachInverseKinematicsStepListener(InverseKinematicsStepListener stepListener) {
        this.stepListener = stepListener;
    }

    @Override
    public boolean solve(RigidBodyTransform desiredTransform) {
        double[] initParam = new double[this.oneDoFJoints.length];
        for (int i = 0; i < this.oneDoFJoints.length; ++i) {
            initParam[i] = this.oneDoFJoints[i].getQ();
        }
        this.originalParam = (double[])initParam.clone();
        this.extractTandR(desiredTransform, this.desiredT, this.desiredR);
        FunctionErrors func = new FunctionErrors(desiredTransform, this.parameterChangePenalty);
        UnconstrainedLeastSquares optimizer = FactoryOptimization.dogleg(null, (boolean)true);
        optimizer.setFunction((FunctionNtoM)func, null);
        double[] bestParam = new double[initParam.length];
        System.arraycopy(initParam, 0, bestParam, 0, bestParam.length);
        double bestScore = Double.MAX_VALUE;
        optimizer.initialize(initParam, 0.0, this.convergeTolerance);
        int totalSinceLast = 0;
        this.numberOfIterations = 0;
        while (this.numberOfIterations < this.maxIterations) {
            boolean done;
            if (this.stepListener != null) {
                this.stepListener.didAnInverseKinemticsStep(this.errorScalar);
            }
            while (!(done = optimizer.iterate()) && !optimizer.isUpdated()) {
            }
            if (optimizer.isUpdated()) {
                double[] foundParam = optimizer.getParameters();
                if (bestScore > optimizer.getFunctionValue()) {
                    bestScore = optimizer.getFunctionValue();
                    System.arraycopy(foundParam, 0, bestParam, 0, bestParam.length);
                    if (bestScore <= this.convergeTolerance) break;
                }
            }
            if (done || totalSinceLast > 30 || optimizer.getFunctionValue() <= this.convergeTolerance) {
                totalSinceLast = 0;
                for (int i = 0; i < initParam.length; ++i) {
                    OneDoFJointBasics oneDoFJoint = this.oneDoFJoints[i];
                    if (Double.isInfinite(oneDoFJoint.getJointLimitUpper())) {
                        initParam[i] = this.random.nextDouble() * 2.0 * Math.PI - Math.PI;
                        continue;
                    }
                    double delta = oneDoFJoint.getJointLimitUpper() - oneDoFJoint.getJointLimitLower();
                    initParam[i] = this.random.nextDouble() * delta + oneDoFJoint.getJointLimitLower();
                }
                optimizer.initialize(initParam, 0.0, this.convergeTolerance);
            } else {
                ++totalSinceLast;
            }
            ++this.numberOfIterations;
        }
        ++this.numberOfIterations;
        this.errorScalar = bestScore;
        this.updateState(bestParam);
        this.extractTandR(this.actualTransform, this.actualT, this.actualR);
        if (Math.abs(this.actualT.getX() - this.desiredT.getX()) > this.acceptTolLoc) {
            return false;
        }
        if (Math.abs(this.actualT.getY() - this.desiredT.getY()) > this.acceptTolLoc) {
            return false;
        }
        if (Math.abs(this.actualT.getZ() - this.desiredT.getZ()) > this.acceptTolLoc) {
            return false;
        }
        if (UtilAngle.dist((double)this.actualR.getX(), (double)this.desiredR.getX()) > this.acceptTolAngle) {
            return false;
        }
        if (UtilAngle.dist((double)this.actualR.getY(), (double)this.desiredR.getY()) > this.acceptTolAngle) {
            return false;
        }
        return !(UtilAngle.dist((double)this.actualR.getZ(), (double)this.desiredR.getZ()) > this.acceptTolAngle);
    }

    @Override
    public int getNumberOfIterations() {
        return this.numberOfIterations;
    }

    @Override
    public double getErrorScalar() {
        return this.errorScalar;
    }

    private void updateState(double[] parameters) {
        for (int i = 0; i < parameters.length; ++i) {
            OneDoFJointBasics oneDoFJoint = this.oneDoFJoints[i];
            double newQ = UtilAngle.bound((double)parameters[i]);
            if (Double.isNaN(newQ)) continue;
            newQ = parameters[i] = MathTools.clamp((double)newQ, (double)oneDoFJoint.getJointLimitLower(), (double)oneDoFJoint.getJointLimitUpper());
            oneDoFJoint.setQ(newQ);
            oneDoFJoint.getFrameAfterJoint().update();
        }
    }

    private void extractTandR(RigidBodyTransform tran, Vector3D T, Vector3D R) {
        T.set((Tuple3DReadOnly)tran.getTranslation());
        this.rotationMatrix.set((RotationMatrixReadOnly)tran.getRotation());
        this.rotationMatrix.get((DMatrix)this.m);
        ConvertRotation3D_F64.matrixToEuler((DMatrixRMaj)this.m, (EulerType)EulerType.XYZ, (double[])this.euler);
        R.setX(this.euler[0]);
        R.setY(this.euler[1]);
        R.setZ(this.euler[2]);
    }

    @Override
    public void setLimitJointAngles(boolean limitJointAngles) {
    }

    public class FunctionErrors
    implements FunctionNtoM {
        RigidBodyTransform desiredTransform;
        double parameterChangePenalty;

        public FunctionErrors(RigidBodyTransform desiredTransform, double parameterChangePenalty) {
            this.parameterChangePenalty = parameterChangePenalty;
            this.desiredTransform = desiredTransform;
        }

        public int getNumOfInputsN() {
            return DdoglegInverseKinematicsCalculator.this.oneDoFJoints.length;
        }

        public int getNumOfOutputsM() {
            return DdoglegInverseKinematicsCalculator.this.originalParam.length + (DdoglegInverseKinematicsCalculator.this.solveOrientation ? 6 : 3);
        }

        public void process(double[] parameters, double[] functions) {
            DdoglegInverseKinematicsCalculator.this.updateState(parameters);
            for (int index = 0; index < parameters.length; ++index) {
                functions[index] = index < 3 ? this.parameterChangePenalty * Math.abs(parameters[index] - DdoglegInverseKinematicsCalculator.this.originalParam[index]) : this.parameterChangePenalty * Math.abs(UtilAngle.minus((double)parameters[index], (double)DdoglegInverseKinematicsCalculator.this.originalParam[index]));
            }
            DdoglegInverseKinematicsCalculator.this.endEffectorFrame.getTransformToDesiredFrame(DdoglegInverseKinematicsCalculator.this.actualTransform, DdoglegInverseKinematicsCalculator.this.baseFrame);
            DdoglegInverseKinematicsCalculator.this.extractTandR(DdoglegInverseKinematicsCalculator.this.actualTransform, DdoglegInverseKinematicsCalculator.this.actualT, DdoglegInverseKinematicsCalculator.this.actualR);
            functions[index + 0] = DdoglegInverseKinematicsCalculator.this.positionCost * (DdoglegInverseKinematicsCalculator.this.actualT.getX() - DdoglegInverseKinematicsCalculator.this.desiredT.getX());
            functions[index + 1] = DdoglegInverseKinematicsCalculator.this.positionCost * (DdoglegInverseKinematicsCalculator.this.actualT.getY() - DdoglegInverseKinematicsCalculator.this.desiredT.getY());
            functions[index + 2] = DdoglegInverseKinematicsCalculator.this.positionCost * (DdoglegInverseKinematicsCalculator.this.actualT.getZ() - DdoglegInverseKinematicsCalculator.this.desiredT.getZ());
            if (DdoglegInverseKinematicsCalculator.this.solveOrientation) {
                functions[index + 3] = DdoglegInverseKinematicsCalculator.this.orientationCost * UtilAngle.minus((double)DdoglegInverseKinematicsCalculator.this.actualR.getX(), (double)DdoglegInverseKinematicsCalculator.this.desiredR.getX());
                functions[index + 4] = DdoglegInverseKinematicsCalculator.this.orientationCost * UtilAngle.minus((double)DdoglegInverseKinematicsCalculator.this.actualR.getY(), (double)DdoglegInverseKinematicsCalculator.this.desiredR.getY());
                functions[index + 5] = DdoglegInverseKinematicsCalculator.this.orientationCost * UtilAngle.minus((double)DdoglegInverseKinematicsCalculator.this.actualR.getZ(), (double)DdoglegInverseKinematicsCalculator.this.desiredR.getZ());
            }
        }
    }
}

