/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.hyperCubeTree;

import java.util.List;
import us.ihmc.euclid.geometry.LineSegment3D;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.robotics.hyperCubeTree.ConstantResolutionProvider;
import us.ihmc.robotics.hyperCubeTree.DimensionalityMismatchException;
import us.ihmc.robotics.hyperCubeTree.HyperCubeLeaf;
import us.ihmc.robotics.hyperCubeTree.HyperCubeTree;
import us.ihmc.robotics.hyperCubeTree.LineSegmentSearchVolume;
import us.ihmc.robotics.hyperCubeTree.OneDimensionalBounds;
import us.ihmc.robotics.hyperCubeTree.RecursableHyperTreeNode;
import us.ihmc.robotics.hyperCubeTree.ResolutionProvider;

public class Octree
extends HyperCubeTree<Boolean, Void> {
    private final ResolutionProvider constantResolution;

    public Octree(OneDimensionalBounds[] bounds, double resolution) {
        this(bounds, new ConstantResolutionProvider(resolution));
    }

    public Octree(OneDimensionalBounds[] bounds, ResolutionProvider resolutionProvider) {
        super(bounds);
        this.constantResolution = resolutionProvider;
        if (bounds.length != 3) {
            throw new DimensionalityMismatchException();
        }
    }

    public void mergeIfPossible() {
        this.lock();
        this.mergeWherePossibleRecursively(this.getRootNode());
        this.unlock();
    }

    private void mergeTruth(RecursableHyperTreeNode<Boolean, Void> node) {
        if (!node.hasChildren()) {
            return;
        }
        HyperCubeLeaf<Boolean> firstLeaf = null;
        for (int i = 0; i < node.getChildNumber(); ++i) {
            RecursableHyperTreeNode<Boolean, Void> lowerLevelNode = node.getChild(i);
            if (lowerLevelNode.hasChildren()) {
                return;
            }
            if (null == lowerLevelNode.getLeaf()) continue;
            if (null == firstLeaf) {
                firstLeaf = lowerLevelNode.getLeaf();
                continue;
            }
            if (lowerLevelNode.getLeaf().getValue().booleanValue()) continue;
            return;
        }
        if (null == firstLeaf) {
            return;
        }
        node.clear();
        node.setLeaf(firstLeaf);
    }

    @Override
    public void nodeAdded(String id, OneDimensionalBounds[] bounds, HyperCubeLeaf<Boolean> leaf) {
        super.nodeAdded(id, bounds, leaf);
    }

    @Override
    public void nodeRemoved(String id) {
        super.nodeRemoved(id);
    }

    public void putLidarAtGraduallyMoreAccurateResolution(Point3D start, Point3D end) {
        LineSegmentSearchVolume line = new LineSegmentSearchVolume(new LineSegment3D((Point3DReadOnly)start, (Point3DReadOnly)end));
        double[] location = new double[]{end.getX(), end.getY(), end.getZ()};
        this.put(location, true);
        this.leafAdded(new HyperCubeLeaf<Boolean>(true, location));
        RecursableHyperTreeNode endNode = this.getLeafNodeAtLocation(location);
        List lineNodes = this.getHyperVolumeIntersection(line);
        lineNodes.remove(endNode);
        for (RecursableHyperTreeNode node : lineNodes) {
            double[] intersectionWithBounds = line.intersectionWithBounds(new BoundsGetter(node).get());
            HyperCubeLeaf<Boolean> hyperCubeLeaf = new HyperCubeLeaf<Boolean>(false, intersectionWithBounds);
            this.replacementPut(hyperCubeLeaf);
        }
    }

    public void putLidarAtMinimumResolution(Point3D start, Point3D end) {
        LineSegmentSearchVolume line = new LineSegmentSearchVolume(new LineSegment3D((Point3DReadOnly)start, (Point3DReadOnly)end));
        double[] location = new double[]{end.getX(), end.getY(), end.getZ()};
        this.upRezz(location);
        this.put(location, true);
        this.leafAdded(new HyperCubeLeaf<Boolean>(true, location));
        RecursableHyperTreeNode endNode = this.getLeafNodeAtLocation(location);
        List lineNodes = this.getHyperVolumeIntersection(line);
        lineNodes.remove(endNode);
        for (RecursableHyperTreeNode node : lineNodes) {
            double[] intersectionWithBounds = line.intersectionWithBounds(new BoundsGetter(node).get());
            HyperCubeLeaf<Boolean> hyperCubeLeaf = new HyperCubeLeaf<Boolean>(false, intersectionWithBounds);
            this.replacementPut(hyperCubeLeaf);
        }
        this.lock();
        this.mergeParentRecursively(this.getRootNode(), location);
        this.unlock();
    }

    @Override
    protected boolean canMergeLeaves(HyperCubeLeaf<Boolean> firstLeaf, HyperCubeLeaf<Boolean> secondLeaf) {
        return firstLeaf.getValue() == secondLeaf.getValue();
    }

    @Override
    protected boolean canSplit(RecursableHyperTreeNode<Boolean, Void> node) {
        for (int i = 0; i < node.getDimensionality(); ++i) {
            if (!(node.getBounds(i).size() <= this.constantResolution.getResolution(node.getMidpoint()))) continue;
            return false;
        }
        return true;
    }

    @Override
    protected HyperCubeLeaf<Boolean> mergeLeaves(HyperCubeLeaf<Boolean> oldLeaf, HyperCubeLeaf<Boolean> newLeaf) {
        return newLeaf;
    }

    private void mergeParentRecursively(RecursableHyperTreeNode<Boolean, Void> node, double[] location) {
        if (null == node) {
            return;
        }
        if (node.hasChildren()) {
            this.mergeParentRecursively(node.getChildAtLocation(location), location);
            this.mergeTruth(node);
        }
    }

    @Override
    public void treeCleared() {
    }

    @Override
    public boolean put(HyperCubeLeaf<Boolean> leaf) {
        this.lock();
        boolean success = this.putRecursively(this.getRootNode(), leaf);
        this.unlock();
        return success;
    }

    private boolean putRecursively(RecursableHyperTreeNode<Boolean, Void> node, HyperCubeLeaf<Boolean> leaf) {
        if (node.hasChildren()) {
            return this.putRecursively(node.getChildAtLocation(leaf.getLocation()), leaf);
        }
        if (node.getLeaf() != null) {
            if (this.canSplit(node)) {
                HyperCubeLeaf<Boolean> oldLeaf = node.getLeaf();
                node.setLeaf(null);
                node.split();
                node.getChildAtLocation(oldLeaf.getLocation()).setLeaf(oldLeaf);
                RecursableHyperTreeNode<Boolean, Void> childAtLocation = node.getChildAtLocation(leaf.getLocation());
                childAtLocation.setLeaf(this.mergeLeaves(childAtLocation.getLeaf(), leaf));
                return true;
            }
            if (node.getLeaf().getValue().booleanValue() == leaf.getValue().booleanValue()) {
                return false;
            }
            node.setLeaf(leaf);
            return true;
        }
        node.setLeaf(leaf);
        return true;
    }

    public static class BoundsGetter {
        RecursableHyperTreeNode<?, ?> node;

        public BoundsGetter(RecursableHyperTreeNode<?, ?> node) {
            this.node = node;
        }

        public OneDimensionalBounds[] get() {
            OneDimensionalBounds[] ret = new OneDimensionalBounds[this.node.getDimensionality()];
            for (int i = 0; i < this.node.getDimensionality(); ++i) {
                ret[i] = this.node.getBounds(i);
            }
            return ret;
        }
    }
}

