/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.hyperCubeTree;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class LowPassTimingReporter {
    private static final int HEURISTIC_OWN_COMPUTATION_TIME_APPROXIMATION = 22;
    private long startTime;
    private long averageTime;
    private double averageSeconds;
    private final int alpha;
    private final double divisor;
    private long averagePeriod;
    private double periodSeconds;
    private double timeConstantSeconds;
    boolean firstTime = true;

    public LowPassTimingReporter(int alpha) {
        this.alpha = alpha;
        this.divisor = 1.0 / (double)(1 << alpha);
    }

    public void startTime() {
        long nanoTime = System.nanoTime();
        if (!this.firstTime) {
            this.averagePeriod += (nanoTime - this.startTime << this.alpha) - this.averagePeriod >> this.alpha;
            this.periodSeconds = (double)this.averagePeriod * this.divisor * 1.0E-9;
            this.timeConstantSeconds = this.periodSeconds * (double)(1 << this.alpha);
        } else {
            this.firstTime = false;
        }
        this.startTime = nanoTime;
    }

    public void endTime() {
        this.averageTime += (System.nanoTime() - this.startTime - 22L << this.alpha) - this.averageTime >> this.alpha;
        this.averageSeconds = (double)this.averageTime * this.divisor * 1.0E-9;
    }

    public void setupRecording(String name, String action) {
        this.setupRecording(name, action, 1000L, 1000L);
    }

    public void setupRecording(final String name, final String action, long loopPeriodMilliseconds, long delayMilliseconds) {
        ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
        executor.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                System.out.println(LowPassTimingReporter.this.generateMessage(name, action));
            }
        }, delayMilliseconds, loopPeriodMilliseconds, TimeUnit.MILLISECONDS);
    }

    public String generateMessage(String name, String action) {
        return name + " takes on average " + this.averageSeconds + " seconds to " + action + "\n\tThe time spent on this method is approximately " + this.averageSeconds / this.periodSeconds + "\n\tThe low pass filter time constant for this timer is approximately " + this.timeConstantSeconds + " seconds.";
    }

    public double getAverageSeconds() {
        return this.averageSeconds;
    }

    public double getApproximateTimeConstant() {
        return this.timeConstantSeconds;
    }
}

