/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.hyperCubeTree;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import us.ihmc.robotics.hyperCubeTree.DimensionalityMismatchException;
import us.ihmc.robotics.hyperCubeTree.HyperCubeLeaf;
import us.ihmc.robotics.hyperCubeTree.HyperCubeNode;
import us.ihmc.robotics.hyperCubeTree.HyperCubeTreeListener;
import us.ihmc.robotics.hyperCubeTree.HyperVolume;
import us.ihmc.robotics.hyperCubeTree.OneDimensionalBounds;
import us.ihmc.robotics.hyperCubeTree.RecursableHyperTreeNode;

public abstract class HyperCubeTree<T, D>
implements HyperCubeTreeListener<T, D> {
    private final RecursableHyperTreeNode<T, D> rootNode;
    private List<HyperCubeTreeListener<T, D>> treeListeners = new ArrayList<HyperCubeTreeListener<T, D>>();
    private final ReentrantLock lock = new ReentrantLock();

    public HyperCubeTree(OneDimensionalBounds[] bounds) {
        this.rootNode = new HyperCubeNode(bounds, "root", this);
        for (int i = 0; i < bounds.length; ++i) {
            if (!bounds[i].isInfinite()) continue;
            throw new RuntimeException("Infinite ranges are unbisectable.");
        }
    }

    public void addListener(HyperCubeTreeListener<T, D> listener) {
        this.treeListeners.add(listener);
    }

    public void checkDimensionality(double[] array) {
        HyperCubeTree.checkDimensionality(array, this.rootNode.getDimensionality());
    }

    public void clearTree() {
        this.lock();
        this.clearRecursively(this.getRootNode());
        for (HyperCubeTreeListener<T, D> listener : this.treeListeners) {
            listener.treeCleared();
        }
    }

    public int countNodes() {
        this.lock();
        int count = this.countNodesRecursively(this.getRootNode());
        this.unlock();
        return count;
    }

    public HyperCubeLeaf<T> get(double[] location) {
        this.lock();
        this.checkDimensionality(location);
        OneDimensionalBounds[] boundsCopy = this.rootNode.getBoundsCopy();
        for (int i = 0; i < location.length; ++i) {
            if (boundsCopy[i].contains(location[i])) continue;
            return null;
        }
        HyperCubeLeaf<T> leaves = HyperCubeTree.getRecursively(this.getRootNode(), location);
        this.unlock();
        return leaves;
    }

    public List<RecursableHyperTreeNode<T, D>> getHyperVolumeIntersection(HyperVolume volume) {
        this.lock();
        ArrayList<RecursableHyperTreeNode<T, D>> nodes = new ArrayList<RecursableHyperTreeNode<T, D>>();
        HyperCubeTree.getHyperVolumeIntersectionRecursively(this.getRootNode(), volume, nodes);
        this.unlock();
        return nodes;
    }

    public RecursableHyperTreeNode<T, D> getLeafNodeAtLocation(double[] location) {
        this.lock();
        RecursableHyperTreeNode<T, D> node = HyperCubeTree.getNode(this.getRootNode(), location);
        this.unlock();
        return node;
    }

    public RecursableHyperTreeNode<T, D> getNode(double[] location) {
        this.lock();
        RecursableHyperTreeNode<T, D> node = HyperCubeTree.getNode(this.getRootNode(), location);
        this.unlock();
        return node;
    }

    public RecursableHyperTreeNode<T, D> getRootNode() {
        return this.rootNode;
    }

    @Override
    public void leafAdded(HyperCubeLeaf<T> leaf) {
        for (HyperCubeTreeListener<T, D> listener : this.treeListeners) {
            listener.leafAdded(leaf);
        }
    }

    public List<RecursableHyperTreeNode<T, D>> listAllLeafNodes() {
        this.lock();
        ArrayList<RecursableHyperTreeNode<T, D>> leafNodes = new ArrayList<RecursableHyperTreeNode<T, D>>();
        HyperCubeTree.listAllLeafNodesRecursively(this.getRootNode(), leafNodes);
        this.unlock();
        return leafNodes;
    }

    public List<HyperCubeLeaf<T>> listAllLeaves() {
        this.lock();
        ArrayList<HyperCubeLeaf<T>> leaves = new ArrayList<HyperCubeLeaf<T>>();
        HyperCubeTree.listAllLeavesRecursively(this.getRootNode(), leaves);
        this.unlock();
        return leaves;
    }

    protected void unSynchronizedMergeOneLevel(RecursableHyperTreeNode<T, D> node) {
        if (!node.hasChildren()) {
            return;
        }
        HyperCubeLeaf<T> firstLeaf = null;
        for (int i = 0; i < node.getChildNumber(); ++i) {
            RecursableHyperTreeNode<T, D> lowerLevelNode = node.getChild(i);
            if (lowerLevelNode.hasChildren()) {
                return;
            }
            if (null == lowerLevelNode.getLeaf()) continue;
            if (null == firstLeaf) {
                firstLeaf = lowerLevelNode.getLeaf();
                continue;
            }
            if (this.canMergeLeaves(firstLeaf, lowerLevelNode.getLeaf())) continue;
            return;
        }
        if (null == firstLeaf) {
            return;
        }
        node.clear();
        node.setLeaf(firstLeaf);
    }

    @Override
    public void nodeAdded(String id, OneDimensionalBounds[] bounds, HyperCubeLeaf<T> leaf) {
        for (HyperCubeTreeListener<T, D> listener : this.treeListeners) {
            listener.nodeAdded(id, bounds, leaf);
        }
    }

    @Override
    public void nodeRemoved(String id) {
        for (HyperCubeTreeListener<T, D> listener : this.treeListeners) {
            listener.nodeRemoved(id);
        }
    }

    @Override
    public void metaDataUpdated(String id, OneDimensionalBounds[] bounds, D data) {
        for (HyperCubeTreeListener<T, D> listener : this.treeListeners) {
            listener.metaDataUpdated(id, bounds, data);
        }
    }

    public boolean put(double[] location, T value) {
        this.checkDimensionality(location);
        HyperCubeLeaf<T> leaf = new HyperCubeLeaf<T>(value, location);
        return this.put(leaf);
    }

    public boolean put(HyperCubeLeaf<T> leaf) {
        this.lock();
        boolean success = this.putRecursively(this.getRootNode(), leaf);
        this.unlock();
        return success;
    }

    public void remove(HyperCubeLeaf<T> leaf) {
        this.lock();
        this.removeRecursively(this.getRootNode(), leaf);
        this.unlock();
    }

    public void removeListener(HyperCubeTreeListener<T, D> listener) {
        this.treeListeners.remove(listener);
    }

    public void replacementPut(HyperCubeLeaf<T> leaf) {
        this.lock();
        HyperCubeTree.replacementPutRecursively(this.getRootNode(), leaf);
        this.unlock();
    }

    public void upRezz(double[] location) {
        this.lock();
        this.upRezzRecursively(this.getRootNode(), location);
        this.unlock();
    }

    protected abstract boolean canMergeLeaves(HyperCubeLeaf<T> var1, HyperCubeLeaf<T> var2);

    protected abstract boolean canSplit(RecursableHyperTreeNode<T, D> var1);

    protected abstract HyperCubeLeaf<T> mergeLeaves(HyperCubeLeaf<T> var1, HyperCubeLeaf<T> var2);

    protected void mergeWherePossibleRecursively(RecursableHyperTreeNode<T, D> node) {
        if (node.hasChildren()) {
            for (int i = 0; i < node.getChildNumber(); ++i) {
                this.mergeWherePossibleRecursively(node.getChild(i));
            }
            this.unSynchronizedMergeOneLevel(node);
        }
    }

    private void clearRecursively(RecursableHyperTreeNode<T, D> node) {
        if (node.hasChildren()) {
            for (int i = 0; i < node.getChildNumber(); ++i) {
                this.clearRecursively(node.getChild(i));
            }
            node.clear();
        } else {
            node.clear();
        }
    }

    private int countNodesRecursively(RecursableHyperTreeNode<T, D> node) {
        if (node.hasChildren()) {
            int nodes = 1;
            for (int i = 0; i < node.getChildNumber(); ++i) {
                nodes += this.countNodesRecursively(node.getChild(i));
            }
            return nodes;
        }
        return 1;
    }

    private boolean putRecursively(RecursableHyperTreeNode<T, D> node, HyperCubeLeaf<T> leaf) {
        if (node.hasChildren()) {
            return this.putRecursively(node.getChildAtLocation(leaf.getLocation()), leaf);
        }
        if (node.getLeaf() != null) {
            if (this.canSplit(node)) {
                HyperCubeLeaf<T> oldLeaf = node.getLeaf();
                node.setLeaf(null);
                node.split();
                node.getChildAtLocation(oldLeaf.getLocation()).setLeaf(oldLeaf);
                RecursableHyperTreeNode<T, D> childAtLocation = node.getChildAtLocation(leaf.getLocation());
                childAtLocation.setLeaf(this.mergeLeaves(childAtLocation.getLeaf(), leaf));
            } else {
                node.setLeaf(this.mergeLeaves(node.getLeaf(), leaf));
            }
        } else {
            node.setLeaf(leaf);
        }
        return true;
    }

    private void removeRecursively(RecursableHyperTreeNode<T, D> node, HyperCubeLeaf<T> leaf) {
        if (node.hasChildren()) {
            this.removeRecursively(node.getChildAtLocation(leaf.getLocation()), leaf);
            this.unSynchronizedMergeOneLevel(node);
        } else if (node.getLeaf() != null) {
            node.clear();
        }
    }

    private void upRezzRecursively(RecursableHyperTreeNode<T, D> node, double[] location) {
        if (!node.hasChildren() && this.canSplit(node)) {
            HyperCubeLeaf<T> oldLeaf = node.getLeaf();
            node.setLeaf(null);
            node.split();
            if (null != oldLeaf) {
                node.getChildAtLocation(oldLeaf.getLocation()).setLeaf(oldLeaf);
            }
        }
        if (node.hasChildren()) {
            this.upRezzRecursively(node.getChildAtLocation(location), location);
        }
    }

    private static void checkDimensionality(double[] array, int dimensionality) {
        if (array.length != dimensionality) {
            throw new DimensionalityMismatchException();
        }
    }

    private static <T, D> void getHyperVolumeIntersectionRecursively(RecursableHyperTreeNode<T, D> node, HyperVolume volume, List<RecursableHyperTreeNode<T, D>> nodes) {
        if (volume.intersectsBounds(node.getBoundsCopy())) {
            if (node.hasChildren()) {
                for (int i = 0; i < node.getChildNumber(); ++i) {
                    HyperCubeTree.getHyperVolumeIntersectionRecursively(node.getChild(i), volume, nodes);
                }
            } else {
                nodes.add(node);
            }
        }
    }

    private static <T, D> RecursableHyperTreeNode<T, D> getNode(RecursableHyperTreeNode<T, D> node, double[] location) {
        if (node.hasChildren()) {
            return HyperCubeTree.getNode(node.getChildAtLocation(location), location);
        }
        return node;
    }

    private static <T, D> HyperCubeLeaf<T> getRecursively(RecursableHyperTreeNode<T, D> node, double[] location) {
        if (node.hasChildren()) {
            return HyperCubeTree.getRecursively(node.getChildAtLocation(location), location);
        }
        return node.getLeaf();
    }

    private static <T, D> void listAllLeafNodesRecursively(RecursableHyperTreeNode<T, D> node, List<RecursableHyperTreeNode<T, D>> leafNodes) {
        if (node.hasChildren()) {
            for (int i = 0; i < node.getChildNumber(); ++i) {
                HyperCubeTree.listAllLeafNodesRecursively(node.getChild(i), leafNodes);
            }
        } else {
            leafNodes.add(node);
        }
    }

    private static <T, D> void listAllLeavesRecursively(RecursableHyperTreeNode<T, D> node, List<HyperCubeLeaf<T>> leaves) {
        if (node.hasChildren()) {
            for (int i = 0; i < node.getChildNumber(); ++i) {
                HyperCubeTree.listAllLeavesRecursively(node.getChild(i), leaves);
            }
        } else {
            HyperCubeLeaf<T> leaf = node.getLeaf();
            if (leaf != null) {
                leaves.add(leaf);
            }
        }
    }

    private static <T, D> void replacementPutRecursively(RecursableHyperTreeNode<T, D> node, HyperCubeLeaf<T> leaf) {
        if (node.hasChildren()) {
            HyperCubeTree.replacementPutRecursively(node.getChildAtLocation(leaf.getLocation()), leaf);
        } else {
            node.setLeaf(leaf);
        }
    }

    public void lock() {
        this.lock.lock();
    }

    public void unlock() {
        this.lock.unlock();
    }
}

