/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.hyperCubeTree;

import java.util.ArrayList;
import java.util.List;
import us.ihmc.robotics.hyperCubeTree.HyperCubeLeaf;
import us.ihmc.robotics.hyperCubeTree.HyperCubeTreeListener;
import us.ihmc.robotics.hyperCubeTree.OneDimensionalBounds;
import us.ihmc.robotics.hyperCubeTree.RecursableHyperTreeNode;

public class HyperCubeNode<T, D>
implements RecursableHyperTreeNode<T, D> {
    private final int dimensionality;
    private final int childNumber;
    private final OneDimensionalBounds[] bounds;
    private final double[] midPoint;
    private HyperCubeLeaf<T> leaf = null;
    private boolean hasChildren = false;
    private final HyperCubeNode<T, D>[] children;
    protected final HyperCubeTreeListener<T, D> listener;
    protected final String id;
    private D metaData;

    protected HyperCubeNode(OneDimensionalBounds[] bounds, String id, HyperCubeTreeListener<T, D> listener) {
        this.bounds = bounds;
        this.dimensionality = bounds.length;
        this.midPoint = new double[this.dimensionality];
        for (int i = 0; i < this.dimensionality; ++i) {
            this.midPoint[i] = bounds[i].midpoint();
        }
        this.id = id;
        this.childNumber = 1 << this.dimensionality;
        this.children = new HyperCubeNode[this.childNumber];
        this.listener = listener;
        listener.nodeAdded(id, bounds, null);
    }

    @Override
    public void setMetaData(D metaData) {
        this.metaData = metaData;
    }

    @Override
    public D getMetaData() {
        return this.metaData;
    }

    @Override
    public void clear() {
        if (this.hasChildren) {
            this.hasChildren = false;
            for (int i = 0; i < this.childNumber; ++i) {
                if (this.children[i] != null) {
                    this.children[i].clear();
                    this.children[i] = null;
                    continue;
                }
                System.out.println("Trying to clear a null child");
                System.out.println("childNumber = " + this.childNumber);
                System.out.println("children.length = " + this.children.length);
            }
        }
        this.leaf = null;
        this.listener.nodeRemoved(this.id);
    }

    @Override
    public OneDimensionalBounds getBounds(int i) {
        return this.bounds[i];
    }

    @Override
    public OneDimensionalBounds[] getBoundsCopy() {
        return (OneDimensionalBounds[])this.bounds.clone();
    }

    @Override
    public int getDimensionality() {
        return this.dimensionality;
    }

    @Override
    public boolean hasChildren() {
        return this.hasChildren;
    }

    @Override
    public int getChildNumber() {
        return this.childNumber;
    }

    @Override
    public HyperCubeLeaf<T> getLeaf() {
        return this.leaf;
    }

    @Override
    public void setLeaf(HyperCubeLeaf<T> leaf) {
        if (this.hasChildren) {
            throw new RuntimeException("cannot have a leaf and children in node " + this);
        }
        this.leaf = leaf;
        this.listener.nodeRemoved(this.id);
        this.listener.nodeAdded(this.id, this.bounds, this.leaf);
    }

    @Override
    public void updateMetaDataListeners() {
        this.listener.metaDataUpdated(this.id, this.bounds, this.metaData);
    }

    @Override
    public void split() {
        for (int i = 0; i < this.childNumber; ++i) {
            OneDimensionalBounds[] subdividedBounds = this.subdivideBounds(this.toBooleanArray(i));
            this.children[i] = new HyperCubeNode<T, D>(subdividedBounds, this.id + "." + Integer.toHexString(i), this.listener);
        }
        this.hasChildren = true;
        if (this.leaf != null) {
            boolean[] sides = this.locatePoint(this.leaf.getLocation());
            int index = this.toIndex(sides);
            this.children[index].setLeaf(this.leaf);
            this.leaf = null;
        }
    }

    public String toString() {
        return this.toString(0);
    }

    @Override
    public RecursableHyperTreeNode<T, D> getChildAtLocation(double[] location) {
        int index = this.toIndex(this.locatePoint(location));
        HyperCubeNode<T, D> hyperCubeNode = this.children[index];
        if (null == hyperCubeNode) {
            throw new RuntimeException("child is null!");
        }
        return hyperCubeNode;
    }

    @Override
    public RecursableHyperTreeNode<T, D> getChild(int number) {
        return this.children[number];
    }

    protected List<HyperCubeLeaf<T>> gatherLeavesWithinBounds(OneDimensionalBounds[] gatherBounds) {
        ArrayList<HyperCubeLeaf<T>> ret = new ArrayList<HyperCubeLeaf<T>>();
        if (this.hasChildren) {
            for (int i = 0; i < this.childNumber; ++i) {
                ret.addAll(this.children[i].gatherLeavesWithinBounds(gatherBounds));
            }
        } else if (this.leaf != null) {
            ret.add(this.leaf);
        }
        return ret;
    }

    protected OneDimensionalBounds[] getBounds() {
        return this.bounds;
    }

    boolean getHasChildren() {
        return this.hasChildren;
    }

    boolean[] locatePoint(double[] location) {
        boolean[] sides = new boolean[this.dimensionality];
        for (int i = 0; i < this.dimensionality; ++i) {
            sides[i] = this.bounds[i].maxSide(location[i]);
        }
        return sides;
    }

    OneDimensionalBounds[] subdivideBounds(boolean[] sides) {
        OneDimensionalBounds[] subdividedBounds = new OneDimensionalBounds[this.dimensionality];
        for (int i = 0; i < this.dimensionality; ++i) {
            subdividedBounds[i] = this.bounds[i].subdivide(sides[i]);
        }
        return subdividedBounds;
    }

    boolean[] toBooleanArray(int index) {
        boolean[] ret = new boolean[this.dimensionality];
        for (int i = 0; i < this.dimensionality; ++i) {
            ret[i] = (index & 1 << this.dimensionality - i - 1) != 0;
        }
        return ret;
    }

    int toIndex(boolean[] sides) {
        int index = 0;
        for (int i = 0; i < this.dimensionality; ++i) {
            index = (index << 1) + (sides[i] ? 1 : 0);
        }
        return index;
    }

    private String toString(int tabs) {
        StringBuilder tabsBuilder = new StringBuilder(tabs);
        for (int i = 0; i < tabs; ++i) {
            tabsBuilder.append("\t");
        }
        String tabString = tabsBuilder.toString();
        StringBuilder ret = new StringBuilder(100);
        ret.append(tabString);
        ret.append("hyper cube node of dimensionality ");
        ret.append(this.dimensionality);
        if (this.hasChildren) {
            ret.append(" with the following children\n");
            for (int i = 0; i < this.childNumber; ++i) {
                ret.append(super.toString(tabs + 1));
            }
        } else {
            ret.append(" with no children ");
            if (null == this.leaf) {
                ret.append("and no value.");
            } else {
                ret.append("and value ");
                ret.append(this.leaf.getValue().toString());
                ret.append(".");
            }
            ret.append("\n");
            for (int i = 0; i < this.dimensionality; ++i) {
                ret.append(tabString);
                ret.append("\tdimension ");
                ret.append(i);
                ret.append(": ");
                ret.append(this.bounds[i].toString());
                ret.append("\n");
            }
        }
        return ret.toString();
    }

    public static boolean withinBounds(OneDimensionalBounds[] bounds, double[] input) {
        for (int i = 0; i < bounds.length; ++i) {
            if (bounds[i].contains(input[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public double[] getMidpoint() {
        return this.midPoint;
    }
}

