/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.graphics;

import us.ihmc.euclid.geometry.ConvexPolygon2D;
import us.ihmc.euclid.geometry.interfaces.ConvexPolygon2DReadOnly;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.graphicsDescription.Graphics3DObject;
import us.ihmc.graphicsDescription.MeshDataGenerator;
import us.ihmc.graphicsDescription.MeshDataHolder;
import us.ihmc.graphicsDescription.appearance.AppearanceDefinition;
import us.ihmc.graphicsDescription.appearance.YoAppearance;
import us.ihmc.graphicsDescription.instructions.Graphics3DAddMeshDataInstruction;
import us.ihmc.graphicsDescription.instructions.Graphics3DPrimitiveInstruction;
import us.ihmc.robotics.geometry.PlanarRegion;
import us.ihmc.robotics.geometry.PlanarRegionsList;

public class Graphics3DObjectTools {
    public static void addPlanarRegionsList(Graphics3DObject graphics3DObject, PlanarRegionsList planarRegions) {
        Graphics3DObjectTools.addPlanarRegionsList(graphics3DObject, planarRegions, YoAppearance.Black());
    }

    public static void addPlanarRegionsList(Graphics3DObject graphics3DObject, PlanarRegionsList planarRegions, AppearanceDefinition ... appearances) {
        int numberOfPlanarRegions = planarRegions.getNumberOfPlanarRegions();
        for (int i = 0; i < numberOfPlanarRegions; ++i) {
            Graphics3DObjectTools.addPlanarRegion(graphics3DObject, planarRegions.getPlanarRegion(i), appearances[i % appearances.length]);
        }
    }

    public static void addPlanarRegion(Graphics3DObject graphics3DObject, PlanarRegion planarRegion) {
        Graphics3DObjectTools.addPlanarRegion(graphics3DObject, planarRegion, YoAppearance.Black());
    }

    public static void addPlanarRegion(Graphics3DObject graphics3DObject, PlanarRegion planarRegion, AppearanceDefinition ... appearances) {
        double thickness = 1.0E-4;
        Graphics3DObjectTools.addPlanarRegion(graphics3DObject, planarRegion, thickness, appearances);
    }

    public static void addPlanarRegion(Graphics3DObject graphics3DObject, PlanarRegion planarRegion, double thickness, AppearanceDefinition ... appearances) {
        int numberOfConvexPolygons = planarRegion.getNumberOfConvexPolygons();
        RigidBodyTransform transform = new RigidBodyTransform();
        planarRegion.getTransformToWorld(transform);
        graphics3DObject.transform((RigidBodyTransformReadOnly)transform);
        double extrusionHeight = -Math.max(thickness, 1.0E-4);
        for (int i = 0; i < numberOfConvexPolygons; ++i) {
            ConvexPolygon2D convexPolygon = planarRegion.getConvexPolygon(i);
            MeshDataHolder meshDataHolder = MeshDataGenerator.ExtrudedPolygon((ConvexPolygon2DReadOnly)convexPolygon, (double)extrusionHeight);
            graphics3DObject.addInstruction((Graphics3DPrimitiveInstruction)new Graphics3DAddMeshDataInstruction(meshDataHolder, appearances[i % appearances.length]));
        }
        transform.invert();
        graphics3DObject.transform((RigidBodyTransformReadOnly)transform);
    }
}

