/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.geometry.shapes;

import java.util.List;
import us.ihmc.euclid.geometry.interfaces.Pose3DReadOnly;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.shape.primitives.Ramp3D;
import us.ihmc.euclid.shape.primitives.Shape3DPose;
import us.ihmc.euclid.shape.primitives.interfaces.IntermediateVariableSupplier;
import us.ihmc.euclid.shape.primitives.interfaces.Ramp3DReadOnly;
import us.ihmc.euclid.shape.primitives.interfaces.RampPolytope3DView;
import us.ihmc.euclid.shape.primitives.interfaces.Shape3DChangeListener;
import us.ihmc.euclid.shape.tools.EuclidShapeIOTools;
import us.ihmc.euclid.tools.EuclidCoreIOTools;
import us.ihmc.euclid.tools.EuclidHashCodeTools;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.robotics.geometry.shapes.STPShape3DTools;
import us.ihmc.robotics.geometry.shapes.interfaces.STPRamp3DBasics;
import us.ihmc.robotics.geometry.shapes.interfaces.STPRamp3DReadOnly;

public class STPRamp3D
implements STPRamp3DBasics {
    private double minimumMargin;
    private double maximumMargin;
    private double largeRadius;
    private double smallRadius;
    private final Ramp3D rawRamp3D = new Ramp3D();
    private final STPShape3DTools.STPRamp3DSupportingVertexCalculator supportingVertexCalculator = new STPShape3DTools.STPRamp3DSupportingVertexCalculator();
    private boolean stpRadiiDirty = true;

    public STPRamp3D() {
        this(1.0, 1.0, 1.0);
    }

    public STPRamp3D(double sizeX, double sizeY, double sizeZ) {
        this.getSize().set(sizeX, sizeY, sizeZ);
        this.setupListeners();
    }

    public STPRamp3D(Vector3DReadOnly size) {
        this.getSize().set((Tuple3DReadOnly)size);
        this.setupListeners();
    }

    public STPRamp3D(Point3DReadOnly position, Orientation3DReadOnly orientation, double sizeX, double sizeY, double sizeZ) {
        this.set(position, orientation, sizeX, sizeY, sizeZ);
        this.setupListeners();
    }

    public STPRamp3D(Point3DReadOnly position, Orientation3DReadOnly orientation, Vector3DReadOnly size) {
        this.set(position, orientation, size);
        this.setupListeners();
    }

    public STPRamp3D(RigidBodyTransformReadOnly pose, double sizeX, double sizeY, double sizeZ) {
        this.set(pose, sizeX, sizeY, sizeZ);
        this.setupListeners();
    }

    public STPRamp3D(RigidBodyTransformReadOnly pose, Vector3DReadOnly size) {
        this.set(pose, size);
        this.setupListeners();
    }

    public STPRamp3D(Pose3DReadOnly pose, double sizeX, double sizeY, double sizeZ) {
        this.set(pose, sizeX, sizeY, sizeZ);
        this.setupListeners();
    }

    public STPRamp3D(Pose3DReadOnly pose, Vector3DReadOnly size) {
        this.set(pose, size);
        this.setupListeners();
    }

    public STPRamp3D(Ramp3DReadOnly other) {
        this.set(other);
        this.setupListeners();
    }

    public STPRamp3D(STPRamp3DReadOnly other) {
        this.set(other);
        this.setupListeners();
    }

    private void setupListeners() {
        this.addChangeListener(() -> {
            this.stpRadiiDirty = true;
        });
    }

    public Shape3DPose getPose() {
        return this.rawRamp3D.getPose();
    }

    public Vector3DBasics getSize() {
        return this.rawRamp3D.getSize();
    }

    @Override
    public double getMinimumMargin() {
        return this.minimumMargin;
    }

    @Override
    public double getMaximumMargin() {
        return this.maximumMargin;
    }

    @Override
    public double getSmallRadius() {
        this.updateRadii();
        return this.smallRadius;
    }

    @Override
    public double getLargeRadius() {
        this.updateRadii();
        return this.largeRadius;
    }

    @Override
    public void setMargins(double minimumMargin, double maximumMargin) {
        if (maximumMargin <= minimumMargin) {
            throw new IllegalArgumentException("The maximum margin has to be strictly greater that the minimum margin, max margin: " + maximumMargin + ", min margin: " + minimumMargin);
        }
        this.minimumMargin = minimumMargin;
        this.maximumMargin = maximumMargin;
        this.stpRadiiDirty = true;
    }

    protected void updateRadii() {
        if (!this.stpRadiiDirty) {
            return;
        }
        this.stpRadiiDirty = false;
        if (this.minimumMargin == 0.0 && this.maximumMargin == 0.0) {
            this.smallRadius = Double.NaN;
            this.largeRadius = Double.NaN;
        } else {
            this.smallRadius = this.minimumMargin;
            this.largeRadius = STPShape3DTools.computeLargeRadiusFromMargins(this.minimumMargin, this.maximumMargin, STPShape3DTools.computeRamp3DMaximumEdgeLengthSquared((Vector3DReadOnly)this.getSize()));
        }
    }

    @Override
    public boolean getSupportingVertex(Vector3DReadOnly supportDirection, Point3DBasics supportingVertexToPack) {
        return this.supportingVertexCalculator.getSupportingVertex((Ramp3DReadOnly)this.rawRamp3D, this.getSmallRadius(), this.getLargeRadius(), supportDirection, supportingVertexToPack);
    }

    public Point3DReadOnly getCentroid() {
        return this.rawRamp3D.getCentroid();
    }

    public Vector3DReadOnly getRampSurfaceNormal() {
        return this.rawRamp3D.getRampSurfaceNormal();
    }

    public void getRampSurfaceNormal(Vector3DBasics surfaceNormalToPack) {
        this.rawRamp3D.getRampSurfaceNormal(surfaceNormalToPack);
    }

    public void notifyChangeListeners() {
        this.rawRamp3D.notifyChangeListeners();
    }

    public void addChangeListeners(List<? extends Shape3DChangeListener> listeners) {
        this.rawRamp3D.addChangeListeners(listeners);
    }

    public void addChangeListener(Shape3DChangeListener listener) {
        this.rawRamp3D.addChangeListener(listener);
    }

    public boolean removeChangeListener(Shape3DChangeListener listener) {
        return this.rawRamp3D.removeChangeListener(listener);
    }

    public IntermediateVariableSupplier getIntermediateVariableSupplier() {
        return this.rawRamp3D.getIntermediateVariableSupplier();
    }

    public void setIntermediateVariableSupplier(IntermediateVariableSupplier newSupplier) {
        this.rawRamp3D.setIntermediateVariableSupplier(newSupplier);
    }

    public double getRampLength() {
        return this.rawRamp3D.getRampLength();
    }

    public double getRampIncline() {
        return this.rawRamp3D.getRampIncline();
    }

    public STPRamp3D copy() {
        return new STPRamp3D(this);
    }

    public RampPolytope3DView asConvexPolytope() {
        return this.rawRamp3D.asConvexPolytope();
    }

    public boolean equals(Object object) {
        if (object instanceof STPRamp3DReadOnly) {
            return STPRamp3DBasics.super.equals((STPRamp3DReadOnly)object);
        }
        return false;
    }

    public int hashCode() {
        long hash = EuclidHashCodeTools.combineHashCode((long)this.rawRamp3D.hashCode(), (long)EuclidHashCodeTools.toLongHashCode((double)this.minimumMargin, (double)this.maximumMargin));
        return EuclidHashCodeTools.toIntHashCode((long)hash);
    }

    public String toString() {
        String stpSuffix = String.format(", small radius: " + EuclidCoreIOTools.DEFAULT_FORMAT + ", large radius: " + EuclidCoreIOTools.DEFAULT_FORMAT + "]", this.getSmallRadius(), this.getLargeRadius());
        return "STP " + EuclidShapeIOTools.getRamp3DString((Ramp3DReadOnly)this).replace("]", stpSuffix);
    }
}

