/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.geometry.shapes;

import us.ihmc.euclid.interfaces.GeometryObject;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.ReferenceFrameHolder;
import us.ihmc.euclid.shape.primitives.interfaces.Shape3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.robotics.geometry.shapes.FrameGeometryObject;

public abstract class FrameShape3d<F extends FrameShape3d<F, G>, G extends Shape3DBasics & GeometryObject<G>>
extends FrameGeometryObject<F, G> {
    public FrameShape3d(G shape3d) {
        super(ReferenceFrame.getWorldFrame(), (GeometryObject)shape3d);
    }

    public FrameShape3d(ReferenceFrame referenceFrame, G shape3d) {
        super(referenceFrame, (GeometryObject)shape3d);
    }

    public final double distance(FramePoint3D point) {
        this.checkReferenceFrameMatch((ReferenceFrameHolder)point);
        return ((Shape3DBasics)this.getGeometryObject()).distance((Point3DReadOnly)point);
    }

    public final void getClosestPointAndNormalAt(FramePoint3D closestPointToPack, FrameVector3D normalToPack, FramePoint3D pointInWorldToCheck) {
        this.checkReferenceFrameMatch((ReferenceFrameHolder)pointInWorldToCheck);
        closestPointToPack.setToZero(this.referenceFrame);
        normalToPack.setToZero(this.referenceFrame);
        ((Shape3DBasics)this.getGeometryObject()).evaluatePoint3DCollision((Point3DReadOnly)pointInWorldToCheck, (Point3DBasics)closestPointToPack, (Vector3DBasics)normalToPack);
    }

    public final boolean checkIfInside(Point3DBasics pointToCheck, Point3DBasics closestPointOnSurfaceToPack, Vector3DBasics normalToPack) {
        return ((Shape3DBasics)this.getGeometryObject()).evaluatePoint3DCollision((Point3DReadOnly)pointToCheck, closestPointOnSurfaceToPack, normalToPack);
    }

    public final boolean isInsideOrOnSurface(FramePoint3D pointToCheck) {
        this.checkReferenceFrameMatch((ReferenceFrameHolder)pointToCheck);
        return ((Shape3DBasics)this.getGeometryObject()).isPointInside((Point3DReadOnly)pointToCheck);
    }

    public final boolean isInsideOrOnSurface(FramePoint3D pointToCheck, double epsilon) {
        this.checkReferenceFrameMatch((ReferenceFrameHolder)pointToCheck);
        return ((Shape3DBasics)this.getGeometryObject()).isPointInside((Point3DReadOnly)pointToCheck, epsilon);
    }

    public final void orthogonalProjection(FramePoint3D pointToCheckAndPack) {
        this.checkReferenceFrameMatch((ReferenceFrameHolder)pointToCheckAndPack);
        ((Shape3DBasics)this.getGeometryObject()).orthogonalProjection((Point3DBasics)pointToCheckAndPack);
    }
}

