/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.geometry.shapes;

import java.util.List;
import us.ihmc.euclid.geometry.interfaces.Vertex3DSupplier;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFramePoint3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameShape3DPoseBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameBoundingBox3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameShape3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVertex3DSupplier;
import us.ihmc.euclid.referenceFrame.interfaces.ReferenceFrameHolder;
import us.ihmc.euclid.referenceFrame.polytope.FrameConvexPolytope3D;
import us.ihmc.euclid.referenceFrame.polytope.FrameFace3D;
import us.ihmc.euclid.referenceFrame.polytope.FrameHalfEdge3D;
import us.ihmc.euclid.referenceFrame.polytope.FrameVertex3D;
import us.ihmc.euclid.referenceFrame.polytope.interfaces.FrameConvexPolytope3DReadOnly;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameShapeIOTools;
import us.ihmc.euclid.shape.convexPolytope.interfaces.ConvexPolytope3DReadOnly;
import us.ihmc.euclid.tools.EuclidCoreFactories;
import us.ihmc.euclid.tools.EuclidCoreIOTools;
import us.ihmc.euclid.tools.EuclidHashCodeTools;
import us.ihmc.euclid.transform.interfaces.Transform;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.robotics.geometry.shapes.STPShape3DTools;
import us.ihmc.robotics.geometry.shapes.interfaces.FrameSTPConvexPolytope3DReadOnly;
import us.ihmc.robotics.geometry.shapes.interfaces.STPConvexPolytope3DReadOnly;
import us.ihmc.robotics.geometry.shapes.interfaces.STPShape3DBasics;

public class FrameSTPConvexPolytope3D
implements FrameSTPConvexPolytope3DReadOnly,
FrameShape3DBasics,
STPShape3DBasics {
    private double minimumMargin;
    private double maximumMargin;
    private double largeRadius;
    private double smallRadius;
    private final FrameConvexPolytope3D rawConvexPolytope3D;
    private final FrameBoundingBox3DReadOnly boundingBox;
    private final STPShape3DTools.STPConvexPolytope3DSupportingVertexCalculator supportingVertexCalculator = new STPShape3DTools.STPConvexPolytope3DSupportingVertexCalculator();
    private boolean stpRadiiDirty = true;

    public FrameSTPConvexPolytope3D() {
        this(ReferenceFrame.getWorldFrame());
    }

    public FrameSTPConvexPolytope3D(ReferenceFrame referenceFrame) {
        this(referenceFrame, 1.0E-10);
    }

    public FrameSTPConvexPolytope3D(ReferenceFrame referenceFrame, double constructionEpsilon) {
        this.rawConvexPolytope3D = new FrameConvexPolytope3D(referenceFrame, constructionEpsilon);
        FixedFramePoint3DBasics rawMinPoint = this.rawConvexPolytope3D.getBoundingBox().getMinPoint();
        FixedFramePoint3DBasics rawMaxPoint = this.rawConvexPolytope3D.getBoundingBox().getMaxPoint();
        Point3DReadOnly minPoint = EuclidCoreFactories.newLinkedPoint3DReadOnly(() -> this.lambda$new$0((Point3DReadOnly)rawMinPoint), () -> this.lambda$new$1((Point3DReadOnly)rawMinPoint), () -> this.lambda$new$2((Point3DReadOnly)rawMinPoint));
        Point3DReadOnly maxPoint = EuclidCoreFactories.newLinkedPoint3DReadOnly(() -> this.lambda$new$3((Point3DReadOnly)rawMaxPoint), () -> this.lambda$new$4((Point3DReadOnly)rawMaxPoint), () -> this.lambda$new$5((Point3DReadOnly)rawMaxPoint));
        this.boundingBox = STPShape3DTools.newLinkedFrameBoundingBox3DReadOnly((ReferenceFrameHolder)this, minPoint, maxPoint);
    }

    public FrameSTPConvexPolytope3D(ReferenceFrame referenceFrame, Vertex3DSupplier vertex3DSupplier) {
        this(referenceFrame);
        this.addVertices(vertex3DSupplier);
    }

    public FrameSTPConvexPolytope3D(FrameVertex3DSupplier vertex3DSupplier) {
        this(vertex3DSupplier.getReferenceFrame(), (Vertex3DSupplier)vertex3DSupplier);
    }

    public FrameSTPConvexPolytope3D(ReferenceFrame referenceFrame, Vertex3DSupplier vertex3DSupplier, double constructionEpsilon) {
        this(referenceFrame, constructionEpsilon);
        this.addVertices(vertex3DSupplier);
    }

    public FrameSTPConvexPolytope3D(FrameVertex3DSupplier vertex3DSupplier, double constructionEpsilon) {
        this(vertex3DSupplier.getReferenceFrame(), (Vertex3DSupplier)vertex3DSupplier, constructionEpsilon);
    }

    public FrameSTPConvexPolytope3D(ReferenceFrame referenceFrame, ConvexPolytope3DReadOnly other) {
        this(referenceFrame, other.getConstructionEpsilon());
        this.set(other);
    }

    public FrameSTPConvexPolytope3D(ReferenceFrame referenceFrame, STPConvexPolytope3DReadOnly other) {
        this(referenceFrame, other.getConstructionEpsilon());
        this.set(other);
    }

    public FrameSTPConvexPolytope3D(FrameConvexPolytope3DReadOnly other) {
        this(other.getReferenceFrame(), (ConvexPolytope3DReadOnly)other);
    }

    public FrameSTPConvexPolytope3D(FrameSTPConvexPolytope3DReadOnly other) {
        this(other.getReferenceFrame(), other);
    }

    public void set(ConvexPolytope3DReadOnly other) {
        this.rawConvexPolytope3D.set(other);
        this.stpRadiiDirty = true;
    }

    public void set(STPConvexPolytope3DReadOnly other) {
        this.rawConvexPolytope3D.set((ConvexPolytope3DReadOnly)other);
        this.minimumMargin = other.getMinimumMargin();
        this.maximumMargin = other.getMaximumMargin();
        this.stpRadiiDirty = true;
    }

    public void set(FrameConvexPolytope3DReadOnly other) {
        this.checkReferenceFrameMatch((ReferenceFrameHolder)other);
        this.set((ConvexPolytope3DReadOnly)other);
    }

    public void set(FrameSTPConvexPolytope3DReadOnly other) {
        this.checkReferenceFrameMatch((ReferenceFrameHolder)other);
        this.set((STPConvexPolytope3DReadOnly)other);
    }

    public void setIncludingFrame(FrameConvexPolytope3DReadOnly other) {
        this.setReferenceFrame(other.getReferenceFrame());
        this.set((ConvexPolytope3DReadOnly)other);
    }

    public void setIncludingFrame(FrameSTPConvexPolytope3DReadOnly other) {
        this.setReferenceFrame(other.getReferenceFrame());
        this.set((STPConvexPolytope3DReadOnly)other);
    }

    public void setReferenceFrame(ReferenceFrame referenceFrame) {
        this.rawConvexPolytope3D.setReferenceFrame(referenceFrame);
    }

    public void changeFrame(ReferenceFrame desiredFrame) {
        this.rawConvexPolytope3D.changeFrame(desiredFrame);
    }

    public void setToNaN() {
        this.rawConvexPolytope3D.setToNaN();
        this.stpRadiiDirty = true;
    }

    public void setToZero() {
        this.rawConvexPolytope3D.setToZero();
        this.stpRadiiDirty = true;
    }

    public boolean addVertex(Point3DReadOnly vertexToAdd) {
        return this.addVertices(Vertex3DSupplier.asVertex3DSupplier((Point3DReadOnly[])new Point3DReadOnly[]{vertexToAdd}));
    }

    public boolean addVertex(FramePoint3DReadOnly vertexToAdd) {
        this.checkReferenceFrameMatch((ReferenceFrameHolder)vertexToAdd);
        return this.addVertex((Point3DReadOnly)vertexToAdd);
    }

    public boolean addVertices(Vertex3DSupplier vertex3DSupplier) {
        boolean wasAdded = this.rawConvexPolytope3D.addVertices(vertex3DSupplier);
        if (wasAdded) {
            this.stpRadiiDirty = true;
        }
        return wasAdded;
    }

    public boolean addVertices(FrameVertex3DSupplier vertex3DSupplier) {
        this.checkReferenceFrameMatch((ReferenceFrameHolder)vertex3DSupplier);
        return this.addVertices((Vertex3DSupplier)vertex3DSupplier);
    }

    @Override
    public double getMinimumMargin() {
        return this.minimumMargin;
    }

    @Override
    public double getMaximumMargin() {
        return this.maximumMargin;
    }

    @Override
    public double getSmallRadius() {
        this.updateRadii();
        return this.smallRadius;
    }

    @Override
    public double getLargeRadius() {
        this.updateRadii();
        return this.largeRadius;
    }

    @Override
    public void setMargins(double minimumMargin, double maximumMargin) {
        if (maximumMargin <= minimumMargin) {
            throw new IllegalArgumentException("The maximum margin has to be strictly greater that the minimum margin, max margin: " + maximumMargin + ", min margin: " + minimumMargin);
        }
        this.minimumMargin = minimumMargin;
        this.maximumMargin = maximumMargin;
        this.stpRadiiDirty = true;
    }

    protected void updateRadii() {
        if (!this.stpRadiiDirty) {
            return;
        }
        this.stpRadiiDirty = false;
        if (this.minimumMargin == 0.0 && this.maximumMargin == 0.0) {
            this.smallRadius = Double.NaN;
            this.largeRadius = Double.NaN;
        } else {
            this.smallRadius = this.minimumMargin;
            this.largeRadius = STPShape3DTools.computeLargeRadiusFromMargins(this.minimumMargin, this.maximumMargin, STPShape3DTools.computeConvexPolytope3DMaximumEdgeLengthSquared((ConvexPolytope3DReadOnly)this.rawConvexPolytope3D));
        }
    }

    public boolean containsNaN() {
        return this.rawConvexPolytope3D.containsNaN();
    }

    public double getVolume() {
        return this.rawConvexPolytope3D.getVolume();
    }

    public List<FrameFace3D> getFaces() {
        return this.rawConvexPolytope3D.getFaces();
    }

    public List<FrameHalfEdge3D> getHalfEdges() {
        return this.rawConvexPolytope3D.getHalfEdges();
    }

    public List<FrameVertex3D> getVertices() {
        return this.rawConvexPolytope3D.getVertices();
    }

    public double getConstructionEpsilon() {
        return this.rawConvexPolytope3D.getConstructionEpsilon();
    }

    public ReferenceFrame getReferenceFrame() {
        return this.rawConvexPolytope3D.getReferenceFrame();
    }

    public FrameBoundingBox3DReadOnly getBoundingBox() {
        return this.boundingBox;
    }

    public FrameSTPConvexPolytope3D copy() {
        return new FrameSTPConvexPolytope3D(this);
    }

    public FramePoint3DReadOnly getCentroid() {
        return this.rawConvexPolytope3D.getCentroid();
    }

    @Override
    public boolean getSupportingVertex(Vector3DReadOnly supportDirection, Point3DBasics supportingVertexToPack) {
        return this.supportingVertexCalculator.getSupportingVertex(this, this.getSmallRadius(), this.getLargeRadius(), supportDirection, supportingVertexToPack);
    }

    public FixedFrameShape3DPoseBasics getPose() {
        return null;
    }

    public void applyTransform(Transform transform) {
        this.rawConvexPolytope3D.applyTransform(transform);
    }

    public void applyInverseTransform(Transform transform) {
        this.rawConvexPolytope3D.applyInverseTransform(transform);
    }

    public boolean equals(Object object) {
        if (object instanceof FrameSTPConvexPolytope3DReadOnly) {
            return FrameSTPConvexPolytope3DReadOnly.super.equals((FrameSTPConvexPolytope3DReadOnly)object);
        }
        return false;
    }

    public int hashCode() {
        long hash = EuclidHashCodeTools.combineHashCode((long)this.rawConvexPolytope3D.hashCode(), (long)EuclidHashCodeTools.toLongHashCode((double)this.minimumMargin, (double)this.maximumMargin));
        return EuclidHashCodeTools.toIntHashCode((long)hash);
    }

    public String toString() {
        String stpSuffix = String.format("\nsmall radius: " + EuclidCoreIOTools.DEFAULT_FORMAT + ", large radius: " + EuclidCoreIOTools.DEFAULT_FORMAT + "]", this.getSmallRadius(), this.getLargeRadius());
        return "STP" + EuclidFrameShapeIOTools.getFrameConvexPolytope3DString((FrameConvexPolytope3DReadOnly)this) + stpSuffix;
    }

    private /* synthetic */ double lambda$new$5(Point3DReadOnly rawMaxPoint) {
        return rawMaxPoint.getZ() - this.maximumMargin;
    }

    private /* synthetic */ double lambda$new$4(Point3DReadOnly rawMaxPoint) {
        return rawMaxPoint.getY() - this.maximumMargin;
    }

    private /* synthetic */ double lambda$new$3(Point3DReadOnly rawMaxPoint) {
        return rawMaxPoint.getX() - this.maximumMargin;
    }

    private /* synthetic */ double lambda$new$2(Point3DReadOnly rawMinPoint) {
        return rawMinPoint.getZ() + this.maximumMargin;
    }

    private /* synthetic */ double lambda$new$1(Point3DReadOnly rawMinPoint) {
        return rawMinPoint.getY() + this.maximumMargin;
    }

    private /* synthetic */ double lambda$new$0(Point3DReadOnly rawMinPoint) {
        return rawMinPoint.getX() + this.maximumMargin;
    }
}

