/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.geometry.shapes;

import us.ihmc.euclid.Axis3D;
import us.ihmc.euclid.geometry.Plane3D;
import us.ihmc.euclid.geometry.interfaces.Line3DReadOnly;
import us.ihmc.euclid.geometry.interfaces.Plane3DReadOnly;
import us.ihmc.euclid.referenceFrame.FrameLine3D;
import us.ihmc.euclid.referenceFrame.FramePoint2D;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.ReferenceFrameHolder;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.Transform;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;

public class FramePlane3d
implements ReferenceFrameHolder {
    private ReferenceFrame referenceFrame;
    private final Plane3D plane3d;
    private final RigidBodyTransform temporaryTransformToDesiredFrame = new RigidBodyTransform();
    private final Vector3D temporaryVector = new Vector3D();
    private final Point3D temporaryPoint = new Point3D();

    public FramePlane3d() {
        this(ReferenceFrame.getWorldFrame());
    }

    public FramePlane3d(ReferenceFrame referenceFrame, Plane3D plane3d) {
        this.referenceFrame = referenceFrame;
        this.plane3d = plane3d;
    }

    public FramePlane3d(ReferenceFrame referenceFrame) {
        this.referenceFrame = referenceFrame;
        this.plane3d = new Plane3D();
    }

    public FramePlane3d(FramePlane3d framePlane3d) {
        this.referenceFrame = framePlane3d.referenceFrame;
        this.plane3d = new Plane3D(framePlane3d.plane3d);
    }

    public FramePlane3d(FrameVector3D normal, FramePoint3D point) {
        normal.checkReferenceFrameMatch((ReferenceFrameHolder)point);
        this.referenceFrame = normal.getReferenceFrame();
        this.plane3d = new Plane3D((Point3DReadOnly)point, (Vector3DReadOnly)normal);
    }

    public FramePlane3d(ReferenceFrame referenceFrame, Point3DReadOnly point, Vector3DReadOnly normal) {
        this.referenceFrame = referenceFrame;
        this.plane3d = new Plane3D(point, normal);
    }

    public ReferenceFrame getReferenceFrame() {
        return this.referenceFrame;
    }

    public void getNormal(FrameVector3D normalToPack) {
        this.checkReferenceFrameMatch(normalToPack.getReferenceFrame());
        this.temporaryVector.set((Tuple3DReadOnly)this.plane3d.getNormal());
        normalToPack.set((Tuple3DReadOnly)this.temporaryVector);
    }

    public FrameVector3D getNormalCopy() {
        FrameVector3D returnVector = new FrameVector3D(this.referenceFrame);
        this.getNormal(returnVector);
        return returnVector;
    }

    public Vector3DBasics getNormal() {
        return this.plane3d.getNormal();
    }

    public void setNormal(double x, double y, double z) {
        this.plane3d.getNormal().set(x, y, z);
    }

    public void setNormal(Vector3DReadOnly normal) {
        this.plane3d.getNormal().set((Tuple3DReadOnly)normal);
    }

    public void getPoint(FramePoint3D pointToPack) {
        this.checkReferenceFrameMatch(pointToPack.getReferenceFrame());
        this.temporaryPoint.set((Tuple3DReadOnly)this.plane3d.getPoint());
        pointToPack.set((Tuple3DReadOnly)this.temporaryPoint);
    }

    public FramePoint3D getPointCopy() {
        FramePoint3D pointToReturn = new FramePoint3D(this.getReferenceFrame());
        this.getPoint(pointToReturn);
        return pointToReturn;
    }

    public Point3DBasics getPoint() {
        return this.plane3d.getPoint();
    }

    public void setPoint(double x, double y, double z) {
        this.plane3d.getPoint().set(x, y, z);
    }

    public void setPoint(Point3DReadOnly point) {
        this.plane3d.getPoint().set((Tuple3DReadOnly)point);
    }

    public void setPoints(FramePoint3D pointA, FramePoint3D pointB, FramePoint3D pointC) {
        pointA.checkReferenceFrameMatch(this.referenceFrame);
        pointB.checkReferenceFrameMatch(this.referenceFrame);
        pointC.checkReferenceFrameMatch(this.referenceFrame);
        this.plane3d.set((Point3DReadOnly)pointA, (Point3DReadOnly)pointB, (Point3DReadOnly)pointC);
    }

    public void changeFrame(ReferenceFrame desiredFrame) {
        if (desiredFrame != this.referenceFrame) {
            this.referenceFrame.getTransformToDesiredFrame(this.temporaryTransformToDesiredFrame, desiredFrame);
            this.plane3d.applyTransform((Transform)this.temporaryTransformToDesiredFrame);
            this.referenceFrame = desiredFrame;
        }
    }

    public boolean isOnOrAbove(FramePoint3D pointToTest) {
        this.checkReferenceFrameMatch((ReferenceFrameHolder)pointToTest);
        return this.plane3d.isOnOrAbove((Point3DReadOnly)pointToTest);
    }

    public boolean isOnOrAbove(Point3DReadOnly pointToTest) {
        return this.plane3d.isOnOrAbove(pointToTest);
    }

    public boolean isOnOrAbove(Point3DReadOnly pointToTest, double epsilon) {
        return this.plane3d.isOnOrAbove(pointToTest, epsilon);
    }

    public boolean isOnOrBelow(FramePoint3D pointToTest) {
        this.checkReferenceFrameMatch((ReferenceFrameHolder)pointToTest);
        return this.plane3d.isOnOrBelow((Point3DReadOnly)pointToTest);
    }

    public boolean isParallel(FramePlane3d otherPlane, double angleEpsilon) {
        this.checkReferenceFrameMatch(otherPlane);
        return this.plane3d.isParallel((Plane3DReadOnly)otherPlane.plane3d, angleEpsilon);
    }

    public boolean isCoincident(FramePlane3d otherPlane, double angleEpsilon, double distanceEpsilon) {
        this.checkReferenceFrameMatch(otherPlane);
        return this.plane3d.isCoincident((Plane3DReadOnly)otherPlane.plane3d, angleEpsilon, distanceEpsilon);
    }

    public FramePoint3D orthogonalProjectionCopy(FramePoint3D point) {
        this.checkReferenceFrameMatch((ReferenceFrameHolder)point);
        FramePoint3D returnPoint = new FramePoint3D((FrameTuple3DReadOnly)point);
        this.orthogonalProjection(returnPoint);
        return returnPoint;
    }

    public void orthogonalProjection(FramePoint3D point) {
        this.checkReferenceFrameMatch((ReferenceFrameHolder)point);
        this.plane3d.orthogonalProjection((Point3DBasics)point);
    }

    public double getZOnPlane(FramePoint2D xyPoint) {
        this.checkReferenceFrameMatch(xyPoint.getReferenceFrame());
        return this.plane3d.getZOnPlane(xyPoint.getX(), xyPoint.getY());
    }

    public double distance(FramePoint3D point) {
        this.checkReferenceFrameMatch((ReferenceFrameHolder)point);
        return this.plane3d.distance((Point3DReadOnly)point);
    }

    public boolean epsilonEquals(FramePlane3d plane, double epsilon) {
        this.checkReferenceFrameMatch(plane.getReferenceFrame());
        return this.referenceFrame == plane.getReferenceFrame() && plane.plane3d.epsilonEquals(this.plane3d, epsilon);
    }

    public FramePlane3d applyTransformCopy(RigidBodyTransform transformation) {
        FramePlane3d returnPlane = new FramePlane3d(this);
        returnPlane.applyTransform(transformation);
        return returnPlane;
    }

    public void applyTransform(RigidBodyTransform transformation) {
        this.plane3d.applyTransform((Transform)transformation);
    }

    public void setIncludingFrame(ReferenceFrame referenceFrame, double pointX, double pointY, double pointZ, double normalX, double normalY, double normalZ) {
        this.referenceFrame = referenceFrame;
        this.plane3d.getPoint().set(pointX, pointY, pointZ);
        this.plane3d.getNormal().set(normalX, normalY, normalZ);
    }

    public void getIntersectionWithLine(FramePoint3D pointToPack, FrameLine3D line) {
        this.checkReferenceFrameMatch(line.getReferenceFrame());
        this.checkReferenceFrameMatch(pointToPack.getReferenceFrame());
        Point3D intersectionToPack = new Point3D();
        this.plane3d.intersectionWith((Point3DBasics)intersectionToPack, (Point3DReadOnly)line.getPoint(), (Vector3DReadOnly)line.getDirection());
        pointToPack.set((Tuple3DReadOnly)intersectionToPack);
    }

    public void getIntersectionWithLine(Point3D pointToPack, Line3DReadOnly line) {
        this.plane3d.intersectionWith((Point3DBasics)pointToPack, line.getPoint(), (Vector3DReadOnly)line.getDirection());
    }

    public void setToZero() {
        this.getPoint().setToZero();
        this.getNormal().set((Tuple3DReadOnly)Axis3D.Z);
    }

    public void setToZero(ReferenceFrame referenceFrame) {
        this.setReferenceFrame(referenceFrame);
        this.setToZero();
    }

    public void setReferenceFrame(ReferenceFrame referenceFrame) {
        this.referenceFrame = referenceFrame;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ReferenceFrame = " + this.referenceFrame + ", " + this.plane3d.toString());
        return builder.toString();
    }
}

