/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.geometry.shapes;

import us.ihmc.euclid.interfaces.GeometryObject;
import us.ihmc.euclid.interfaces.Transformable;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.ReferenceFrameHolder;
import us.ihmc.euclid.transform.interfaces.Transform;

public abstract class FrameGeometryObject<F extends FrameGeometryObject<F, G>, G extends GeometryObject<G>>
implements ReferenceFrameHolder,
GeometryObject<F> {
    private final G geometryObject;
    protected ReferenceFrame referenceFrame;

    public FrameGeometryObject(G geometryObject) {
        this(ReferenceFrame.getWorldFrame(), geometryObject);
    }

    public FrameGeometryObject(ReferenceFrame referenceFrame, G geometryObject) {
        this.geometryObject = geometryObject;
        this.referenceFrame = referenceFrame;
    }

    public final void setToZero() {
        this.geometryObject.setToZero();
    }

    public final void setToZero(ReferenceFrame referenceFrame) {
        this.referenceFrame = referenceFrame;
        this.setToZero();
    }

    public final void setToNaN() {
        this.geometryObject.setToNaN();
    }

    public final void setToNaN(ReferenceFrame referenceFrame) {
        this.referenceFrame = referenceFrame;
        this.setToNaN();
    }

    public final boolean containsNaN() {
        return this.geometryObject.containsNaN();
    }

    public final void set(G geometryObject) {
        this.geometryObject.set(geometryObject);
    }

    public final void set(ReferenceFrame referenceFrame, G geometryObject) {
        this.checkReferenceFrameMatch(referenceFrame);
        this.geometryObject.set(geometryObject);
    }

    public final void setIncludingFrame(ReferenceFrame referenceFrame, G geometryObject) {
        this.referenceFrame = referenceFrame;
        this.geometryObject.set(geometryObject);
    }

    public final void set(F other) {
        this.checkReferenceFrameMatch((ReferenceFrameHolder)other);
        this.geometryObject.set(((FrameGeometryObject)other).getGeometryObject());
    }

    public final void setIncludingFrame(F other) {
        this.referenceFrame = ((FrameGeometryObject)other).getReferenceFrame();
        this.geometryObject.set(((FrameGeometryObject)other).getGeometryObject());
    }

    public final void setFromReferenceFrame(ReferenceFrame referenceFrame) {
        ReferenceFrame thisReferenceFrame = this.getReferenceFrame();
        this.setToZero(referenceFrame);
        this.changeFrame(thisReferenceFrame);
    }

    public void changeFrame(ReferenceFrame desiredFrame) {
        this.referenceFrame.transformFromThisToDesiredFrame(desiredFrame, (Transformable)this);
        this.referenceFrame = desiredFrame;
    }

    public final void applyTransform(Transform transform) {
        this.geometryObject.applyTransform(transform);
    }

    public final void applyInverseTransform(Transform transform) {
        this.geometryObject.applyInverseTransform(transform);
    }

    public final ReferenceFrame getReferenceFrame() {
        return this.referenceFrame;
    }

    public void get(G geometryObjectToPack) {
        geometryObjectToPack.set(this.geometryObject);
    }

    public final G getGeometryObject() {
        return this.geometryObject;
    }

    public final boolean epsilonEquals(F other, double epsilon) {
        if (this.referenceFrame != ((FrameGeometryObject)other).referenceFrame) {
            return false;
        }
        return this.geometryObject.epsilonEquals(((FrameGeometryObject)other).getGeometryObject(), epsilon);
    }

    public boolean geometricallyEquals(F other, double epsilon) {
        if (this.referenceFrame != ((FrameGeometryObject)other).referenceFrame) {
            return false;
        }
        return this.geometryObject.geometricallyEquals(((FrameGeometryObject)other).getGeometryObject(), epsilon);
    }

    public final boolean equals(Object object) {
        try {
            return this.equals((F)((FrameGeometryObject)object));
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    public final boolean equals(F other) {
        try {
            if (this.referenceFrame != ((FrameGeometryObject)other).referenceFrame) {
                return false;
            }
            return this.geometryObject.equals(((FrameGeometryObject)other).getGeometryObject());
        }
        catch (NullPointerException e) {
            return false;
        }
    }

    public String toString() {
        return this.geometryObject + "-" + this.referenceFrame;
    }
}

