/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.geometry.concavePolygon2D.clippingAndMerging;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.log.LogTools;
import us.ihmc.robotics.geometry.concavePolygon2D.ComplexPolygonException;
import us.ihmc.robotics.geometry.concavePolygon2D.ConcavePolygon2D;
import us.ihmc.robotics.geometry.concavePolygon2D.ConcavePolygon2DBasics;
import us.ihmc.robotics.geometry.concavePolygon2D.ConcavePolygon2DReadOnly;
import us.ihmc.robotics.geometry.concavePolygon2D.GeometryPolygonTools;
import us.ihmc.robotics.geometry.concavePolygon2D.clippingAndMerging.ConcavePolygon2DClippingTools;

public class PolygonClippingAndMerging {
    public static void removeHolesFromList(List<ConcavePolygon2DBasics> regionsToFilter) {
        int i = 0;
        while (i < regionsToFilter.size()) {
            ConcavePolygon2DBasics polygonA = regionsToFilter.get(i);
            boolean shouldRemoveA = false;
            int j = 0;
            while (j < regionsToFilter.size()) {
                if (i == j) {
                    ++j;
                    continue;
                }
                ConcavePolygon2DBasics polygonB = regionsToFilter.get(j);
                if (GeometryPolygonTools.isPolygonInsideOtherPolygon(polygonB, polygonA)) {
                    regionsToFilter.remove(j);
                    break;
                }
                if (GeometryPolygonTools.isPolygonInsideOtherPolygon(polygonA, polygonB)) {
                    shouldRemoveA = true;
                    break;
                }
                ++j;
            }
            if (shouldRemoveA) {
                regionsToFilter.remove(i);
                continue;
            }
            ++i;
        }
    }

    public static void mergeAllPossible(List<ConcavePolygon2DBasics> regionsToMerge) {
        PolygonClippingAndMerging.removeHolesFromList(regionsToMerge);
        for (int i = 0; i < regionsToMerge.size() - 1; ++i) {
            int j = i + 1;
            while (j < regionsToMerge.size()) {
                ConcavePolygon2DBasics polygonB;
                ConcavePolygon2DBasics polygonA = regionsToMerge.get(i);
                if (GeometryPolygonTools.doPolygonsIntersect(polygonA, polygonB = regionsToMerge.get(j))) {
                    ConcavePolygon2D newPolygon = new ConcavePolygon2D();
                    try {
                        PolygonClippingAndMerging.merge(polygonA, polygonB, newPolygon);
                    }
                    catch (ComplexPolygonException exception) {
                        try {
                            PolygonClippingAndMerging.merge(polygonA, polygonB, newPolygon);
                        }
                        catch (ComplexPolygonException repeatException) {
                            ++j;
                            LogTools.info((String)"Caught an error when trying to merge.");
                            continue;
                        }
                    }
                    regionsToMerge.set(i, newPolygon);
                    regionsToMerge.remove(j);
                    j = i + 1;
                    continue;
                }
                ++j;
            }
        }
    }

    public static void merge(ConcavePolygon2DReadOnly polygonA, ConcavePolygon2DReadOnly polygonB, ConcavePolygon2DBasics mergedPolygon) {
        ArrayList<ConcavePolygon2D> partialListOfHoles = new ArrayList<ConcavePolygon2D>();
        if (GeometryPolygonTools.isPolygonInsideOtherPolygon(polygonA, polygonB)) {
            mergedPolygon.set(polygonB);
            return;
        }
        if (GeometryPolygonTools.isPolygonInsideOtherPolygon(polygonB, polygonA)) {
            mergedPolygon.set(polygonA);
            return;
        }
        if (polygonA.epsilonEquals(polygonB, 1.0E-5)) {
            mergedPolygon.set(polygonA);
            return;
        }
        ConcavePolygon2DClippingTools.LinkedPointList polygonAList = ConcavePolygon2DClippingTools.createLinkedPointList(polygonA);
        ConcavePolygon2DClippingTools.LinkedPointList polygonBList = ConcavePolygon2DClippingTools.createLinkedPointList(polygonB);
        ConcavePolygon2DClippingTools.insertIntersectionsIntoList(polygonAList, polygonB);
        ConcavePolygon2DClippingTools.insertIntersectionsIntoList(polygonBList, polygonA);
        ConcavePolygon2DClippingTools.linkSharedVertices(polygonAList, polygonBList, 0.005);
        Collection<ConcavePolygon2DClippingTools.LinkedPoint> unassignedAPoints = polygonAList.getPointsCopy();
        Collection<ConcavePolygon2DClippingTools.LinkedPoint> unassignedBPoints = polygonBList.getPointsCopy();
        ConcavePolygon2DClippingTools.LinkedPointListHolder listHolder = new ConcavePolygon2DClippingTools.LinkedPointListHolder(unassignedAPoints, unassignedBPoints);
        ConcavePolygon2DClippingTools.LinkedPoint startPoint = PolygonClippingAndMerging.findVertexOutsideOfPolygon(polygonB, unassignedAPoints);
        if (startPoint == null) {
            startPoint = PolygonClippingAndMerging.findVertexOutsideOfPolygon(polygonA, unassignedBPoints);
        }
        mergedPolygon.clear();
        mergedPolygon.update();
        while (startPoint != null) {
            boolean failed;
            ConcavePolygon2D polygon = new ConcavePolygon2D();
            boolean bl = failed = !PolygonClippingAndMerging.walkAlongEdgeOfPolygon(startPoint, listHolder, polygon, PolygonClippingAndMerging::shouldSwitchWhenMerging);
            if (failed) {
                mergedPolygon.set(polygonA);
                return;
            }
            if (Double.isNaN(mergedPolygon.getArea())) {
                mergedPolygon.set(polygon);
            } else if (polygon.getArea() > mergedPolygon.getArea()) {
                partialListOfHoles.add(new ConcavePolygon2D(mergedPolygon));
                mergedPolygon.set(polygon);
            } else {
                partialListOfHoles.add(polygon);
            }
            if ((startPoint = PolygonClippingAndMerging.findVertexOutsideOfPolygon(mergedPolygon, unassignedAPoints)) != null) continue;
            startPoint = PolygonClippingAndMerging.findVertexOutsideOfPolygon(mergedPolygon, unassignedBPoints);
        }
    }

    public static List<ConcavePolygon2DBasics> removeAreaInsideClip(ConcavePolygon2DReadOnly clippingPolygon, ConcavePolygon2DReadOnly polygonToClip) {
        ArrayList<ConcavePolygon2DBasics> clippedPolygonsToReturn = new ArrayList<ConcavePolygon2DBasics>();
        if (GeometryPolygonTools.isPolygonInsideOtherPolygon(clippingPolygon, polygonToClip)) {
            ConcavePolygon2D polygonToReturn = new ConcavePolygon2D(clippingPolygon);
            clippedPolygonsToReturn.add(polygonToReturn);
            return clippedPolygonsToReturn;
        }
        if (!GeometryPolygonTools.doPolygonsIntersect(clippingPolygon, polygonToClip)) {
            ConcavePolygon2D polygonToReturn = new ConcavePolygon2D(polygonToClip);
            clippedPolygonsToReturn.add(polygonToReturn);
            return clippedPolygonsToReturn;
        }
        ConcavePolygon2DClippingTools.LinkedPointList clippingPolygonList = ConcavePolygon2DClippingTools.createLinkedPointList(clippingPolygon);
        ConcavePolygon2DClippingTools.LinkedPointList polygonToClipList = ConcavePolygon2DClippingTools.createLinkedPointList(polygonToClip);
        ConcavePolygon2DClippingTools.insertIntersectionsIntoList(polygonToClipList, clippingPolygon);
        ConcavePolygon2DClippingTools.insertIntersectionsIntoList(clippingPolygonList, polygonToClip);
        ConcavePolygon2DClippingTools.linkSharedVertices(polygonToClipList, clippingPolygonList, 0.005);
        clippingPolygonList.reverseOrder();
        Collection<ConcavePolygon2DClippingTools.LinkedPoint> unassignedToClipPoints = polygonToClipList.getPointsCopy();
        Collection<ConcavePolygon2DClippingTools.LinkedPoint> unassignedClippingPoints = clippingPolygonList.getPointsCopy();
        ConcavePolygon2DClippingTools.LinkedPointListHolder listHolder = new ConcavePolygon2DClippingTools.LinkedPointListHolder(unassignedClippingPoints, unassignedToClipPoints);
        ConcavePolygon2DClippingTools.LinkedPoint startPoint = PolygonClippingAndMerging.findVertexOutsideOfPolygon(clippingPolygon, unassignedToClipPoints);
        if (startPoint == null) {
            for (ConcavePolygon2DClippingTools.LinkedPoint point : unassignedToClipPoints) {
                if (point.isPointAfterInsideOther() || !point.isPointBeforeInsideOther()) continue;
                startPoint = point;
                break;
            }
        }
        while (startPoint != null) {
            ConcavePolygon2D clippedPolygon = new ConcavePolygon2D();
            boolean failed = !PolygonClippingAndMerging.walkAlongEdgeOfPolygon(startPoint, listHolder, clippedPolygon, PolygonClippingAndMerging::shouldSwitchWhenClipping);
            clippedPolygonsToReturn.add(clippedPolygon);
            if (failed) {
                clippedPolygon.set(polygonToClip);
                return clippedPolygonsToReturn;
            }
            startPoint = PolygonClippingAndMerging.findVertexOutsideOfPolygon(clippingPolygon, unassignedToClipPoints);
        }
        return clippedPolygonsToReturn;
    }

    static boolean walkAlongEdgeOfPolygon(ConcavePolygon2DClippingTools.LinkedPoint startVertex, ConcavePolygon2DClippingTools.LinkedPointListHolder listHolder, ConcavePolygon2DBasics polygonToPack, SwitchingFunction switchFunction) {
        int counter;
        ConcavePolygon2DClippingTools.LinkedPoint linkedPoint;
        ConcavePolygon2DClippingTools.LinkedPoint previousPoint = linkedPoint = startVertex;
        int maxPoints = listHolder.getNumberOfPoints();
        polygonToPack.addVertex(linkedPoint.getPoint());
        boolean isOnOtherList = false;
        for (counter = 0; counter < maxPoints; ++counter) {
            linkedPoint = linkedPoint.getSuccessor();
            listHolder.removePoint(previousPoint);
            if (linkedPoint.getPoint().epsilonEquals((Tuple2DReadOnly)startVertex.getPoint(), 1.0E-5)) break;
            polygonToPack.addVertex(linkedPoint.getPoint());
            boolean shouldSwitch = switchFunction.apply(linkedPoint, isOnOtherList);
            if (shouldSwitch) {
                isOnOtherList = !isOnOtherList;
                previousPoint = linkedPoint;
                if ((linkedPoint = linkedPoint.getPointOnOtherList()) != null) continue;
                throw new RuntimeException("Was unable to find the intersection point in the other list.");
            }
            previousPoint = linkedPoint;
        }
        if (counter >= maxPoints) {
            return false;
        }
        polygonToPack.update();
        return true;
    }

    private static boolean shouldSwitch(ConcavePolygon2DClippingTools.LinkedPoint linkedPoint) {
        return linkedPoint.isPointAfterInsideOther() != linkedPoint.isPointBeforeInsideOther();
    }

    private static boolean shouldSwitchWhenMerging(ConcavePolygon2DClippingTools.LinkedPoint linkedPoint, boolean isOnOtherList) {
        boolean shouldSwitch = PolygonClippingAndMerging.shouldSwitch(linkedPoint);
        boolean outgoingPoint = linkedPoint.isPointBeforeInsideOther() && !linkedPoint.isPointAfterInsideOther();
        shouldSwitch |= linkedPoint.isLinkedToOtherList() && PolygonClippingAndMerging.shouldSwitch(linkedPoint.getPointOnOtherList());
        if (!linkedPoint.isPointAfterInsideOther() && !linkedPoint.isPointBeforeInsideOther()) {
            shouldSwitch = false;
        }
        if (outgoingPoint) {
            shouldSwitch = false;
        }
        return shouldSwitch;
    }

    private static boolean shouldSwitchWhenClipping(ConcavePolygon2DClippingTools.LinkedPoint linkedPoint, boolean isOnOtherList) {
        boolean shouldSwitch = PolygonClippingAndMerging.shouldSwitch(linkedPoint);
        shouldSwitch |= linkedPoint.isLinkedToOtherList() && PolygonClippingAndMerging.shouldSwitch(linkedPoint.getPointOnOtherList());
        if (linkedPoint.isLinkedToOtherList()) {
            ConcavePolygon2DClippingTools.LinkedPoint clippedPoint;
            ConcavePolygon2DClippingTools.LinkedPoint clippingPoint = isOnOtherList ? linkedPoint : linkedPoint.getPointOnOtherList();
            ConcavePolygon2DClippingTools.LinkedPoint linkedPoint2 = clippedPoint = isOnOtherList ? linkedPoint.getPointOnOtherList() : linkedPoint;
            if (clippingPoint.isPointBeforeInsideOther() && clippingPoint.isPointAfterInsideOther() && !clippedPoint.isPointBeforeInsideOther() && !clippedPoint.isPointAfterInsideOther()) {
                shouldSwitch = true;
            }
        }
        return shouldSwitch;
    }

    private static ConcavePolygon2DClippingTools.LinkedPoint findVertexOutsideOfPolygon(ConcavePolygon2DReadOnly polygon, Collection<ConcavePolygon2DClippingTools.LinkedPoint> points) {
        for (ConcavePolygon2DClippingTools.LinkedPoint point : points) {
            if (polygon.isPointInsideEpsilon(point.getPoint(), 1.0E-5)) continue;
            return point;
        }
        return null;
    }

    @FunctionalInterface
    private static interface SwitchingFunction {
        public boolean apply(ConcavePolygon2DClippingTools.LinkedPoint var1, boolean var2);
    }
}

