/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.geometry.algorithms;

import us.ihmc.euclid.referenceFrame.FrameConvexPolygon2D;
import us.ihmc.euclid.referenceFrame.FrameLine2D;
import us.ihmc.euclid.referenceFrame.FramePoint2D;
import us.ihmc.euclid.referenceFrame.interfaces.FrameConvexPolygon2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameLine2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint2DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.ReferenceFrameHolder;

public class FrameConvexPolygonWithLineIntersector2d {
    private final FramePoint2D intersectionPointOne = new FramePoint2D();
    private final FramePoint2D intersectionPointTwo = new FramePoint2D();
    private IntersectionResult intersectionResult = IntersectionResult.NO_INTERSECTION;

    public void intersectWithLine(FrameConvexPolygon2DReadOnly frameConvexPolygon2d, FrameLine2DReadOnly frameLine2d) {
        this.checkAndSetFrames((ReferenceFrameHolder)frameConvexPolygon2d, (ReferenceFrameHolder)frameLine2d);
        int intersectionTypeInt = frameConvexPolygon2d.intersectionWith(frameLine2d, (FramePoint2DBasics)this.intersectionPointOne, (FramePoint2DBasics)this.intersectionPointTwo);
        this.packIntersectionType(intersectionTypeInt);
    }

    public void intersectWithRay(FrameConvexPolygon2D frameConvexPolygon2d, FrameLine2D frameRay2d) {
        this.checkAndSetFrames((ReferenceFrameHolder)frameConvexPolygon2d, (ReferenceFrameHolder)frameRay2d);
        int intersectionTypeInt = frameConvexPolygon2d.intersectionWithRay((FrameLine2DReadOnly)frameRay2d, (FramePoint2DBasics)this.intersectionPointOne, (FramePoint2DBasics)this.intersectionPointTwo);
        this.packIntersectionType(intersectionTypeInt);
    }

    private void packIntersectionType(int intersectionTypeInt) {
        switch (intersectionTypeInt) {
            case 0: {
                this.intersectionResult = IntersectionResult.NO_INTERSECTION;
                break;
            }
            case 1: {
                this.intersectionResult = IntersectionResult.POINT_INTERSECTION;
                break;
            }
            case 2: {
                this.intersectionResult = IntersectionResult.LINE_SEGMENT_INTERSECTION;
            }
        }
    }

    private void checkAndSetFrames(ReferenceFrameHolder frameObject1, ReferenceFrameHolder frameObject2) {
        frameObject1.checkReferenceFrameMatch(frameObject2);
        this.intersectionPointOne.setToZero(frameObject1.getReferenceFrame());
        this.intersectionPointTwo.setToZero(frameObject1.getReferenceFrame());
    }

    public FramePoint2D getIntersectionPointOne() {
        return this.intersectionPointOne;
    }

    public FramePoint2D getIntersectionPointTwo() {
        return this.intersectionPointTwo;
    }

    public IntersectionResult getIntersectionResult() {
        return this.intersectionResult;
    }

    public static enum IntersectionResult {
        LINE_SEGMENT_INTERSECTION,
        POINT_INTERSECTION,
        NO_INTERSECTION;

    }
}

