/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.geometry.algorithms;

import org.apache.commons.math3.util.Pair;
import us.ihmc.euclid.geometry.ConvexPolygon2D;
import us.ihmc.euclid.geometry.tools.EuclidGeometryTools;
import us.ihmc.euclid.referenceFrame.FrameConvexPolygon2D;
import us.ihmc.euclid.referenceFrame.FrameLine2D;
import us.ihmc.euclid.referenceFrame.FrameLine3D;
import us.ihmc.euclid.referenceFrame.FrameLineSegment3D;
import us.ihmc.euclid.referenceFrame.FramePoint2D;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameLine2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint2DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.robotics.geometry.shapes.FramePlane3d;

public class FrameConvexPolygon2dIntersector {
    private final FramePlane3d planeOne = new FramePlane3d();
    private final FramePlane3d planeTwo = new FramePlane3d();
    private final FrameLine3D intersectionOfPlanes = new FrameLine3D();
    private final FrameLine2D planeIntersectionOnPolygonPlane = new FrameLine2D();
    private final Pair<FramePoint2D, FramePoint2D> lineIntersectionOnPolygonPlane = new Pair((Object)new FramePoint2D(), (Object)new FramePoint2D());
    private final Pair<FramePoint3D, FramePoint3D> intersectionWithPolygonOne = new Pair((Object)new FramePoint3D(), (Object)new FramePoint3D());
    private final Pair<FramePoint3D, FramePoint3D> intersectionWithPolygonTwo = new Pair((Object)new FramePoint3D(), (Object)new FramePoint3D());
    private final Vector3D point2Vector = new Vector3D();
    private final Vector3D point3Vector = new Vector3D();
    private final Vector3D point4Vector = new Vector3D();
    private boolean noIntersection = false;
    private static final ThreadLocal<Point3D> pointOnIntersectionThreadLocal = new ThreadLocal<Point3D>(){

        @Override
        public Point3D initialValue() {
            return new Point3D();
        }
    };
    private static final ThreadLocal<Vector3D> intersectionDirectionThreadLocal = new ThreadLocal<Vector3D>(){

        @Override
        public Vector3D initialValue() {
            return new Vector3D();
        }
    };

    public void intersect3d(FrameConvexPolygon2D polygonOne, FrameConvexPolygon2D polygonTwo, FrameLineSegment3D intersectionToPack) {
        this.noIntersection = false;
        this.planeOne.setIncludingFrame(polygonOne.getReferenceFrame(), 0.0, 0.0, 0.0, 0.0, 0.0, 1.0);
        this.planeTwo.setIncludingFrame(polygonTwo.getReferenceFrame(), 0.0, 0.0, 0.0, 0.0, 0.0, 1.0);
        this.planeTwo.changeFrame(this.planeOne.getReferenceFrame());
        FrameConvexPolygon2dIntersector.intersectTwoPlanes(this.planeOne, this.planeTwo, this.intersectionOfPlanes);
        if (this.intersectionOfPlanes.containsNaN()) {
            intersectionToPack.setToNaN();
            return;
        }
        this.intersectASinglePolygon(polygonOne, this.intersectionWithPolygonOne);
        if (this.noIntersection) {
            intersectionToPack.setToNaN();
            return;
        }
        this.intersectASinglePolygon(polygonTwo, this.intersectionWithPolygonTwo);
        if (this.noIntersection) {
            intersectionToPack.setToNaN();
            return;
        }
        ((FramePoint3D)this.intersectionWithPolygonOne.getFirst()).changeFrame(ReferenceFrame.getWorldFrame());
        ((FramePoint3D)this.intersectionWithPolygonOne.getSecond()).changeFrame(ReferenceFrame.getWorldFrame());
        ((FramePoint3D)this.intersectionWithPolygonTwo.getFirst()).changeFrame(ReferenceFrame.getWorldFrame());
        ((FramePoint3D)this.intersectionWithPolygonTwo.getSecond()).changeFrame(ReferenceFrame.getWorldFrame());
        this.findIntersectionAmongPoints((FramePoint3D)this.intersectionWithPolygonOne.getFirst(), (FramePoint3D)this.intersectionWithPolygonOne.getSecond(), (FramePoint3D)this.intersectionWithPolygonTwo.getFirst(), (FramePoint3D)this.intersectionWithPolygonTwo.getSecond(), intersectionToPack);
        if (this.noIntersection) {
            intersectionToPack.setToNaN();
            return;
        }
    }

    private void findIntersectionAmongPoints(FramePoint3D point1, FramePoint3D point2, FramePoint3D point3, FramePoint3D point4, FrameLineSegment3D intersectionToPack) {
        if (this.allAreValid(point1, point2, point3, point4)) {
            this.point2Vector.sub((Tuple3DReadOnly)point2, (Tuple3DReadOnly)point1);
            this.point3Vector.sub((Tuple3DReadOnly)point3, (Tuple3DReadOnly)point1);
            this.point4Vector.sub((Tuple3DReadOnly)point4, (Tuple3DReadOnly)point1);
            double oneToTwoSqaured = this.point2Vector.lengthSquared();
            double point1Percentage = 0.0;
            double point2Percentage = 1.0;
            double point3Percentage = this.point2Vector.dot((Vector3DReadOnly)this.point3Vector) / oneToTwoSqaured;
            double point4Percentage = this.point2Vector.dot((Vector3DReadOnly)this.point4Vector) / oneToTwoSqaured;
            intersectionToPack.setToNaN();
            if (point3Percentage > point1Percentage && point4Percentage > point1Percentage) {
                intersectionToPack.getFirstEndpoint().set((FrameTuple3DReadOnly)(point3Percentage < point4Percentage ? point3 : point4));
            } else if (point3Percentage >= point1Percentage || point4Percentage >= point1Percentage) {
                intersectionToPack.getFirstEndpoint().set((FrameTuple3DReadOnly)point1);
            }
            if (point3Percentage < point2Percentage && point4Percentage < point2Percentage) {
                intersectionToPack.getSecondEndpoint().set((FrameTuple3DReadOnly)(point3Percentage > point4Percentage ? point3 : point4));
            } else if (point3Percentage <= point2Percentage || point4Percentage <= point2Percentage) {
                intersectionToPack.getSecondEndpoint().set((FrameTuple3DReadOnly)point2);
            }
            if (intersectionToPack.getFirstEndpoint().containsNaN() && !intersectionToPack.getSecondEndpoint().containsNaN()) {
                intersectionToPack.getFirstEndpoint().set((FrameTuple3DReadOnly)intersectionToPack.getSecondEndpoint());
            } else if (!intersectionToPack.getFirstEndpoint().containsNaN() && intersectionToPack.getSecondEndpoint().containsNaN()) {
                intersectionToPack.getSecondEndpoint().set((FrameTuple3DReadOnly)intersectionToPack.getFirstEndpoint());
            }
            if (!intersectionToPack.containsNaN()) {
                return;
            }
        } else if (this.allAreValid(point1, point2, point3)) {
            intersectionToPack.set((FramePoint3DReadOnly)point1, (FramePoint3DReadOnly)point2);
            if (intersectionToPack.isBetweenEndpoints((FramePoint3DReadOnly)point3, 1.0E-7)) {
                intersectionToPack.getFirstEndpoint().set((FrameTuple3DReadOnly)point3);
                intersectionToPack.getSecondEndpoint().set((FrameTuple3DReadOnly)point3);
                return;
            }
        } else if (this.allAreValid(point1, point3, point4)) {
            intersectionToPack.set((FramePoint3DReadOnly)point3, (FramePoint3DReadOnly)point3);
            if (intersectionToPack.isBetweenEndpoints((FramePoint3DReadOnly)point1, 1.0E-7)) {
                intersectionToPack.getFirstEndpoint().set((FrameTuple3DReadOnly)point1);
                intersectionToPack.getSecondEndpoint().set((FrameTuple3DReadOnly)point1);
                return;
            }
        } else if (this.allAreValid(point1, point3) && point1.epsilonEquals(point3, 1.0E-7)) {
            intersectionToPack.getFirstEndpoint().set((FrameTuple3DReadOnly)point1);
            intersectionToPack.getSecondEndpoint().set((FrameTuple3DReadOnly)point3);
            return;
        }
        this.noIntersection = true;
    }

    private boolean allAreValid(FramePoint3D point1, FramePoint3D point2) {
        return this.isValid(point1) && this.isValid(point2);
    }

    private boolean allAreValid(FramePoint3D point1, FramePoint3D point2, FramePoint3D point3) {
        return this.isValid(point1) && this.isValid(point2) && this.isValid(point3);
    }

    private boolean allAreValid(FramePoint3D point1, FramePoint3D point2, FramePoint3D point3, FramePoint3D point4) {
        return this.isValid(point1) && this.isValid(point2) && this.isValid(point3) && this.isValid(point4);
    }

    private boolean isValid(FramePoint3D point) {
        return !point.containsNaN();
    }

    private void intersectASinglePolygon(FrameConvexPolygon2D polygon, Pair<FramePoint3D, FramePoint3D> intersectionWithPolygon) {
        this.intersectionOfPlanes.changeFrame(polygon.getReferenceFrame());
        this.intersectionOfPlanes.set((FrameLine2DReadOnly)this.planeIntersectionOnPolygonPlane);
        polygon.intersectionWith((FrameLine2DReadOnly)this.planeIntersectionOnPolygonPlane, (FramePoint2DBasics)this.lineIntersectionOnPolygonPlane.getFirst(), (FramePoint2DBasics)this.lineIntersectionOnPolygonPlane.getSecond());
        if (((FramePoint2D)this.lineIntersectionOnPolygonPlane.getFirst()).containsNaN() && ((FramePoint2D)this.lineIntersectionOnPolygonPlane.getSecond()).containsNaN()) {
            this.noIntersection = true;
        }
        if (!((FramePoint2D)this.lineIntersectionOnPolygonPlane.getFirst()).containsNaN()) {
            ((FramePoint3D)intersectionWithPolygon.getFirst()).setIncludingFrame((FrameTuple2DReadOnly)this.lineIntersectionOnPolygonPlane.getFirst(), 0.0);
        }
        if (!((FramePoint2D)this.lineIntersectionOnPolygonPlane.getSecond()).containsNaN()) {
            ((FramePoint3D)intersectionWithPolygon.getSecond()).setIncludingFrame((FrameTuple2DReadOnly)this.lineIntersectionOnPolygonPlane.getSecond(), 0.0);
        }
    }

    public static void getClosestPoint(Point2D point, ConvexPolygon2D polygon, Point2D closestPointToPack) {
        if (polygon.isPointInside((Point2DReadOnly)point)) {
            closestPointToPack.set(point);
            return;
        }
        double closestDistance = Double.POSITIVE_INFINITY;
        for (int index = 0; index < polygon.getNumberOfVertices(); ++index) {
            double distance;
            boolean insideTwo;
            Point2DReadOnly pointTwo;
            Point2DReadOnly pointOne = polygon.getVertex(index);
            boolean insideOne = EuclidGeometryTools.dotProduct((Point2DReadOnly)pointOne, (Point2DReadOnly)(pointTwo = polygon.getNextVertex(index)), (Point2DReadOnly)pointOne, (Point2DReadOnly)point) > 0.0;
            boolean bl = insideTwo = EuclidGeometryTools.dotProduct((Point2DReadOnly)pointTwo, (Point2DReadOnly)pointOne, (Point2DReadOnly)pointTwo, (Point2DReadOnly)point) > 0.0;
            if (insideOne && insideTwo) {
                double vx0 = point.getX() - pointOne.getX();
                double vy0 = point.getY() - pointOne.getY();
                double vx1 = pointTwo.getX() - pointOne.getX();
                double vy1 = pointTwo.getY() - pointOne.getY();
                double dot = vx0 * vx1 + vy0 * vy1;
                double lengthSquared = vx1 * vx1 + vy1 * vy1;
                double alpha = dot / lengthSquared;
                double x = pointOne.getX() + alpha * vx1;
                double y = pointOne.getY() + alpha * vy1;
                double distance2 = EuclidGeometryTools.distanceBetweenPoint2Ds((double)point.getX(), (double)point.getY(), (double)x, (double)y);
                if (!(distance2 < closestDistance)) continue;
                closestPointToPack.set(x, y);
                closestDistance = distance2;
                continue;
            }
            if (!insideOne) {
                distance = point.distance(pointOne);
                if (!(distance < closestDistance)) continue;
                closestPointToPack.set((Tuple2DReadOnly)pointOne);
                closestDistance = distance;
                continue;
            }
            distance = point.distance(pointTwo);
            if (!(distance < closestDistance)) continue;
            closestPointToPack.set((Tuple2DReadOnly)pointTwo);
            closestDistance = distance;
        }
    }

    public static void intersectTwoPlanes(FramePlane3d planeOne, FramePlane3d planeTwo, FrameLine3D intersectionToPack) {
        ReferenceFrame previousPlaneTwoReferenceFrame = planeTwo.getReferenceFrame();
        planeTwo.changeFrame(planeOne.getReferenceFrame());
        Point3D pointOnIntersection = pointOnIntersectionThreadLocal.get();
        Vector3DBasics intersectionDirection = (Vector3DBasics)intersectionDirectionThreadLocal.get();
        boolean success = EuclidGeometryTools.intersectionBetweenTwoPlane3Ds((Point3DReadOnly)planeOne.getPoint(), (Vector3DReadOnly)planeOne.getNormal(), (Point3DReadOnly)planeTwo.getPoint(), (Vector3DReadOnly)planeTwo.getNormal(), (Point3DBasics)pointOnIntersection, (Vector3DBasics)intersectionDirection);
        if (success) {
            intersectionToPack.setToZero(planeOne.getReferenceFrame());
            intersectionToPack.getPoint().set((Tuple3DReadOnly)pointOnIntersection);
            intersectionToPack.getDirection().set((Tuple3DReadOnly)intersectionDirection);
        } else {
            intersectionToPack.setToNaN();
        }
        planeTwo.changeFrame(previousPlaneTwoReferenceFrame);
    }
}

