/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.geometry;

import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.graphicsDescription.Graphics3DObject;
import us.ihmc.graphicsDescription.appearance.AppearanceDefinition;
import us.ihmc.graphicsDescription.appearance.YoAppearance;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphic;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicShape;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsListRegistry;
import us.ihmc.robotics.geometry.GroundPlaneEstimator;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePoint3D;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameVector3D;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameYawPitchRoll;
import us.ihmc.yoVariables.registry.YoRegistry;

public class YoGroundPlaneEstimator
extends GroundPlaneEstimator {
    private final YoFramePoint3D yoGroundPlanePoint;
    private final YoFrameVector3D yoGroundPlaneNormal;
    private final YoFrameYawPitchRoll yoGroundPlaneOrientation;

    public YoGroundPlaneEstimator(YoRegistry parentRegistry, YoGraphicsListRegistry graphicsListRegistry) {
        this("", parentRegistry, graphicsListRegistry, YoAppearance.Glass());
    }

    public YoGroundPlaneEstimator(String prefix, YoRegistry parentRegistry, YoGraphicsListRegistry graphicsListRegistry, AppearanceDefinition groundPlaneAppearance) {
        YoRegistry registry = new YoRegistry(prefix + this.getClass().getSimpleName());
        this.yoGroundPlanePoint = new YoFramePoint3D(prefix + "GroundPlanePoint", ReferenceFrame.getWorldFrame(), registry);
        this.yoGroundPlaneNormal = new YoFrameVector3D(prefix + "GroundPlaneNormal", ReferenceFrame.getWorldFrame(), registry);
        this.yoGroundPlaneOrientation = new YoFrameYawPitchRoll(prefix + "GroundPlaneOrientation", ReferenceFrame.getWorldFrame(), registry);
        if (parentRegistry != null) {
            parentRegistry.addChild(registry);
        }
        if (graphicsListRegistry != null) {
            Graphics3DObject groundPlaneGraphic = new Graphics3DObject();
            groundPlaneGraphic.addCylinder(0.005, 0.5, groundPlaneAppearance);
            YoGraphicShape yoGroundPlaneGraphic = new YoGraphicShape(prefix + "GroundPlaneEstimate", groundPlaneGraphic, this.yoGroundPlanePoint, this.yoGroundPlaneOrientation, 1.0);
            graphicsListRegistry.registerYoGraphic(prefix + "GroundPlaneEstimate", (YoGraphic)yoGroundPlaneGraphic);
        }
    }

    @Override
    public void compute() {
        super.compute();
        this.yoGroundPlaneNormal.set((FrameTuple3DReadOnly)this.groundPlaneFrameNormal);
        this.yoGroundPlanePoint.set((FrameTuple3DReadOnly)this.groundPlaneFramePoint);
        this.yoGroundPlaneOrientation.setYawPitchRoll(0.0, this.getPitch(), this.getRoll());
    }
}

