/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.geometry;

import java.util.ArrayList;
import us.ihmc.euclid.Axis3D;
import us.ihmc.euclid.geometry.ConvexPolygon2D;
import us.ihmc.euclid.geometry.interfaces.Vertex2DSupplier;
import us.ihmc.euclid.geometry.tools.EuclidGeometryTools;
import us.ihmc.euclid.matrix.RotationMatrix;
import us.ihmc.euclid.matrix.interfaces.RotationMatrixReadOnly;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.euclid.tuple4D.Quaternion;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;
import us.ihmc.robotics.geometry.PlanarRegion;
import us.ihmc.robotics.geometry.PlanarRegionsList;
import us.ihmc.robotics.geometry.RigidBodyTransformGenerator;

public class PlanarRegionsListGenerator {
    private PlanarRegionsList planarRegionsList = new PlanarRegionsList(new ArrayList<PlanarRegion>());
    private final RigidBodyTransformGenerator transformGenerator = new RigidBodyTransformGenerator();
    private int id = 0;

    public void setId(int id) {
        this.id = id;
    }

    public void addCubeReferencedAtCenter(double lengthX, double widthY, double heightZ) {
        RigidBodyTransformGenerator transformGeneratorTwo = new RigidBodyTransformGenerator(this.transformGenerator);
        transformGeneratorTwo.set(this.transformGenerator);
        transformGeneratorTwo.translate(0.0, 0.0, heightZ / 2.0);
        this.addRectangle(transformGeneratorTwo, lengthX, widthY);
        transformGeneratorTwo.translate(0.0, 0.0, -heightZ);
        transformGeneratorTwo.rotate(Math.PI, Axis3D.Y);
        this.addRectangle(transformGeneratorTwo, lengthX, widthY);
        transformGeneratorTwo.rotate(Math.PI, Axis3D.Y);
        transformGeneratorTwo.set(this.transformGenerator);
        transformGeneratorTwo.rotate(1.5707963267948966, Axis3D.Y);
        transformGeneratorTwo.translate(0.0, 0.0, lengthX / 2.0);
        this.addRectangle(transformGeneratorTwo, heightZ, widthY);
        transformGeneratorTwo.translate(0.0, 0.0, -lengthX);
        transformGeneratorTwo.rotate(Math.PI, Axis3D.Y);
        this.addRectangle(transformGeneratorTwo, heightZ, widthY);
        transformGeneratorTwo.rotate(Math.PI, Axis3D.Y);
        transformGeneratorTwo.set(this.transformGenerator);
        transformGeneratorTwo.rotate(1.5707963267948966, Axis3D.X);
        transformGeneratorTwo.translate(0.0, 0.0, widthY / 2.0);
        this.addRectangle(transformGeneratorTwo, lengthX, heightZ);
        transformGeneratorTwo.translate(0.0, 0.0, -widthY);
        transformGeneratorTwo.rotate(Math.PI, Axis3D.X);
        this.addRectangle(transformGeneratorTwo, lengthX, heightZ);
        transformGeneratorTwo.rotate(Math.PI, Axis3D.X);
    }

    public void addCubeReferencedAtBottomMiddle(double lengthX, double widthY, double heightZ) {
        this.translate(0.0, 0.0, heightZ / 2.0);
        this.addCubeReferencedAtCenter(lengthX, widthY, heightZ);
        this.translate(0.0, 0.0, -heightZ / 2.0);
    }

    public void addCubeReferencedAtBottomNegativeXEdgeCenter(double lengthX, double widthY, double heightZ) {
        this.translate(-lengthX / 2.0, 0.0, heightZ / 2.0);
        this.addCubeReferencedAtCenter(lengthX, widthY, heightZ);
        this.translate(lengthX / 2.0, 0.0, -heightZ / 2.0);
    }

    public void addCubeReferencedAtBottomNegativeXYCorner(double lengthX, double widthY, double heightZ) {
        double halfLengthX = lengthX / 2.0;
        double halfWidthY = widthY / 2.0;
        this.translate(halfLengthX, halfWidthY, 0.0);
        this.addCubeReferencedAtBottomMiddle(lengthX, widthY, heightZ);
        this.translate(-halfLengthX, -halfWidthY, 0.0);
    }

    public void addRampReferencedAtBottomMiddle(double lengthX, double widthY, double heightZ) {
        RigidBodyTransformGenerator transformGeneratorTwo = new RigidBodyTransformGenerator(this.transformGenerator);
        double slope = Math.atan2(heightZ, lengthX);
        transformGeneratorTwo.set(this.transformGenerator);
        transformGeneratorTwo.translate(lengthX / 2.0, 0.0, heightZ / 2.0);
        transformGeneratorTwo.rotate(-slope, Axis3D.Y);
        this.addRectangle(transformGeneratorTwo, EuclidGeometryTools.pythagorasGetHypotenuse((double)lengthX, (double)heightZ), widthY);
        ConvexPolygon2D leftSide = new ConvexPolygon2D();
        leftSide.addVertex(0.0, 0.0);
        leftSide.addVertex(-lengthX, 0.0);
        leftSide.addVertex(-lengthX, heightZ);
        leftSide.update();
        ConvexPolygon2D rightSide = new ConvexPolygon2D();
        rightSide.addVertex(0.0, 0.0);
        rightSide.addVertex(lengthX, 0.0);
        rightSide.addVertex(lengthX, heightZ);
        rightSide.update();
        transformGeneratorTwo.set(this.transformGenerator);
        transformGeneratorTwo.translate(0.0, 0.5 * widthY, 0.0);
        transformGeneratorTwo.rotate(1.5707963267948966, Axis3D.X);
        transformGeneratorTwo.rotate(Math.PI, Axis3D.Y);
        this.addPolygon(transformGeneratorTwo, leftSide);
        transformGeneratorTwo.set(this.transformGenerator);
        transformGeneratorTwo.translate(0.0, -0.5 * widthY, 0.0);
        transformGeneratorTwo.rotate(1.5707963267948966, Axis3D.X);
        this.addPolygon(transformGeneratorTwo, rightSide);
    }

    public void addRectangleReferencedAtNegativeXYCorner(double lengthX, double widthY) {
        this.translate(lengthX / 2.0, widthY / 2.0, 0.0);
        this.addRectangle(lengthX, widthY);
        this.translate(-lengthX / 2.0, -widthY / 2.0, 0.0);
    }

    public void addRectangle(double lengthX, double widthY) {
        ConvexPolygon2D rectangle = PlanarRegionsListGenerator.createRectanglePolygon(lengthX, widthY);
        this.addPolygon(rectangle);
    }

    public void addPolygon(ConvexPolygon2D polygon) {
        PlanarRegion planarRegion = new PlanarRegion((RigidBodyTransformReadOnly)this.transformGenerator.getRigidBodyTransformCopy(), (Vertex2DSupplier)polygon);
        planarRegion.setRegionId(this.id++);
        this.planarRegionsList.addPlanarRegion(planarRegion);
    }

    public void addPolygon(RigidBodyTransformGenerator transformGenerator, ConvexPolygon2D polygon) {
        PlanarRegion planarRegion = new PlanarRegion((RigidBodyTransformReadOnly)transformGenerator.getRigidBodyTransformCopy(), (Vertex2DSupplier)polygon);
        planarRegion.setRegionId(this.id++);
        this.planarRegionsList.addPlanarRegion(planarRegion);
    }

    public void addPolygons(ArrayList<ConvexPolygon2D> polygons) {
        PlanarRegion planarRegion = new PlanarRegion(this.transformGenerator.getRigidBodyTransformCopy(), polygons);
        planarRegion.setRegionId(this.id++);
        this.planarRegionsList.addPlanarRegion(planarRegion);
    }

    private void addRectangle(RigidBodyTransformGenerator transformGenerator, double lengthX, double widthY) {
        ConvexPolygon2D rectangle = PlanarRegionsListGenerator.createRectanglePolygon(lengthX, widthY);
        PlanarRegion planarRegion = new PlanarRegion((RigidBodyTransformReadOnly)transformGenerator.getRigidBodyTransformCopy(), (Vertex2DSupplier)rectangle);
        planarRegion.setRegionId(this.id++);
        this.planarRegionsList.addPlanarRegion(planarRegion);
    }

    private static ConvexPolygon2D createRectanglePolygon(double lengthX, double widthY) {
        ConvexPolygon2D convexPolygon = new ConvexPolygon2D();
        convexPolygon.addVertex(lengthX / 2.0, widthY / 2.0);
        convexPolygon.addVertex(-lengthX / 2.0, widthY / 2.0);
        convexPolygon.addVertex(-lengthX / 2.0, -widthY / 2.0);
        convexPolygon.addVertex(lengthX / 2.0, -widthY / 2.0);
        convexPolygon.update();
        return convexPolygon;
    }

    public void translate(double x, double y, double z) {
        this.transformGenerator.translate(x, y, z);
    }

    public void translate(Tuple3DReadOnly translationVector) {
        this.transformGenerator.translate(translationVector);
    }

    public void identity() {
        this.transformGenerator.identity();
    }

    public void rotateEuler(Vector3D eulerAngles) {
        this.transformGenerator.rotateEuler((Vector3DReadOnly)eulerAngles);
    }

    public void rotate(RotationMatrix rotation) {
        this.transformGenerator.rotate((RotationMatrixReadOnly)rotation);
    }

    public void rotate(Quaternion rotation) {
        this.transformGenerator.rotate((QuaternionReadOnly)rotation);
    }

    public void rotate(double rotationAngle, Axis3D axis) {
        this.transformGenerator.rotate(rotationAngle, axis);
    }

    public void setTransform(RigidBodyTransform transform) {
        this.transformGenerator.setTransform(transform);
    }

    public void translateThenRotate(RigidBodyTransform transform) {
        this.transformGenerator.translateThenRotate(transform);
    }

    public PlanarRegionsList getPlanarRegionsList() {
        return this.planarRegionsList;
    }

    public void reset() {
        this.planarRegionsList.clear();
        this.transformGenerator.identity();
    }
}

