/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.geometry;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import us.ihmc.euclid.geometry.BoundingBox3D;
import us.ihmc.euclid.geometry.ConvexPolygon2D;
import us.ihmc.euclid.geometry.interfaces.LineSegment2DReadOnly;
import us.ihmc.euclid.geometry.interfaces.Vertex2DSupplier;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.robotics.geometry.PlanarRegion;

public class PlanarRegionsList {
    private final List<PlanarRegion> regions;

    public PlanarRegionsList() {
        this.regions = new ArrayList<PlanarRegion>();
    }

    public PlanarRegionsList(PlanarRegion ... planarRegions) {
        this.regions = new ArrayList<PlanarRegion>();
        for (PlanarRegion planarRegion : planarRegions) {
            this.regions.add(planarRegion);
        }
    }

    public PlanarRegionsList(List<PlanarRegion> planarRegions) {
        this.regions = planarRegions;
    }

    public PlanarRegionsList(PlanarRegionsList other) {
        this(other.getPlanarRegionsAsList());
    }

    public void addPlanarRegion(PlanarRegion region) {
        this.regions.add(region);
    }

    public void addPlanarRegions(List<PlanarRegion> regions) {
        this.regions.addAll(regions);
    }

    public void addPlanarRegionsList(PlanarRegionsList planarRegionsList) {
        this.regions.addAll(planarRegionsList.getPlanarRegionsAsList());
    }

    public void clear() {
        this.regions.clear();
    }

    public void findPlanarRegionsIntersectingLineSegment(LineSegment2DReadOnly lineSegmentInWorld, List<PlanarRegion> intersectingRegionsToPack) {
        for (int i = 0; i < this.regions.size(); ++i) {
            PlanarRegion candidateRegion = this.regions.get(i);
            if (this.isLineSegmentObviouslyOutsideBoundingBox(candidateRegion, lineSegmentInWorld) || candidateRegion.isVertical() || !candidateRegion.isLineSegmentIntersecting(lineSegmentInWorld)) continue;
            intersectingRegionsToPack.add(candidateRegion);
        }
    }

    public void findPlanarRegionsWithinEpsilonOfPoint(Point3DReadOnly pointInWorld, double epsilon, List<PlanarRegion> intersectingRegionsToPack) {
        for (int i = 0; i < this.regions.size(); ++i) {
            PlanarRegion candidateRegion = this.regions.get(i);
            if (this.isPointXYObviouslyOutsideBoundingBox(candidateRegion, pointInWorld, epsilon) || candidateRegion.isVertical() || !candidateRegion.isPointInWorld2DInside(pointInWorld, epsilon)) continue;
            intersectingRegionsToPack.add(candidateRegion);
        }
    }

    private boolean isLineSegmentObviouslyOutsideBoundingBox(PlanarRegion candidateRegion, LineSegment2DReadOnly lineSegmentInWorld) {
        BoundingBox3D boundingBox = candidateRegion.getBoundingBox3dInWorld();
        double xMin = boundingBox.getMinX();
        double yMin = boundingBox.getMinY();
        double xMax = boundingBox.getMaxX();
        double yMax = boundingBox.getMaxY();
        Point2DReadOnly firstEndpoint = lineSegmentInWorld.getFirstEndpoint();
        Point2DReadOnly secondEndpoint = lineSegmentInWorld.getSecondEndpoint();
        if (firstEndpoint.getX() < xMin && secondEndpoint.getX() < xMin) {
            return true;
        }
        if (firstEndpoint.getX() > xMax && secondEndpoint.getX() > xMax) {
            return true;
        }
        if (firstEndpoint.getY() < yMin && secondEndpoint.getY() < yMin) {
            return true;
        }
        return firstEndpoint.getY() > yMax && secondEndpoint.getY() > yMax;
    }

    private boolean isPointXYObviouslyOutsideBoundingBox(PlanarRegion candidateRegion, Point3DReadOnly pointInWorld, double epsilon) {
        BoundingBox3D boundingBox = candidateRegion.getBoundingBox3dInWorld();
        double xMin = boundingBox.getMinX();
        double yMin = boundingBox.getMinY();
        double xMax = boundingBox.getMaxX();
        double yMax = boundingBox.getMaxY();
        if (pointInWorld.getX() < xMin - epsilon) {
            return true;
        }
        if (pointInWorld.getX() > xMax + epsilon) {
            return true;
        }
        if (pointInWorld.getY() < yMin - epsilon) {
            return true;
        }
        return pointInWorld.getY() > yMax + epsilon;
    }

    public List<PlanarRegion> findPlanarRegionsContainingPoint(Point3DReadOnly point, double maximumOrthogonalDistance) {
        ArrayList<PlanarRegion> containers = null;
        for (int i = 0; i < this.regions.size(); ++i) {
            PlanarRegion candidateRegion = this.regions.get(i);
            if (!candidateRegion.isPointInside(point, maximumOrthogonalDistance)) continue;
            if (containers == null) {
                containers = new ArrayList<PlanarRegion>();
            }
            containers.add(candidateRegion);
        }
        return containers;
    }

    public List<PlanarRegion> findPlanarRegionsContainingPointByProjectionOntoXYPlane(Point2DReadOnly point) {
        return this.findPlanarRegionsContainingPointByProjectionOntoXYPlane(point.getX(), point.getY());
    }

    public List<PlanarRegion> findPlanarRegionsContainingPointByProjectionOntoXYPlane(double x, double y) {
        ArrayList<PlanarRegion> containers = null;
        for (int i = 0; i < this.regions.size(); ++i) {
            PlanarRegion candidateRegion = this.regions.get(i);
            if (!candidateRegion.isPointInsideByProjectionOntoXYPlane(x, y)) continue;
            if (containers == null) {
                containers = new ArrayList<PlanarRegion>();
            }
            containers.add(candidateRegion);
        }
        return containers;
    }

    public List<PlanarRegion> findPlanarRegionsContainingPointByVerticalLineIntersection(Point2DReadOnly point) {
        return this.findPlanarRegionsContainingPointByVerticalLineIntersection(point.getX(), point.getY());
    }

    public List<PlanarRegion> findPlanarRegionsContainingPointByVerticalLineIntersection(double x, double y) {
        ArrayList<PlanarRegion> containers = null;
        for (int i = 0; i < this.regions.size(); ++i) {
            PlanarRegion candidateRegion = this.regions.get(i);
            if (!candidateRegion.isPointInsideByVerticalLineIntersection(x, y)) continue;
            if (containers == null) {
                containers = new ArrayList<PlanarRegion>();
            }
            containers.add(candidateRegion);
        }
        return containers;
    }

    public PlanarRegion findClosestPlanarRegionToPointByProjectionOntoXYPlane(Point2DReadOnly point) {
        return this.findClosestPlanarRegionToPointByProjectionOntoXYPlane(point.getX(), point.getY());
    }

    public PlanarRegion getRegionWithId(int id) {
        for (int i = 0; i < this.regions.size(); ++i) {
            if (this.regions.get(i).getRegionId() != id) continue;
            return this.regions.get(i);
        }
        return null;
    }

    public PlanarRegion findClosestPlanarRegionToPointByProjectionOntoXYPlane(double x, double y) {
        double shortestDistanceToPoint = Double.POSITIVE_INFINITY;
        PlanarRegion closestRegion = null;
        for (int i = 0; i < this.regions.size(); ++i) {
            PlanarRegion candidateRegion = this.regions.get(i);
            double distanceToRegion = candidateRegion.distanceToPointByProjectionOntoXYPlane(x, y);
            if (!(distanceToRegion < shortestDistanceToPoint)) continue;
            shortestDistanceToPoint = distanceToRegion;
            closestRegion = candidateRegion;
        }
        return closestRegion;
    }

    public boolean isEmpty() {
        return this.regions.isEmpty();
    }

    public int getNumberOfPlanarRegions() {
        return this.regions.size();
    }

    public PlanarRegion getPlanarRegion(int index) {
        return this.regions.get(index);
    }

    public List<PlanarRegion> getPlanarRegionsAsList() {
        return this.regions;
    }

    public PlanarRegion getLastPlanarRegion() {
        if (this.isEmpty()) {
            return null;
        }
        return this.getPlanarRegion(this.getNumberOfPlanarRegions() - 1);
    }

    public PlanarRegion pollPlanarRegion(int index) {
        return this.regions.remove(index);
    }

    public PlanarRegion pollLastPlanarRegion() {
        if (this.isEmpty()) {
            return null;
        }
        return this.pollPlanarRegion(this.getNumberOfPlanarRegions() - 1);
    }

    public PlanarRegionsList copy() {
        ArrayList<PlanarRegion> planarRegionsCopy = new ArrayList<PlanarRegion>();
        for (int i = 0; i < this.getNumberOfPlanarRegions(); ++i) {
            planarRegionsCopy.add(this.regions.get(i).copy());
        }
        return new PlanarRegionsList(planarRegionsCopy);
    }

    public void applyTransform(RigidBodyTransformReadOnly rigidBodyTransform) {
        for (int i = 0; i < this.regions.size(); ++i) {
            this.regions.get(i).applyTransform(rigidBodyTransform);
        }
    }

    public static PlanarRegionsList generatePlanarRegionsListFromRandomPolygonsWithRandomTransform(Random random, int numberOfRandomlyGeneratedPolygons, double maxAbsoluteXYForPolygons, int numberOfPossiblePointsForPolygons, int numberOfPossiblePlanarRegions) {
        PlanarRegionsList planarRegionsList = new PlanarRegionsList();
        int numberOfPlanarRegions = random.nextInt(numberOfPossiblePlanarRegions) + 1;
        while (planarRegionsList.getNumberOfPlanarRegions() < numberOfPlanarRegions) {
            planarRegionsList.addPlanarRegion(PlanarRegion.generatePlanarRegionFromRandomPolygonsWithRandomTransform(random, numberOfRandomlyGeneratedPolygons, maxAbsoluteXYForPolygons, numberOfPossiblePointsForPolygons));
        }
        return planarRegionsList;
    }

    public static PlanarRegionsList flatGround(double size) {
        return PlanarRegionsList.flatGround(size, new RigidBodyTransform());
    }

    public static PlanarRegionsList flatGround(double size, RigidBodyTransform transform) {
        ConvexPolygon2D convexPolygon = new ConvexPolygon2D();
        double halfSize = size / 2.0;
        convexPolygon.addVertex(halfSize, halfSize);
        convexPolygon.addVertex(-halfSize, halfSize);
        convexPolygon.addVertex(-halfSize, -halfSize);
        convexPolygon.addVertex(halfSize, -halfSize);
        convexPolygon.update();
        PlanarRegion groundPlane = new PlanarRegion((RigidBodyTransformReadOnly)transform, (Vertex2DSupplier)convexPolygon);
        return new PlanarRegionsList(groundPlane);
    }

    public void checkNoDuplicateIdsExist() {
        HashSet<Integer> ids = new HashSet<Integer>();
        for (int i = 0; i < this.regions.size(); ++i) {
            PlanarRegion region = this.regions.get(i);
            int id = region.getRegionId();
            if (ids.contains(id)) {
                throw new RuntimeException("Duplicate ID " + id + " at index " + i);
            }
            ids.add(id);
        }
    }

    public boolean epsilonEquals(PlanarRegionsList other, double epsilon) {
        if (this.regions.size() != other.regions.size()) {
            return false;
        }
        block0: for (PlanarRegion region : this.regions) {
            if (other.regions.contains(region)) continue;
            for (PlanarRegion regionOther : other.regions) {
                if (!region.getNormal().epsilonEquals((Tuple3DReadOnly)regionOther.getNormal(), epsilon) || !region.getPoint().epsilonEquals((Tuple3DReadOnly)regionOther.getPoint(), epsilon)) continue;
                for (int i = 0; i < region.getNumberOfConvexPolygons(); ++i) {
                    if (region.getConvexPolygon(i).epsilonEquals(regionOther.getConvexPolygon(i), epsilon)) continue block0;
                }
            }
            return false;
        }
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PlanarRegionsList)) {
            return false;
        }
        PlanarRegionsList other = (PlanarRegionsList)o;
        return this.epsilonEquals(other, 1.0E-6);
    }
}

