/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.geometry;

import java.util.ArrayList;
import java.util.List;
import us.ihmc.euclid.geometry.Plane3D;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.FramePose3D;
import us.ihmc.euclid.referenceFrame.FrameQuaternion;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FramePose3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameQuaternionReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.robotics.geometry.LeastSquaresZPlaneFitter;
import us.ihmc.robotics.referenceFrames.PoseReferenceFrame;
import us.ihmc.robotics.robotSide.QuadrantDependentList;
import us.ihmc.robotics.robotSide.RobotQuadrant;

public class GroundPlaneEstimator {
    private static final int MAX_GROUND_PLANE_POINTS = 100;
    private final Plane3D groundPlane = new Plane3D();
    private final Vector3D groundPlaneNormal = new Vector3D();
    private final Point3D groundPlanePoint = new Point3D();
    private final ArrayList<Point3DReadOnly> groundPlanePoints = new ArrayList(100);
    private final LeastSquaresZPlaneFitter planeFitter = new LeastSquaresZPlaneFitter();
    protected final FramePoint3D groundPlaneFramePoint = new FramePoint3D();
    protected final FrameQuaternion groundPlaneOrientation = new FrameQuaternion();
    protected final FrameVector3D groundPlaneFrameNormal = new FrameVector3D();
    private final FramePose3D groundPlanePose = new FramePose3D();
    private final PoseReferenceFrame groundPlaneFrame = new PoseReferenceFrame("groundPlaneFrame", ReferenceFrame.getWorldFrame());

    public double getPitch() {
        this.groundPlaneNormal.set((Tuple3DReadOnly)this.groundPlane.getNormal());
        return Math.atan2(this.groundPlaneNormal.getX(), this.groundPlaneNormal.getZ());
    }

    public double getRoll() {
        this.groundPlaneNormal.set((Tuple3DReadOnly)this.groundPlane.getNormal());
        return Math.atan2(-this.groundPlaneNormal.getY(), this.groundPlaneNormal.getZ());
    }

    public double getPitch(double yaw) {
        this.groundPlaneNormal.set((Tuple3DReadOnly)this.groundPlane.getNormal());
        return Math.atan2(Math.cos(yaw) * this.groundPlaneNormal.getX() + Math.sin(yaw) * this.groundPlaneNormal.getY(), this.groundPlaneNormal.getZ());
    }

    public double getRoll(double yaw) {
        this.groundPlaneNormal.set((Tuple3DReadOnly)this.groundPlane.getNormal());
        return Math.atan2(Math.sin(yaw) * this.groundPlaneNormal.getX() - Math.cos(yaw) * this.groundPlaneNormal.getY(), this.groundPlaneNormal.getZ());
    }

    public void getPlane(Plane3D plane3d) {
        plane3d.set(this.groundPlane);
    }

    public void getPlanePoint(FramePoint3D point) {
        point.changeFrame(ReferenceFrame.getWorldFrame());
        point.set((Tuple3DReadOnly)this.groundPlane.getPoint());
    }

    public void getPlaneNormal(FrameVector3D normal) {
        normal.changeFrame(ReferenceFrame.getWorldFrame());
        normal.set((Tuple3DReadOnly)this.groundPlane.getNormal());
    }

    public void projectZ(FramePoint3D point) {
        point.changeFrame(ReferenceFrame.getWorldFrame());
        point.setZ(this.groundPlane.getZOnPlane(point.getX(), point.getY()));
    }

    public void projectZ(Point3D point) {
        point.setZ(this.groundPlane.getZOnPlane(point.getX(), point.getY()));
    }

    public void projectOrthogonal(FramePoint3D point) {
        point.changeFrame(ReferenceFrame.getWorldFrame());
        this.groundPlane.orthogonalProjection((Point3DBasics)point);
    }

    public void projectOrthogonal(Point3D point) {
        this.groundPlane.orthogonalProjection((Point3DBasics)point);
    }

    public void clearContactPoints() {
        this.groundPlanePoints.clear();
    }

    public void addContactPoint(Point3DReadOnly contactPoint) {
        this.groundPlanePoints.add(contactPoint);
    }

    public void compute() {
        this.planeFitter.fitPlaneToPoints(this.groundPlanePoints, this.groundPlane);
        this.groundPlaneNormal.set((Tuple3DReadOnly)this.groundPlane.getNormal());
        this.groundPlaneFrameNormal.set((Tuple3DReadOnly)this.groundPlaneNormal);
        this.groundPlanePoint.set((Tuple3DReadOnly)this.groundPlane.getPoint());
        this.groundPlaneFramePoint.set((Tuple3DReadOnly)this.groundPlanePoint);
        this.groundPlaneOrientation.setYawPitchRoll(0.0, this.getPitch(), this.getRoll());
        this.groundPlanePose.getPosition().set((FrameTuple3DReadOnly)this.groundPlaneFramePoint);
        this.groundPlanePose.getOrientation().set((FrameQuaternionReadOnly)this.groundPlaneOrientation);
        this.groundPlaneFrame.setPoseAndUpdate((FramePose3DReadOnly)this.groundPlanePose);
    }

    public void compute(List<FramePoint3D> contactPoints) {
        int nPoints = Math.min(contactPoints.size(), 100);
        this.groundPlanePoints.clear();
        for (int i = 0; i < nPoints; ++i) {
            contactPoints.get(i).changeFrame(ReferenceFrame.getWorldFrame());
            this.groundPlanePoints.add((Point3DReadOnly)contactPoints.get(i));
        }
        this.compute();
    }

    public void compute(QuadrantDependentList<FramePoint3D> contactPoints) {
        this.groundPlanePoints.clear();
        for (RobotQuadrant robotQuadrant : RobotQuadrant.values) {
            ((FramePoint3D)contactPoints.get(robotQuadrant)).changeFrame(ReferenceFrame.getWorldFrame());
            this.groundPlanePoints.add((Point3DReadOnly)contactPoints.get(robotQuadrant));
        }
        this.compute();
    }

    public PoseReferenceFrame getGroundPlaneFrame() {
        return this.groundPlaneFrame;
    }
}

