/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.geometry;

import us.ihmc.euclid.geometry.BoundingBox3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;

public class FrameScalableBoundingBox3d {
    private final ReferenceFrame frame;
    private BoundingBox3D box;
    private final Point3D dimensions;
    private final Point3D center;

    public FrameScalableBoundingBox3d(ReferenceFrame frame, Point3D dimensions, Point3D center) {
        this.frame = frame;
        this.dimensions = dimensions;
        this.center = center;
        this.setScale(1.0f);
    }

    public void setScale(float scale) {
        Point3D min = new Point3D((Tuple3DReadOnly)this.dimensions);
        Point3D max = new Point3D((Tuple3DReadOnly)this.dimensions);
        min.scaleAdd((double)(-scale), (Tuple3DReadOnly)this.center);
        max.scaleAdd((double)scale, (Tuple3DReadOnly)this.center);
        this.box = new BoundingBox3D((Point3DReadOnly)min, (Point3DReadOnly)max);
    }

    public boolean contains(double x, double y, double z) {
        return this.contains(new Point3D(x, y, z));
    }

    public boolean contains(Point3D p) {
        Point3D local = new Point3D((Tuple3DReadOnly)p);
        this.frame.getTransformToRoot().inverseTransform((Point3DBasics)local);
        return this.box.isInsideInclusive((Point3DReadOnly)local);
    }

    public boolean intersects(Point3D start, Point3D end) {
        Point3D inFrameStart = new Point3D((Tuple3DReadOnly)start);
        this.frame.getTransformToRoot().inverseTransform((Point3DBasics)inFrameStart);
        Point3D inFrameEnd = new Point3D((Tuple3DReadOnly)end);
        this.frame.getTransformToRoot().inverseTransform((Point3DBasics)inFrameEnd);
        return this.box.doesIntersectWithLineSegment3D((Point3DReadOnly)start, (Point3DReadOnly)end);
    }
}

