/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.geometry;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import us.ihmc.euclid.referenceFrame.FramePoint2D;
import us.ihmc.robotics.geometry.FrameGeometry2dPlotter;

public class FrameGeometryTestFrame
extends JFrame {
    private static final long serialVersionUID = 1211077223435215178L;
    private final FrameGeometry2dPlotter frameGeometry2dPlotter;
    private final GoodButton goodButton;
    private final BadButton badButton;

    public FrameGeometryTestFrame(double xMin, double xMax, double yMin, double yMax) {
        this("FrameGeometryTestFrame", xMin, xMax, yMin, yMax);
    }

    public FrameGeometryTestFrame(String name, double xMin, double xMax, double yMin, double yMax) {
        super(name);
        double scale = 800.0 / Math.max(xMax - xMin, yMax - yMin);
        this.frameGeometry2dPlotter = new FrameGeometry2dPlotter((xMin + xMax) / 2.0, (yMin + yMax) / 2.0, scale);
        this.goodButton = new GoodButton();
        this.badButton = new BadButton();
        JPanel buttonPanel = new JPanel(new FlowLayout());
        buttonPanel.add(this.goodButton);
        buttonPanel.add(this.badButton);
        this.add((Component)buttonPanel, "South");
        this.add((Component)this.frameGeometry2dPlotter, "Center");
        this.setSize(800, 800);
        this.setVisible(true);
    }

    public FrameGeometry2dPlotter getFrameGeometry2dPlotter() {
        return this.frameGeometry2dPlotter;
    }

    public void addTestPoints(ArrayList<FramePoint2D> testPoints) {
        this.frameGeometry2dPlotter.addTestPoints(testPoints);
    }

    public boolean hasGoodButtonBeenPressed() {
        return this.goodButton.hasBeenPressed();
    }

    public boolean hasBadButtonBeenPressed() {
        return this.badButton.hasBeenPressed();
    }

    public void waitForButtonPush() {
        while (!this.hasGoodButtonBeenPressed() && !this.hasBadButtonBeenPressed()) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (this.hasBadButtonBeenPressed()) {
            throw new RuntimeException();
        }
    }

    private class BadButton
    extends JButton
    implements ActionListener {
        private static final long serialVersionUID = 8505700581984408817L;
        private boolean hasBeenPressed;

        public BadButton() {
            super("Bad");
            this.hasBeenPressed = false;
            this.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.hasBeenPressed = true;
        }

        public boolean hasBeenPressed() {
            return this.hasBeenPressed;
        }
    }

    private class GoodButton
    extends JButton
    implements ActionListener {
        private static final long serialVersionUID = 6028873461564012484L;
        private boolean hasBeenPressed;

        public GoodButton() {
            super("Good");
            this.hasBeenPressed = false;
            this.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.hasBeenPressed = true;
        }

        public boolean hasBeenPressed() {
            return this.hasBeenPressed;
        }
    }
}

