/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.geometry;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Polygon;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import javax.swing.JPanel;
import javax.swing.event.MouseInputListener;
import us.ihmc.euclid.geometry.ConvexPolygon2D;
import us.ihmc.euclid.geometry.interfaces.Vertex2DSupplier;
import us.ihmc.euclid.referenceFrame.FrameConvexPolygon2D;
import us.ihmc.euclid.referenceFrame.FrameLine2D;
import us.ihmc.euclid.referenceFrame.FrameLineSegment2D;
import us.ihmc.euclid.referenceFrame.FramePoint2D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFramePoint2DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint2DReadOnly;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.Vector2D;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;

public class FrameGeometry2dPlotter
extends JPanel
implements MouseInputListener {
    private static final long serialVersionUID = 2505175418803166784L;
    private ArrayList<FramePoint2D> testPoints = new ArrayList();
    private FrameConvexPolygon2D polygonToCheckInside = null;
    private LinkedHashMap<Color, FrameLineGroup> frameLineGroups = new LinkedHashMap();
    private LinkedHashMap<Color, FramePointGroup> framePointGroups = new LinkedHashMap();
    private LinkedHashMap<Color, FrameConvexPolygonGroup> frameConvexPolygonGroups = new LinkedHashMap();
    private LinkedHashMap<Color, FrameLineSegmentGroup> frameLineSegmentGroups = new LinkedHashMap();
    private double xCenter;
    private double yCenter;
    private double scale;
    private int pointPixels = 2;
    private double lastMousePressX;
    private double lastMousePressY;
    private int buttonPressed;
    private int dragStartX;
    private int dragStartY;

    public FrameGeometry2dPlotter(double xCenter, double yCenter, double scale) {
        this.scale = scale;
        this.xCenter = xCenter;
        this.yCenter = yCenter;
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public void setDrawPointsLarge() {
        this.pointPixels = 8;
    }

    public void setDrawPointsMedium() {
        this.pointPixels = 4;
    }

    public void setPointPixels(int pointPixels) {
        this.pointPixels = pointPixels;
    }

    public synchronized void addFrameLine2d(FrameLine2D frameLine2d) {
        this.addFrameLine2d(frameLine2d, Color.black);
    }

    public synchronized void addFrameLines2d(ArrayList<FrameLine2D> frameLines2d) {
        this.addFrameLines2d(frameLines2d, Color.black);
    }

    public synchronized void addFrameLine2d(FrameLine2D frameLine2d, Color color) {
        FrameLineGroup frameLineGroup = this.frameLineGroups.get(color);
        if (frameLineGroup == null) {
            frameLineGroup = new FrameLineGroup(color);
            this.frameLineGroups.put(color, frameLineGroup);
        }
        frameLineGroup.addFrameLine(frameLine2d);
    }

    public synchronized void addFramePoints2d(ArrayList<FramePoint2D> framePoints, Color color) {
        FramePointGroup framePointGroup = this.framePointGroups.get(color);
        if (framePointGroup == null) {
            framePointGroup = new FramePointGroup(color);
            this.framePointGroups.put(color, framePointGroup);
        }
        framePointGroup.addFramePoints(framePoints);
    }

    public synchronized void addFramePoint2d(FramePoint2DReadOnly framePoint, Color color) {
        FramePointGroup framePointGroup = this.framePointGroups.get(color);
        if (framePointGroup == null) {
            framePointGroup = new FramePointGroup(color);
            this.framePointGroups.put(color, framePointGroup);
        }
        framePointGroup.addFramePoint(framePoint);
    }

    public synchronized void addFrameLines2d(ArrayList<FrameLine2D> frameLines2d, Color color) {
        FrameLineGroup frameLineGroup = this.frameLineGroups.get(color);
        if (frameLineGroup == null) {
            frameLineGroup = new FrameLineGroup(color);
            this.frameLineGroups.put(color, frameLineGroup);
        }
        frameLineGroup.addFrameLines(frameLines2d);
    }

    public synchronized void addFrameLines2d(FrameLine2D[] frameLines2d, Color color) {
        FrameLineGroup frameLineGroup = this.frameLineGroups.get(color);
        if (frameLineGroup == null) {
            frameLineGroup = new FrameLineGroup(color);
            this.frameLineGroups.put(color, frameLineGroup);
        }
        frameLineGroup.addFrameLines(frameLines2d);
    }

    public synchronized void addFrameLineSegment2d(FrameLineSegment2D frameLinesSegment2d, Color color) {
        FrameLineSegmentGroup frameLineSegmentGroup = this.frameLineSegmentGroups.get(color);
        if (frameLineSegmentGroup == null) {
            frameLineSegmentGroup = new FrameLineSegmentGroup(color);
            this.frameLineSegmentGroups.put(color, frameLineSegmentGroup);
        }
        frameLineSegmentGroup.addFrameLineSegment(frameLinesSegment2d);
    }

    public synchronized void addFrameLineSegments2d(ArrayList<FrameLineSegment2D> frameLinesSegments2d, Color color) {
        FrameLineSegmentGroup frameLineSegmentGroup = this.frameLineSegmentGroups.get(color);
        if (frameLineSegmentGroup == null) {
            frameLineSegmentGroup = new FrameLineSegmentGroup(color);
            this.frameLineSegmentGroups.put(color, frameLineSegmentGroup);
        }
        frameLineSegmentGroup.addFrameLineSegments(frameLinesSegments2d);
    }

    public synchronized void addPolygon(FrameConvexPolygon2D polygon) {
        this.addPolygon(polygon, Color.BLACK);
    }

    public synchronized void addPolygon(FrameConvexPolygon2D polygon, Color color) {
        FrameConvexPolygonGroup frameConvexPolygonGroup = this.frameConvexPolygonGroups.get(color);
        if (frameConvexPolygonGroup == null) {
            frameConvexPolygonGroup = new FrameConvexPolygonGroup(color);
            this.frameConvexPolygonGroups.put(color, frameConvexPolygonGroup);
        }
        frameConvexPolygonGroup.addFrameConvexPolygon2d(polygon);
    }

    public synchronized void addFrameConvexPolygons(ArrayList<FrameConvexPolygon2D> frameConvexPolygons, Color color) {
        FrameConvexPolygonGroup frameConvexPolygonGroup = this.frameConvexPolygonGroups.get(color);
        if (frameConvexPolygonGroup == null) {
            frameConvexPolygonGroup = new FrameConvexPolygonGroup(color);
            this.frameConvexPolygonGroups.put(color, frameConvexPolygonGroup);
        }
        frameConvexPolygonGroup.addFrameConvexPolygon2ds(frameConvexPolygons);
    }

    public synchronized void addConvexPolygons(ArrayList<ConvexPolygon2D> convexPolygons, Color color) {
        FrameConvexPolygonGroup frameConvexPolygonGroup = this.frameConvexPolygonGroups.get(color);
        if (frameConvexPolygonGroup == null) {
            frameConvexPolygonGroup = new FrameConvexPolygonGroup(color);
            this.frameConvexPolygonGroups.put(color, frameConvexPolygonGroup);
        }
        ArrayList<FrameConvexPolygon2D> frameConvexPolygons = new ArrayList<FrameConvexPolygon2D>();
        for (ConvexPolygon2D polygon : convexPolygons) {
            frameConvexPolygons.add(new FrameConvexPolygon2D(ReferenceFrame.getWorldFrame(), (Vertex2DSupplier)polygon));
        }
        frameConvexPolygonGroup.addFrameConvexPolygon2ds(frameConvexPolygons);
    }

    public synchronized void addConvexPolygons(ConvexPolygon2D[] convexPolygons, Color color) {
        FrameConvexPolygonGroup frameConvexPolygonGroup = this.frameConvexPolygonGroups.get(color);
        if (frameConvexPolygonGroup == null) {
            frameConvexPolygonGroup = new FrameConvexPolygonGroup(color);
            this.frameConvexPolygonGroups.put(color, frameConvexPolygonGroup);
        }
        ArrayList<FrameConvexPolygon2D> frameConvexPolygons = new ArrayList<FrameConvexPolygon2D>();
        for (ConvexPolygon2D polygon : convexPolygons) {
            if (polygon == null) continue;
            frameConvexPolygons.add(new FrameConvexPolygon2D(ReferenceFrame.getWorldFrame(), (Vertex2DSupplier)polygon));
        }
        frameConvexPolygonGroup.addFrameConvexPolygon2ds(frameConvexPolygons);
    }

    public synchronized void addConvexPolygon(ConvexPolygon2D convexPolygon, Color color) {
        FrameConvexPolygonGroup frameConvexPolygonGroup = this.frameConvexPolygonGroups.get(color);
        if (frameConvexPolygonGroup == null) {
            frameConvexPolygonGroup = new FrameConvexPolygonGroup(color);
            this.frameConvexPolygonGroups.put(color, frameConvexPolygonGroup);
        }
        ArrayList<FrameConvexPolygon2D> frameConvexPolygons = new ArrayList<FrameConvexPolygon2D>();
        if (convexPolygon == null) {
            return;
        }
        frameConvexPolygons.add(new FrameConvexPolygon2D(ReferenceFrame.getWorldFrame(), (Vertex2DSupplier)convexPolygon));
        frameConvexPolygonGroup.addFrameConvexPolygon2ds(frameConvexPolygons);
    }

    public synchronized void addFramePoint2d(FramePoint2DReadOnly framePoint2d) {
        this.addFramePoint2d(framePoint2d, Color.black);
    }

    public synchronized void addTestPoint(FramePoint2D testPoint) {
        this.testPoints.add(testPoint);
    }

    public synchronized void setPolygonToCheckInside(FrameConvexPolygon2D polygon) {
        this.polygonToCheckInside = polygon;
    }

    public synchronized void addTestPoints(ArrayList<FramePoint2D> testPoints) {
        this.testPoints.addAll(testPoints);
        this.repaint();
    }

    public synchronized void removeAllObjectsToDraw() {
        this.testPoints.clear();
        this.polygonToCheckInside = null;
        this.frameLineGroups.clear();
        this.framePointGroups.clear();
        this.frameConvexPolygonGroups.clear();
        this.frameLineSegmentGroups.clear();
        this.repaint();
    }

    @Override
    public synchronized void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (this.polygonToCheckInside != null) {
            this.drawPolygon(this.polygonToCheckInside, graphics);
        }
        this.drawFramePolygonGroups(this.frameConvexPolygonGroups, graphics);
        this.drawFrameLineGroups(this.frameLineGroups, graphics);
        this.drawFrameLineSegmentGroups(this.frameLineSegmentGroups, graphics);
        this.drawTestPoints(this.testPoints, this.polygonToCheckInside, graphics);
        this.drawFramePointGroups(this.framePointGroups, graphics);
    }

    private void drawFramePolygonGroups(HashMap<Color, FrameConvexPolygonGroup> frameConvexPolygonGroups, Graphics graphics) {
        Collection<FrameConvexPolygonGroup> groups = frameConvexPolygonGroups.values();
        for (FrameConvexPolygonGroup frameConvexPolygonGroup : groups) {
            graphics.setColor(frameConvexPolygonGroup.color);
            this.drawPolygons(frameConvexPolygonGroup.polygons, graphics);
        }
    }

    private void drawFrameLineGroups(HashMap<Color, FrameLineGroup> frameLineGroups, Graphics graphics) {
        Collection<FrameLineGroup> groups = frameLineGroups.values();
        for (FrameLineGroup frameLineGroup : groups) {
            graphics.setColor(frameLineGroup.color);
            this.drawFrameLines(frameLineGroup.frameLines, graphics);
        }
    }

    private void drawFrameLineSegmentGroups(HashMap<Color, FrameLineSegmentGroup> frameLineSegmentGroups, Graphics graphics) {
        Collection<FrameLineSegmentGroup> groups = frameLineSegmentGroups.values();
        for (FrameLineSegmentGroup frameLineSegmentGroup : groups) {
            graphics.setColor(frameLineSegmentGroup.color);
            this.drawFrameLineSegments(frameLineSegmentGroup.frameLineSegments, graphics);
        }
    }

    private void drawFramePointGroups(HashMap<Color, FramePointGroup> framePointGroups, Graphics graphics) {
        Collection<FramePointGroup> groups = framePointGroups.values();
        for (FramePointGroup framePointGroup : groups) {
            graphics.setColor(framePointGroup.color);
            this.drawFramePoints(framePointGroup.framePoints, graphics);
        }
    }

    private void drawFrameLines(ArrayList<FrameLine2D> frameLines, Graphics graphics) {
        for (FrameLine2D frameLine : frameLines) {
            this.drawLine(frameLine, graphics);
        }
    }

    private void drawFrameLineSegments(ArrayList<FrameLineSegment2D> frameLineSegments, Graphics graphics) {
        for (FrameLineSegment2D frameLineSegment : frameLineSegments) {
            this.drawLineSegment(frameLineSegment, graphics);
        }
    }

    private void drawFramePoints(ArrayList<? extends FramePoint2DReadOnly> framePoints, Graphics graphics) {
        for (FramePoint2DReadOnly framePoint2DReadOnly : framePoints) {
            this.drawPoint(framePoint2DReadOnly, graphics);
        }
    }

    private void drawTestPoints(ArrayList<FramePoint2D> testPoints, FrameConvexPolygon2D polygon, Graphics graphics) {
        for (FramePoint2D testPoint : testPoints) {
            boolean isInside = polygon.isPointInside((FramePoint2DReadOnly)testPoint);
            if (isInside) {
                this.drawInsidePoint(testPoint, graphics);
                continue;
            }
            this.drawOutsidePoint(testPoint, graphics);
        }
    }

    private void drawPoint(FramePoint2D testPoint, Color color, Graphics graphics) {
        int xInt = this.doubleToInt(testPoint.getX(), this.xCenter, this.scale, this.getWidth());
        int yInt = this.doubleToInt(testPoint.getY(), this.yCenter, -this.scale, this.getHeight());
        graphics.setColor(color);
        graphics.fillOval(xInt - 2, yInt - 2, 4, 4);
    }

    private void drawInsidePoint(FramePoint2D testPoint, Graphics graphics) {
        int xInt = this.doubleToInt(testPoint.getX(), this.xCenter, this.scale, this.getWidth());
        int yInt = this.doubleToInt(testPoint.getY(), this.yCenter, -this.scale, this.getHeight());
        graphics.setColor(Color.green);
        graphics.fillOval(xInt - 2, yInt - 2, 4, 4);
    }

    private void drawOutsidePoint(FramePoint2D testPoint, Graphics graphics) {
        int xInt = this.doubleToInt(testPoint.getX(), this.xCenter, this.scale, this.getWidth());
        int yInt = this.doubleToInt(testPoint.getY(), this.yCenter, -this.scale, this.getHeight());
        graphics.setColor(Color.red);
        graphics.fillOval(xInt - 2, yInt - 2, 4, 4);
    }

    private void drawPolygons(ArrayList<FrameConvexPolygon2D> polygons, Graphics graphics) {
        for (FrameConvexPolygon2D polygon : polygons) {
            this.drawPolygon(polygon, graphics);
        }
    }

    private void drawPolygon(FrameConvexPolygon2D frameConvexPolygon2d, Graphics graphics) {
        Polygon polygon = new Polygon();
        for (int i = 0; i < frameConvexPolygon2d.getNumberOfVertices(); ++i) {
            FramePoint2DReadOnly vertex = frameConvexPolygon2d.getVertex(i);
            int xInt = this.doubleToInt(vertex.getX(), this.xCenter, this.scale, this.getWidth());
            int yInt = this.doubleToInt(vertex.getY(), this.yCenter, -this.scale, this.getHeight());
            polygon.addPoint(xInt, yInt);
        }
        graphics.drawPolygon(polygon);
    }

    private void drawLine(FrameLine2D frameLine2d, Graphics graphics) {
        Point2D point = new Point2D((Tuple2DReadOnly)frameLine2d.getPoint());
        Vector2D vector = new Vector2D((Tuple2DReadOnly)frameLine2d.getDirection());
        double largeNumber = this.scale * 100.0;
        double X2 = point.getX() + largeNumber * vector.getX();
        double Y2 = point.getY() + largeNumber * vector.getY();
        this.drawLine(point.getX(), point.getY(), X2, Y2, graphics);
    }

    private void drawLineSegment(FrameLineSegment2D frameLineSegment2d, Graphics graphics) {
        FixedFramePoint2DBasics firstEndpoint = frameLineSegment2d.getFirstEndpoint();
        FixedFramePoint2DBasics secondEndpoint = frameLineSegment2d.getSecondEndpoint();
        this.drawLine(firstEndpoint.getX(), firstEndpoint.getY(), secondEndpoint.getX(), secondEndpoint.getY(), graphics);
    }

    private void drawPoint(FramePoint2DReadOnly framePoint2d, Graphics graphics) {
        this.drawPoint(framePoint2d.getX(), framePoint2d.getY(), graphics);
    }

    private void drawLine(double X1, double Y1, double X2, double Y2, Graphics graphics) {
        int x1 = this.doubleToInt(X1, this.xCenter, this.scale, this.getWidth());
        int x2 = this.doubleToInt(X2, this.xCenter, this.scale, this.getWidth());
        int y1 = this.doubleToInt(Y1, this.yCenter, -this.scale, this.getHeight());
        int y2 = this.doubleToInt(Y2, this.yCenter, -this.scale, this.getHeight());
        graphics.drawLine(x1, y1, x2, y2);
    }

    private void drawPoint(double X1, double Y1, Graphics graphics) {
        int x1 = this.doubleToInt(X1, this.xCenter, this.scale, this.getWidth());
        int y1 = this.doubleToInt(Y1, this.yCenter, -this.scale, this.getHeight());
        graphics.fillOval(x1 - this.pointPixels / 2, y1 - this.pointPixels / 2, this.pointPixels, this.pointPixels);
    }

    private int doubleToInt(double value, double center, double scale, int extent) {
        return (int)((value - center) * scale + (double)(extent / 2));
    }

    private double intToDouble(int value, double center, double scale, int extent) {
        return (double)(value - extent / 2) / scale + center;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        int clickCount = e.getClickCount();
        if (clickCount > 1) {
            this.xCenter = this.lastMousePressX;
            this.yCenter = this.lastMousePressY;
            this.repaint();
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.buttonPressed = e.getButton();
        int xInt = e.getX();
        int yInt = e.getY();
        double x = this.intToDouble(xInt, this.xCenter, this.scale, this.getWidth());
        double y = this.intToDouble(yInt, this.yCenter, -this.scale, this.getHeight());
        this.lastMousePressX = x;
        this.lastMousePressY = y;
        if (this.buttonPressed == 2) {
            this.dragStartY = e.getY();
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.buttonPressed == 2) {
            double newScale;
            int yDifferenceFromStartOfDrag = -(e.getY() - this.dragStartY);
            double scalePercent = 1.0 + (double)yDifferenceFromStartOfDrag / 200.0;
            if (scalePercent < 0.1) {
                scalePercent = 0.1;
            }
            if ((newScale = this.scale * scalePercent) < 0.1) {
                newScale = 0.1;
            }
            this.scale = newScale;
            this.dragStartY = e.getY();
            this.repaint();
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    private class FrameLineSegmentGroup {
        private ArrayList<FrameLineSegment2D> frameLineSegments = new ArrayList();
        private final Color color;

        public FrameLineSegmentGroup(Color color) {
            this.color = color;
        }

        public void addFrameLineSegment(FrameLineSegment2D frameLineSegment2d) {
            this.frameLineSegments.add(frameLineSegment2d);
        }

        public void addFrameLineSegments(ArrayList<FrameLineSegment2D> frameLineSegments2d) {
            this.frameLineSegments.addAll(frameLineSegments2d);
        }
    }

    private class FrameConvexPolygonGroup {
        private ArrayList<FrameConvexPolygon2D> polygons = new ArrayList();
        private final Color color;

        public FrameConvexPolygonGroup(Color color) {
            this.color = color;
        }

        public void addFrameConvexPolygon2d(FrameConvexPolygon2D frameConvexPolygon2d) {
            this.polygons.add(frameConvexPolygon2d);
        }

        public void addFrameConvexPolygon2ds(ArrayList<FrameConvexPolygon2D> frameConvexPolygon2ds) {
            this.polygons.addAll(frameConvexPolygon2ds);
        }

        public void addFrameConvexPolygon2ds(FrameConvexPolygon2D[] frameConvexPolygon2ds) {
            for (FrameConvexPolygon2D frameConvexPolygon2d : frameConvexPolygon2ds) {
                this.polygons.add(frameConvexPolygon2d);
            }
        }
    }

    private class FramePointGroup {
        private ArrayList<FramePoint2DReadOnly> framePoints = new ArrayList();
        private final Color color;

        public FramePointGroup(Color color) {
            this.color = color;
        }

        public void addFramePoint(FramePoint2DReadOnly framePoint2d) {
            this.framePoints.add(framePoint2d);
        }

        public void addFramePoints(ArrayList<? extends FramePoint2DReadOnly> framePoints2d) {
            this.framePoints.addAll(framePoints2d);
        }

        public void addFramePoints(FramePoint2DReadOnly[] framePoints2d) {
            for (FramePoint2DReadOnly framePoint : framePoints2d) {
                this.framePoints.add(framePoint);
            }
        }
    }

    private class FrameLineGroup {
        private ArrayList<FrameLine2D> frameLines = new ArrayList();
        private final Color color;

        public FrameLineGroup(Color color) {
            this.color = color;
        }

        public void addFrameLine(FrameLine2D frameLine2d) {
            this.frameLines.add(frameLine2d);
        }

        public void addFrameLines(ArrayList<FrameLine2D> frameLines2d) {
            this.frameLines.addAll(frameLines2d);
        }

        public void addFrameLines(FrameLine2D[] frameLines2d) {
            for (FrameLine2D frameLine : frameLines2d) {
                this.frameLines.add(frameLine);
            }
        }
    }
}

