/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.geometry;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.mutable.MutableBoolean;
import us.ihmc.commons.lists.RecyclingArrayList;
import us.ihmc.euclid.geometry.Line2D;
import us.ihmc.euclid.geometry.interfaces.ConvexPolygon2DBasics;
import us.ihmc.euclid.geometry.interfaces.Line2DReadOnly;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.interfaces.Point2DBasics;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;

public class ConvexPolygonConstructorFromInteriorOfRays {
    private static final int POINT_POOL_INITIAL_SIZE = 10;
    private final ArrayList<Point2D> pointPool = new ArrayList();
    private final ArrayList<Point2D> intersectionArrayList = new ArrayList();
    private final ArrayList<Point2D> intersectionPoints = new ArrayList();
    private final RecyclingArrayList<MutableBoolean> removeRay = new RecyclingArrayList(MutableBoolean.class);

    public ConvexPolygonConstructorFromInteriorOfRays() {
        for (int i = 0; i < 10; ++i) {
            this.pointPool.add(new Point2D());
        }
    }

    public boolean constructFromInteriorOfRays(List<Line2D> rays, ConvexPolygon2DBasics polygonToPack) {
        int i;
        this.removeRay.clear();
        this.intersectionPoints.clear();
        for (i = 0; i < rays.size(); ++i) {
            this.intersectionPoints.add(null);
            ((MutableBoolean)this.removeRay.getAndGrowIfNeeded(i)).setValue(false);
        }
        block1: for (int rayIndex = 0; rayIndex < rays.size(); ++rayIndex) {
            Line2D ray;
            if (((MutableBoolean)this.removeRay.get(rayIndex)).booleanValue() || (ray = rays.get(rayIndex)) == null) continue;
            int previousIndexToCheck = rayIndex;
            while (true) {
                if (--previousIndexToCheck < 0) {
                    previousIndexToCheck = rays.size() - 1;
                }
                if (previousIndexToCheck == rayIndex) {
                    throw new RuntimeException("Should never get here!!!");
                }
                if (((MutableBoolean)this.removeRay.get(previousIndexToCheck)).booleanValue()) continue;
                Point2D previousPointToCheck = this.intersectionPoints.get(previousIndexToCheck);
                if (previousPointToCheck == null || !ray.isPointOnLeftSideOfLine((Point2DReadOnly)previousPointToCheck)) break;
                ((MutableBoolean)this.removeRay.get(previousIndexToCheck)).setValue(true);
                this.removeIntersectionPoint(this.intersectionPoints, previousIndexToCheck);
            }
            Line2D previousRayToCheck = rays.get(previousIndexToCheck);
            Point2D intersection = this.getAndRemovePointFromPool();
            if (intersection == null) {
                throw new RuntimeException("intersection == null!");
            }
            boolean foundIntersection = ray.intersectionWith((Line2DReadOnly)previousRayToCheck, (Point2DBasics)intersection);
            if (!foundIntersection) {
                this.returnPointsToPool(this.intersectionPoints);
                return false;
            }
            this.intersectionPoints.set(rayIndex, intersection);
            int evenMorePreviousIndexToCheck = previousIndexToCheck;
            while (true) {
                if (--evenMorePreviousIndexToCheck < 0) {
                    evenMorePreviousIndexToCheck = rays.size() - 1;
                }
                if (evenMorePreviousIndexToCheck == rayIndex) {
                    this.returnPointsToPool(this.intersectionPoints);
                    return false;
                }
                if (((MutableBoolean)this.removeRay.get(evenMorePreviousIndexToCheck)).booleanValue()) continue;
                Line2D evenMorePreviousRayToCheck = rays.get(evenMorePreviousIndexToCheck);
                if (!evenMorePreviousRayToCheck.isPointOnLeftSideOfLine((Point2DReadOnly)intersection)) continue block1;
                ((MutableBoolean)this.removeRay.get(previousIndexToCheck)).setValue(true);
                this.removeIntersectionPoint(this.intersectionPoints, previousIndexToCheck);
                previousIndexToCheck = evenMorePreviousIndexToCheck;
                intersection = this.getAndRemovePointFromPool();
                foundIntersection = ray.intersectionWith((Line2DReadOnly)evenMorePreviousRayToCheck, (Point2DBasics)intersection);
                if (!foundIntersection) {
                    this.returnPointsToPool(this.intersectionPoints);
                    return false;
                }
                this.intersectionPoints.set(rayIndex, intersection);
            }
        }
        this.intersectionArrayList.clear();
        for (i = 0; i < this.intersectionPoints.size(); ++i) {
            Point2D point = this.intersectionPoints.get(i);
            if (point == null) continue;
            this.intersectionArrayList.add(point);
        }
        if (this.intersectionArrayList.size() < 3) {
            this.returnPointsToPool(this.intersectionPoints);
            return false;
        }
        polygonToPack.clear();
        for (i = 0; i < this.intersectionArrayList.size(); ++i) {
            polygonToPack.addVertex((Point2DReadOnly)this.intersectionArrayList.get(i));
        }
        polygonToPack.update();
        this.returnPointsToPool(this.intersectionPoints);
        return true;
    }

    private Point2D getAndRemovePointFromPool() {
        if (this.pointPool.isEmpty()) {
            this.pointPool.add(new Point2D());
        }
        return this.pointPool.remove(this.pointPool.size() - 1);
    }

    private void removeIntersectionPoint(ArrayList<Point2D> intersectionPoints, int index) {
        Point2D pointToRemove = intersectionPoints.get(index);
        if (pointToRemove != null) {
            this.pointPool.add(pointToRemove);
            intersectionPoints.set(index, null);
        }
    }

    private void returnPointsToPool(ArrayList<Point2D> intersectionPoints) {
        for (int i = 0; i < intersectionPoints.size(); ++i) {
            Point2D point = intersectionPoints.get(i);
            if (point == null) continue;
            this.pointPool.add(point);
        }
        intersectionPoints.clear();
    }
}

