/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.geometry;

import java.util.ArrayList;
import us.ihmc.euclid.geometry.BoundingBox2D;
import us.ihmc.euclid.geometry.ConvexPolygon2D;
import us.ihmc.euclid.geometry.interfaces.ConvexPolygon2DBasics;
import us.ihmc.euclid.geometry.interfaces.ConvexPolygon2DReadOnly;
import us.ihmc.robotics.geometry.BoundingBoxKDTree2D;
import us.ihmc.robotics.geometry.ConvexPolygonTools;

public class ConvexPolygon2dIntersectionSetCalculator {
    private BoundingBoxKDTree2D kdTree;
    private final ArrayList<ConvexPolygon2D> convexPolygon2dsToSearchForIntersection = new ArrayList();
    private final ArrayList<BoundingBox2D> boundingBoxes = new ArrayList();
    private final ConvexPolygonTools convexPolygonTools = new ConvexPolygonTools();

    public ConvexPolygon2dIntersectionSetCalculator(ArrayList<ConvexPolygon2D> convexPolygon2d) {
        this.resetBaseConvexPolygon2ds(convexPolygon2d);
    }

    public ArrayList<ConvexPolygon2D> findTentativeListOfPolygonsIntersectingTargetPolygon(ConvexPolygon2D targetPolygon) {
        ArrayList<ConvexPolygon2D> tentativeListOfPolygonsIntersectingTargetPolygon = new ArrayList<ConvexPolygon2D>();
        ArrayList<Object> intersectingObjects = this.kdTree.getIntersectingObjects(targetPolygon.getBoundingBox());
        for (Object o : intersectingObjects) {
            tentativeListOfPolygonsIntersectingTargetPolygon.add((ConvexPolygon2D)o);
        }
        return tentativeListOfPolygonsIntersectingTargetPolygon;
    }

    public ArrayList<ConvexPolygon2D> findIntersectionPolygonList(ConvexPolygon2D targetPolygon) {
        ArrayList<ConvexPolygon2D> tentativeList = this.findTentativeListOfPolygonsIntersectingTargetPolygon(targetPolygon);
        if (tentativeList == null || tentativeList.isEmpty()) {
            return null;
        }
        ArrayList<ConvexPolygon2D> ret = new ArrayList<ConvexPolygon2D>();
        for (ConvexPolygon2D tentativePolygon : tentativeList) {
            ConvexPolygon2D intersection;
            boolean success = this.convexPolygonTools.computeIntersectionOfPolygons((ConvexPolygon2DReadOnly)targetPolygon, (ConvexPolygon2DReadOnly)tentativePolygon, (ConvexPolygon2DBasics)(intersection = new ConvexPolygon2D()));
            if (!success) continue;
            ret.add(intersection);
        }
        return ret;
    }

    public void resetBaseConvexPolygon2ds(ArrayList<ConvexPolygon2D> convexPolygon2ds) {
        this.convexPolygon2dsToSearchForIntersection.clear();
        this.boundingBoxes.clear();
        for (ConvexPolygon2D convexPolygon2d : convexPolygon2ds) {
            this.convexPolygon2dsToSearchForIntersection.add(convexPolygon2d);
        }
        for (int i = 0; i < this.convexPolygon2dsToSearchForIntersection.size(); ++i) {
            ConvexPolygon2D convexPolygon2d;
            convexPolygon2d = this.convexPolygon2dsToSearchForIntersection.get(i);
            this.boundingBoxes.add(convexPolygon2d.getBoundingBox());
        }
        ArrayList<ConvexPolygon2D> allObjects = new ArrayList<ConvexPolygon2D>(this.convexPolygon2dsToSearchForIntersection);
        this.kdTree = new BoundingBoxKDTree2D(this.boundingBoxes, allObjects);
    }
}

