/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.geometry;

import us.ihmc.euclid.geometry.LineSegment2D;
import us.ihmc.euclid.geometry.interfaces.ConvexPolygon2DReadOnly;
import us.ihmc.euclid.geometry.interfaces.Line2DReadOnly;
import us.ihmc.euclid.geometry.interfaces.LineSegment2DBasics;
import us.ihmc.euclid.geometry.tools.EuclidGeometryTools;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Vector2DBasics;
import us.ihmc.euclid.tuple2D.interfaces.Vector2DReadOnly;

public class ConvexPolygon2dCalculator {
    public static boolean isPolygonInside(ConvexPolygon2DReadOnly polygonToTest, double epsilon, ConvexPolygon2DReadOnly polygon) {
        for (int i = 0; i < polygonToTest.getNumberOfVertices(); ++i) {
            if (polygon.isPointInside(polygonToTest.getVertex(i), epsilon)) continue;
            return false;
        }
        return true;
    }

    public static boolean isPolygonInside(ConvexPolygon2DReadOnly polygonToTest, ConvexPolygon2DReadOnly polygon) {
        return ConvexPolygon2dCalculator.isPolygonInside(polygonToTest, 0.0, polygon);
    }

    public static int getMiddleIndexCounterClockwise(int firstIndex, int secondIndex, ConvexPolygon2DReadOnly polygon) {
        int numberOfVertices = polygon.getNumberOfVertices();
        if (secondIndex >= firstIndex) {
            return (secondIndex + (firstIndex + numberOfVertices - secondIndex + 1) / 2) % numberOfVertices;
        }
        return (secondIndex + firstIndex + 1) / 2;
    }

    public static void getEdgeNormal(int edgeIndex, Vector2DBasics normalToPack, ConvexPolygon2DReadOnly polygon) {
        Point2DReadOnly edgeStart = polygon.getVertex(edgeIndex);
        Point2DReadOnly edgeEnd = polygon.getNextVertex(edgeIndex);
        double edgeVectorX = edgeEnd.getX() - edgeStart.getX();
        double edgeVectorY = edgeEnd.getY() - edgeStart.getY();
        normalToPack.set(-edgeVectorY, edgeVectorX);
        normalToPack.normalize();
    }

    public static int getIntersectingEdges(Line2DReadOnly line, LineSegment2DBasics edgeToPack1, LineSegment2DBasics edgeToPack2, ConvexPolygon2DReadOnly polygon) {
        if (polygon.getNumberOfVertices() == 1) {
            return 0;
        }
        int foundEdges = 0;
        for (int i = 0; i < polygon.getNumberOfVertices(); ++i) {
            Point2DReadOnly startVertex = polygon.getVertex(i);
            Point2DReadOnly endVertex = polygon.getNextVertex(i);
            if (line.isPointOnLine(startVertex) && line.isPointOnLine(endVertex)) {
                if (polygon.getNumberOfVertices() == 2) {
                    return 0;
                }
                edgeToPack1.set(polygon.getPreviousVertex(i), startVertex);
                edgeToPack2.set(endVertex, polygon.getNextVertex(polygon.getNextVertexIndex(i)));
                return 2;
            }
            if (line.isPointOnLine(startVertex)) continue;
            if (ConvexPolygon2dCalculator.doesLineIntersectEdge(line, i, polygon) || line.isPointOnLine(endVertex)) {
                if (foundEdges == 0) {
                    edgeToPack1.set(startVertex, endVertex);
                } else {
                    edgeToPack2.set(startVertex, endVertex);
                }
                ++foundEdges;
            }
            if (foundEdges == 2) break;
        }
        return foundEdges;
    }

    public static boolean doesLineIntersectEdge(Line2DReadOnly line, int edgeIndex, ConvexPolygon2DReadOnly polygon) {
        double edgeDirectionY;
        double edgeDirectionX;
        double lineDirectionY;
        if (polygon.getNumberOfVertices() < 2) {
            return false;
        }
        Point2DReadOnly edgeStart = polygon.getVertex(edgeIndex);
        Point2DReadOnly edgeEnd = polygon.getNextVertex(edgeIndex);
        double lineDirectionX = line.getDirectionX();
        if (EuclidGeometryTools.areVector2DsParallel((double)lineDirectionX, (double)(lineDirectionY = line.getDirectionY()), (double)(edgeDirectionX = edgeEnd.getX() - edgeStart.getX()), (double)(edgeDirectionY = edgeEnd.getY() - edgeStart.getY()), (double)1.0E-7)) {
            return false;
        }
        return EuclidGeometryTools.doLine2DAndLineSegment2DIntersect((Point2DReadOnly)line.getPoint(), (Vector2DReadOnly)line.getDirection(), (Point2DReadOnly)edgeStart, (Point2DReadOnly)edgeEnd);
    }

    public static LineSegment2D[] getIntersectingEdgesCopy(Line2DReadOnly line, ConvexPolygon2DReadOnly polygon) {
        LineSegment2D edge1 = new LineSegment2D();
        LineSegment2D edge2 = new LineSegment2D();
        int edges = ConvexPolygon2dCalculator.getIntersectingEdges(line, (LineSegment2DBasics)edge1, (LineSegment2DBasics)edge2, polygon);
        if (edges == 2) {
            return new LineSegment2D[]{edge1, edge2};
        }
        if (edges == 1) {
            return new LineSegment2D[]{edge1};
        }
        return null;
    }
}

