/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.functionApproximation;

import java.util.ArrayList;
import us.ihmc.robotics.functionApproximation.LinearRegression;

public class OnlineLinearRegression {
    ArrayList<Double> output;
    ArrayList<double[]> input;
    double[] coefficientVector;
    int capacity;

    public OnlineLinearRegression(int capacity, int inputDim) {
        this.capacity = capacity;
        this.output = new ArrayList(capacity);
        this.input = new ArrayList(capacity);
        this.coefficientVector = new double[inputDim];
    }

    public int getNumberOfEntries() {
        return this.input.size();
    }

    public boolean addEntry(double y, double[] x) {
        assert (this.input.size() == this.output.size());
        if (this.input.size() == this.capacity) {
            this.input.remove(0);
            this.output.remove(0);
        }
        this.input.add(x);
        this.output.add(y);
        return true;
    }

    public double[] getCoefficient() {
        LinearRegression solver = new LinearRegression(this.input, this.output);
        solver.solve();
        solver.getCoefficientVector(this.coefficientVector);
        return this.coefficientVector;
    }
}

