/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.functionApproximation;

import us.ihmc.euclid.geometry.interfaces.Line2DReadOnly;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.Vector2D;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Vector2DReadOnly;
import us.ihmc.robotics.functionApproximation.OnlineLeastSquaresRegression;
import us.ihmc.robotics.functionApproximation.ProbabilityDensityFunction;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameLine2D;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameUnitVector2D;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;

public class OnlineLine2DLinearRegression {
    private final OnlineLeastSquaresRegression onlineLeastSquaresRegression;
    private final YoFrameLine2D line;
    private final Vector2D deviationVector = new Vector2D();
    private final YoDouble transverseStandardDeviation;
    private final YoDouble inlineStandardDeviation;
    private final Point2D firstPointOnLine = new Point2D();
    private final Point2D secondPointOnLine = new Point2D();

    public OnlineLine2DLinearRegression(String prefix, YoRegistry registry) {
        this.onlineLeastSquaresRegression = new OnlineLeastSquaresRegression(prefix, registry);
        this.transverseStandardDeviation = new YoDouble(prefix + "TransverseStandardDeviation", registry);
        this.inlineStandardDeviation = new YoDouble(prefix + "InlineStandardDeviation", registry);
        this.line = new YoFrameLine2D(prefix + "_MeanLine", ReferenceFrame.getWorldFrame(), registry);
    }

    public void reset() {
        this.onlineLeastSquaresRegression.reset();
        this.transverseStandardDeviation.set(0.0);
        this.inlineStandardDeviation.set(0.0);
    }

    public void update(Point2DReadOnly point) {
        this.update(point.getX(), point.getY());
    }

    public void update(double x, double y) {
        this.onlineLeastSquaresRegression.update(x, y);
        if (this.onlineLeastSquaresRegression.getPointsInRegression() > 1) {
            this.firstPointOnLine.set(this.onlineLeastSquaresRegression.getXMean(), this.onlineLeastSquaresRegression.getYMean());
            double offsetX = this.onlineLeastSquaresRegression.getXMean() + 0.5;
            this.secondPointOnLine.set(offsetX, this.onlineLeastSquaresRegression.computeY(offsetX));
            this.line.set((Point2DReadOnly)this.firstPointOnLine, (Point2DReadOnly)this.secondPointOnLine);
            if (this.line.getDirection().containsNaN()) {
                return;
            }
            YoFrameUnitVector2D direction = this.line.getDirection();
            this.deviationVector.set(Math.signum(direction.getX()) * this.onlineLeastSquaresRegression.getXStandardDeviation(), Math.signum(direction.getY()) * this.onlineLeastSquaresRegression.getYStandardDeviation());
            this.inlineStandardDeviation.set(Math.abs(this.deviationVector.dot((Vector2DReadOnly)direction)));
            this.transverseStandardDeviation.set(Math.abs(this.deviationVector.cross((Tuple2DReadOnly)direction)));
        }
    }

    public static double dotProduct(Point2DReadOnly start1, double end1X, double end1Y, Vector2DReadOnly vector2) {
        double vector1X = end1X - start1.getX();
        double vector1Y = end1Y - start1.getY();
        return vector1X * vector2.getX() + vector1Y * vector2.getY();
    }

    public Line2DReadOnly getMeanLine() {
        return this.line;
    }

    public double getXStandardDeviation() {
        return this.onlineLeastSquaresRegression.getXStandardDeviation();
    }

    public double getYStandardDeviation() {
        return this.onlineLeastSquaresRegression.getYStandardDeviation();
    }

    public double getTransverseStandardDeviation() {
        return this.transverseStandardDeviation.getDoubleValue();
    }

    public double getInlineStandardDeviation() {
        return this.inlineStandardDeviation.getDoubleValue();
    }

    public double getProbabilityPointIsOnLine(Point2DReadOnly point) {
        double distanceToMean = this.line.distance(point);
        return ProbabilityDensityFunction.getProbabilityUsingNormalDistribution(distanceToMean, 0.0, this.getTransverseStandardDeviation());
    }
}

