/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.functionApproximation;

import org.ejml.data.DMatrix;
import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.data.Matrix;
import org.ejml.dense.row.CommonOps_DDRM;
import org.ejml.dense.row.factory.LinearSolverFactory_DDRM;
import org.ejml.interfaces.decomposition.SingularValueDecomposition_F64;
import org.ejml.interfaces.linsol.LinearSolverDense;
import us.ihmc.matrixlib.MatrixTools;
import us.ihmc.robotics.linearAlgebra.ConfigurableSolvePseudoInverseSVD;

public class DampedLeastSquaresSolver
implements LinearSolverDense<DMatrixRMaj> {
    private final DMatrixRMaj A;
    private double alpha;
    private final DMatrixRMaj tempMatrix1;
    private final DMatrixRMaj tempMatrix2;
    private final LinearSolverDense<DMatrixRMaj> linearSolver;
    private final LinearSolverDense<DMatrixRMaj> linearSolverAlpha0;
    private int matrixSize;

    public DampedLeastSquaresSolver(int matrixSize) {
        this(matrixSize, 0.0);
    }

    public DampedLeastSquaresSolver(int matrixSize, double alpha) {
        this.matrixSize = matrixSize;
        this.A = new DMatrixRMaj(matrixSize, matrixSize);
        this.tempMatrix1 = new DMatrixRMaj(matrixSize, matrixSize);
        this.tempMatrix2 = new DMatrixRMaj(matrixSize, 1);
        this.linearSolver = LinearSolverFactory_DDRM.symmPosDef((int)matrixSize);
        this.linearSolverAlpha0 = new ConfigurableSolvePseudoInverseSVD();
        this.alpha = alpha;
    }

    public void setAlpha(double alpha) {
        this.alpha = alpha;
    }

    public boolean setA(DMatrixRMaj A) {
        this.A.set((DMatrixD1)A);
        this.matrixSize = A.getNumRows();
        return true;
    }

    public double quality() {
        return CommonOps_DDRM.det((DMatrixRMaj)this.A);
    }

    public void solve(DMatrixRMaj b, DMatrixRMaj x) {
        if (this.alpha == 0.0) {
            this.linearSolverAlpha0.setA((Matrix)this.A);
            this.linearSolverAlpha0.solve((Matrix)b, (Matrix)x);
        } else {
            this.tempMatrix1.reshape(this.matrixSize, this.matrixSize);
            this.tempMatrix2.reshape(this.matrixSize, b.getNumCols());
            CommonOps_DDRM.multOuter((DMatrix1Row)this.A, (DMatrix1Row)this.tempMatrix1);
            MatrixTools.addDiagonal((DMatrix)this.tempMatrix1, (double)(this.alpha * this.alpha));
            this.linearSolver.setA((Matrix)this.tempMatrix1);
            this.linearSolver.solve((Matrix)b, (Matrix)this.tempMatrix2);
            CommonOps_DDRM.multTransA((DMatrix1Row)this.A, (DMatrix1Row)this.tempMatrix2, (DMatrix1Row)x);
        }
    }

    public void invert(DMatrixRMaj A_inv) {
        if (this.alpha == 0.0) {
            this.linearSolverAlpha0.setA((Matrix)this.A);
            this.linearSolverAlpha0.invert((Matrix)A_inv);
        } else {
            this.tempMatrix1.reshape(this.matrixSize, this.matrixSize);
            this.tempMatrix2.reshape(this.matrixSize, this.matrixSize);
            CommonOps_DDRM.multOuter((DMatrix1Row)this.A, (DMatrix1Row)this.tempMatrix1);
            MatrixTools.addDiagonal((DMatrix)this.tempMatrix1, (double)(this.alpha * this.alpha));
            this.linearSolver.setA((Matrix)this.tempMatrix1);
            this.linearSolver.invert((Matrix)this.tempMatrix2);
            CommonOps_DDRM.multTransA((DMatrix1Row)this.A, (DMatrix1Row)this.tempMatrix2, (DMatrix1Row)A_inv);
        }
    }

    public boolean modifiesA() {
        return false;
    }

    public boolean modifiesB() {
        return false;
    }

    public SingularValueDecomposition_F64<DMatrixRMaj> getDecomposition() {
        return null;
    }
}

