/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.dataStructures;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import us.ihmc.euclid.geometry.interfaces.Vertex3DSupplier;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;

public class Vertex3DSupplierList<T extends Point3DReadOnly>
implements Vertex3DSupplier,
List<T> {
    private int firstVertexIndex;
    private int lastVertexIndex;
    private final boolean useVertexIndexingAsVertexSupplier;
    private final List<T> vertexList;

    public Vertex3DSupplierList(boolean useVertexIndexing) {
        this.vertexList = new ArrayList<T>();
        this.useVertexIndexingAsVertexSupplier = useVertexIndexing;
    }

    public Vertex3DSupplierList() {
        this(false);
    }

    public Vertex3DSupplierList(List<T> backingList, boolean useVertexIndexing) {
        this.vertexList = backingList;
        this.useVertexIndexingAsVertexSupplier = useVertexIndexing;
    }

    public Vertex3DSupplierList(List<T> backingList) {
        this(backingList, false);
    }

    public List<T> getVertexList() {
        return this.vertexList;
    }

    public void setIndicesForVerticesToSupply(int firstIndex, int lastIndex) {
        this.checkIfVertexIndexingIsEnabled();
        if (firstIndex > lastIndex) {
            throw new RuntimeException("The first index (" + firstIndex + ") cannot be less than last index (" + lastIndex + ")");
        }
        this.firstVertexIndex = firstIndex;
        this.lastVertexIndex = lastIndex;
    }

    public void setIndicesFromList() {
        this.checkIfVertexIndexingIsEnabled();
        this.firstVertexIndex = 0;
        this.lastVertexIndex = this.vertexList.size() - 1;
    }

    public void checkIfVertexIndexingIsEnabled() {
        if (!this.useVertexIndexingAsVertexSupplier) {
            throw new RuntimeException("Cannot use vertex index. Option was disabled at instantiation");
        }
    }

    private void checkIfVertexIndexIsValid(int indexToCheck) {
        this.checkIfVertexIndexingIsEnabled();
        if (indexToCheck < 0 && indexToCheck >= this.getNumberOfVertices()) {
            throw new IndexOutOfBoundsException("Index (" + indexToCheck + ") is not in bounds");
        }
    }

    public T getVertex(int index) {
        if (this.useVertexIndexingAsVertexSupplier) {
            this.checkIfVertexIndexIsValid(index);
            return (T)((Point3DReadOnly)this.vertexList.get(this.firstVertexIndex + index));
        }
        return (T)((Point3DReadOnly)this.vertexList.get(index));
    }

    public int getNumberOfVertices() {
        if (this.useVertexIndexingAsVertexSupplier) {
            return this.lastVertexIndex - this.firstVertexIndex + 1;
        }
        return this.vertexList.size();
    }

    @Override
    public boolean add(T pointToAdd) {
        return this.vertexList.add(pointToAdd);
    }

    @Override
    public void add(int indexToInsertAt, T pointToInsert) {
        this.vertexList.add(indexToInsertAt, pointToInsert);
    }

    @Override
    public void clear() {
        this.vertexList.clear();
    }

    @Override
    public boolean contains(Object obejctToCheck) {
        return this.vertexList.contains(obejctToCheck);
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        return this.vertexList.contains(collection);
    }

    @Override
    public T get(int index) {
        return (T)((Point3DReadOnly)this.vertexList.get(index));
    }

    @Override
    public int indexOf(Object object) {
        return this.vertexList.indexOf(object);
    }

    @Override
    public boolean isEmpty() {
        return this.vertexList.isEmpty();
    }

    @Override
    public Iterator<T> iterator() {
        return this.vertexList.iterator();
    }

    @Override
    public int lastIndexOf(Object objectToGetIndexOf) {
        return this.vertexList.lastIndexOf(objectToGetIndexOf);
    }

    @Override
    public ListIterator<T> listIterator() {
        return this.vertexList.listIterator();
    }

    @Override
    public ListIterator<T> listIterator(int index) {
        return null;
    }

    @Override
    public boolean remove(Object objectToRemove) {
        return this.vertexList.remove(objectToRemove);
    }

    @Override
    public T remove(int index) {
        return (T)((Point3DReadOnly)this.vertexList.remove(index));
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        return this.vertexList.removeAll(collection);
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        return this.vertexList.retainAll(collection);
    }

    @Override
    public T set(int index, T element) {
        return (T)((Point3DReadOnly)this.vertexList.set(index, element));
    }

    @Override
    public int size() {
        return this.vertexList.size();
    }

    @Override
    public List<T> subList(int fromIndex, int toIndex) {
        return this.vertexList.subList(fromIndex, toIndex);
    }

    @Override
    public Object[] toArray() {
        return this.vertexList.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.vertexList.toArray(a);
    }

    @Override
    public boolean addAll(Collection<? extends T> collection) {
        return this.vertexList.addAll(collection);
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> collection) {
        return this.vertexList.addAll(index, collection);
    }
}

