/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.dataStructures;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.robotics.dataStructures.HeightMapWithPoints;
import us.ihmc.robotics.geometry.InclusionFunction;

public class DoubleHashHeightMap
implements HeightMapWithPoints {
    private HashMap<Integer, LinkedHashMap<Integer, Double>> rows;
    private final double gridSize;

    public DoubleHashHeightMap(double gridSize) {
        this.gridSize = gridSize;
        this.rows = new LinkedHashMap<Integer, LinkedHashMap<Integer, Double>>();
    }

    @Override
    public double getHeightAtPoint(double x, double y) {
        return this.heightAtPoint(this.index(x), this.index(y));
    }

    @Override
    public boolean containsPoint(double x, double y) {
        return this.containsPoint(this.index(x), this.index(y));
    }

    private boolean containsPoint(int x, int y) {
        if (!this.rows.containsKey(x)) {
            return false;
        }
        HashMap row = this.rows.get(x);
        if (!row.containsKey(y)) {
            return false;
        }
        Double height = (Double)row.get(y);
        return Double.isFinite(height);
    }

    private double heightAtPoint(int x, int y) {
        if (!this.rows.containsKey(x)) {
            return Double.NaN;
        }
        HashMap row = this.rows.get(x);
        if (!row.containsKey(y)) {
            return Double.NaN;
        }
        Double height = (Double)row.get(y);
        return height;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean addPoint(int xIndex, int yIndex, double z) {
        HashMap<Integer, LinkedHashMap<Integer, Double>> hashMap = this.rows;
        synchronized (hashMap) {
            if (Double.isFinite(z)) {
                if (!this.rows.containsKey(xIndex)) {
                    this.rows.put(xIndex, new LinkedHashMap());
                }
                HashMap xRow = this.rows.get(xIndex);
                xRow.put(yIndex, z);
            }
        }
        return true;
    }

    @Override
    public boolean addPoint(double x, double y, double z) {
        return this.addPoint(this.index(x), this.index(y), z);
    }

    private int index(double coordinate) {
        double quotient = coordinate / this.gridSize;
        int closestIndex = (int)Math.round(quotient);
        return closestIndex;
    }

    public double gridSize() {
        return this.gridSize;
    }

    private List<Point3D> getAllPointsWithin(int xMin, int xMax, int yMin, int yMax) {
        ArrayList<Point3D> points = new ArrayList<Point3D>();
        if (xMax >= xMin && yMax >= yMin) {
            if (this.rows.values().size() < xMax - xMin + 1) {
                this.iterateOverKeysToPackAllRowsWithin(xMin, xMax, yMin, yMax, points);
            } else {
                this.iterateOverValuesToPackAllRowsWithin(xMin, xMax, yMin, yMax, points);
            }
        }
        return points;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        HashMap<Integer, LinkedHashMap<Integer, Double>> hashMap = this.rows;
        synchronized (hashMap) {
            this.rows.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void iterateOverKeysToPackAllRowsWithin(int xMin, int xMax, int yMin, int yMax, ArrayList<Point3D> points) {
        HashMap<Integer, LinkedHashMap<Integer, Double>> hashMap = this.rows;
        synchronized (hashMap) {
            for (int x : this.rows.keySet()) {
                if (xMin > x || xMax < x) continue;
                LinkedHashMap<Integer, Double> row = new LinkedHashMap<Integer, Double>((Map)this.rows.get(x));
                this.getAllPointsInRow(yMin, yMax, points, x, row);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void iterateOverValuesToPackAllRowsWithin(int xMin, int xMax, int yMin, int yMax, ArrayList<Point3D> points) {
        HashMap<Integer, LinkedHashMap<Integer, Double>> hashMap = this.rows;
        synchronized (hashMap) {
            for (int x = xMin; x <= xMax; ++x) {
                if (!this.rows.containsKey(x)) continue;
                HashMap row = this.rows.get(x);
                this.getAllPointsInRow(yMin, yMax, points, x, row);
            }
        }
    }

    private void getAllPointsInRow(int yMin, int yMax, ArrayList<Point3D> points, int x, HashMap<Integer, Double> row) {
        if (row.values().size() < yMax - yMin + 1) {
            this.iterateOverKeysetToPackAllPoints(yMin, yMax, points, x, row);
        } else {
            this.iterateOverColumnsToPackAllPoints(yMin, yMax, points, x, row);
        }
    }

    private void iterateOverColumnsToPackAllPoints(int yMin, int yMax, ArrayList<Point3D> points, int x, HashMap<Integer, Double> row) {
        for (int y = yMin; y <= yMax; ++y) {
            if (!row.containsKey(y)) continue;
            points.add(new Point3D((double)x * this.gridSize, (double)y * this.gridSize, row.get(y).doubleValue()));
        }
    }

    private void iterateOverKeysetToPackAllPoints(int yMin, int yMax, ArrayList<Point3D> points, int x, HashMap<Integer, Double> row) {
        for (int y : row.keySet()) {
            if (yMin > y || yMax < y) continue;
            points.add(new Point3D((double)x * this.gridSize, (double)y * this.gridSize, row.get(y).doubleValue()));
        }
    }

    @Override
    public List<Point3D> getAllPointsWithinArea(double xCenter, double yCenter, double xExtent, double yExtent) {
        return this.getAllPointsWithinAreaMinMax(xCenter - xExtent * 0.5, xCenter + xExtent * 0.5, yCenter - yExtent * 0.5, yCenter + yExtent * 0.5);
    }

    private List<Point3D> getAllPointsWithinAreaMinMax(double xMin, double xMax, double yMin, double yMax) {
        return this.getAllPointsWithin(this.index(xMin), this.index(xMax), this.index(yMin), this.index(yMax));
    }

    @Override
    public List<Point3D> getAllPointsWithinArea(double xCenter, double yCenter, double xExtent, double yExtent, InclusionFunction<Point3D> maskFunctionAboutCenter) {
        List<Point3D> allPointsInArea = this.getAllPointsWithinArea(xCenter, yCenter, xExtent, yExtent);
        ArrayList<Point3D> pointsToReturn = new ArrayList<Point3D>();
        for (Point3D point : allPointsInArea) {
            if (!maskFunctionAboutCenter.isIncluded(point)) continue;
            pointsToReturn.add(point);
        }
        return pointsToReturn;
    }
}

