/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.dataStructures;

import gnu.trove.map.hash.TLongObjectHashMap;
import java.util.ArrayList;
import java.util.LinkedList;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Point3D32;
import us.ihmc.euclid.tuple3D.Vector3D32;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.robotics.dataStructures.TimestampedPoint;

public class DecayingResolutionFilter {
    private double resolution;
    private long decayMillis;
    int capacity = 100000;
    private final TLongObjectHashMap<TimestampedPoint> map;
    private final LinkedList<TimestampedPoint> list;
    private static final int bits = 20;
    private static final int mask = 4095;
    private static final int offset = 524288;

    public DecayingResolutionFilter(double resolution, long decayMillis, int maxSizeAllowed) {
        this.resolution = resolution;
        this.decayMillis = decayMillis;
        this.capacity = maxSizeAllowed;
        this.map = new TLongObjectHashMap();
        this.list = new LinkedList();
    }

    public boolean add(Point3D p) {
        return this.add(p.getX(), p.getY(), p.getZ());
    }

    public boolean add(double x, double y, double z) {
        return this.add((float)x, (float)y, (float)z);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(float x, float y, float z) {
        long hash = this.hash(x, y, z, this.resolution);
        this.removeDecayedPoints();
        if (!this.map.containsKey(hash)) {
            TimestampedPoint point = new TimestampedPoint(x, y, z, System.currentTimeMillis());
            LinkedList<TimestampedPoint> linkedList = this.list;
            synchronized (linkedList) {
                this.atomicAddToMapAndList(hash, point);
            }
            return true;
        }
        return false;
    }

    private synchronized void atomicAddToMapAndList(long hash, TimestampedPoint point) {
        this.map.put(hash, (Object)point);
        this.list.addLast(point);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeDecayedPoints() {
        TimestampedPoint timePoint;
        LinkedList<TimestampedPoint> linkedList = this.list;
        synchronized (linkedList) {
            if (this.list.size() >= this.capacity && this.capacity > 0) {
                this.atomicRemoveFromListAndMap();
            }
        }
        long time = System.currentTimeMillis();
        while ((timePoint = this.list.peekFirst()) != null) {
            if (timePoint.timestamp + this.decayMillis > time || this.decayMillis < 0L) {
                return;
            }
            LinkedList<TimestampedPoint> linkedList2 = this.list;
            synchronized (linkedList2) {
                this.atomicRemoveFromListAndMap();
            }
        }
    }

    private synchronized void atomicRemoveFromListAndMap() {
        TimestampedPoint timePoint = this.list.removeFirst();
        this.map.remove(this.hash(timePoint));
    }

    private long hash(TimestampedPoint point) {
        return this.hash(point.getX32(), point.getY32(), point.getZ32(), this.resolution);
    }

    private long hash(float x, float y, float z, double res) {
        long hash = 0L;
        hash += (long)(((int)((double)x / res) + 524288 & 0xFFF) << 40);
        hash += (long)(((int)((double)y / res) + 524288 & 0xFFF) << 20);
        return hash += (long)(((int)((double)z / res) + 524288 & 0xFFF) << 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        LinkedList<TimestampedPoint> linkedList = this.list;
        synchronized (linkedList) {
            this.map.clear();
            this.list.clear();
        }
    }

    public void setResolution(double resolution) {
        this.resolution = resolution;
    }

    public void setDecay(long decayMillis) {
        this.decayMillis = decayMillis;
    }

    public void setCapacity(int capacity) {
        this.capacity = capacity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Point3D32[] getPoints3f() {
        LinkedList<TimestampedPoint> linkedList = this.list;
        synchronized (linkedList) {
            Point3D32[] points = new Point3D32[this.list.size()];
            for (int i = 0; i < this.list.size(); ++i) {
                points[i] = this.list.get(i);
            }
            return points;
        }
    }

    public Point3D32[] getPoints3fUnsynchronized() {
        return this.list.toArray(new Point3D32[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<TimestampedPoint> getPointsCopy() {
        ArrayList<TimestampedPoint> copy;
        LinkedList<TimestampedPoint> linkedList = this.list;
        synchronized (linkedList) {
            copy = new ArrayList<TimestampedPoint>(this.list);
        }
        return copy;
    }

    public Point3D32 getNearestIntersection(Point3D32 origin, Vector3D32 direction) {
        ArrayList<TimestampedPoint> points = this.getPointsCopy();
        direction.normalize();
        double nearestDistance = Double.POSITIVE_INFINITY;
        Point3D32 nearestPoint = null;
        for (Point3D32 point3D32 : points) {
            double distance;
            float dot;
            double distanceToLine;
            float dx = origin.getX32() - point3D32.getX32();
            float dy = origin.getY32() - point3D32.getY32();
            float dz = origin.getZ32() - point3D32.getZ32();
            if (!((distanceToLine = Math.sqrt((dx -= (dot = dx * direction.getX32() + dy * direction.getY32() + dz * direction.getZ32()) * direction.getX32()) * dx + (dy -= dot * direction.getY32()) * dy + (dz -= dot * direction.getZ32()) * dz)) < this.resolution / 2.0) || !((distance = origin.distance((Point3DReadOnly)point3D32)) < nearestDistance)) continue;
            nearestDistance = distance;
            nearestPoint = point3D32;
        }
        return nearestPoint;
    }
}

