/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.controllers.pidGains.implementations;

import us.ihmc.robotics.controllers.pidGains.PID3DGainsReadOnly;
import us.ihmc.robotics.controllers.pidGains.PIDGainsReadOnly;

public class SymmetricPID3DGains
implements PID3DGainsReadOnly {
    private PIDGainsReadOnly gains;
    private final double[] tempProportionalGains = new double[3];
    private final double[] tempDerivativeGains = new double[3];
    private final double[] tempIntegralGains = new double[3];

    public void setGains(PIDGainsReadOnly gains) {
        this.gains = gains;
    }

    @Override
    public double[] getProportionalGains() {
        return SymmetricPID3DGains.fill(this.tempProportionalGains, this.gains.getKp());
    }

    @Override
    public double[] getDerivativeGains() {
        return SymmetricPID3DGains.fill(this.tempDerivativeGains, this.gains.getKd());
    }

    @Override
    public double[] getIntegralGains() {
        return SymmetricPID3DGains.fill(this.tempIntegralGains, this.gains.getKi());
    }

    @Override
    public double getMaximumIntegralError() {
        return this.gains.getMaxIntegralError();
    }

    @Override
    public double getMaximumDerivativeError() {
        return Double.POSITIVE_INFINITY;
    }

    @Override
    public double getMaximumProportionalError() {
        return Double.POSITIVE_INFINITY;
    }

    @Override
    public double getMaximumFeedback() {
        return this.gains.getMaximumFeedback();
    }

    @Override
    public double getMaximumFeedbackRate() {
        return this.gains.getMaximumFeedbackRate();
    }

    private static double[] fill(double[] arrayToFill, double value) {
        arrayToFill[0] = value;
        arrayToFill[1] = value;
        arrayToFill[2] = value;
        return arrayToFill;
    }
}

