/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.controllers.pidGains.implementations;

import us.ihmc.euclid.interfaces.Settable;
import us.ihmc.robotics.controllers.pidGains.GainCalculator;
import us.ihmc.robotics.controllers.pidGains.PDGainsReadOnly;

public class PDGains
implements PDGainsReadOnly,
Settable<PDGains> {
    private double kp;
    private double kd;
    private double zeta;
    private double maximumFeedback;
    private double maximumFeedbackRate;
    private double positionDeadband;

    @Override
    public double getKp() {
        return this.kp;
    }

    public void setKp(double kp) {
        this.kp = kp;
        this.kd = GainCalculator.computeDerivativeGain(kp, this.zeta);
    }

    public double getZeta() {
        return this.zeta;
    }

    public void setZeta(double zeta) {
        this.zeta = zeta;
        this.kd = GainCalculator.computeDerivativeGain(this.kp, zeta);
    }

    public void setKd(double kd) {
        this.kd = kd;
        this.zeta = GainCalculator.computeDampingRatio(this.kp, kd);
    }

    public void set(PDGains other) {
        this.set((PDGainsReadOnly)other);
    }

    public void set(PDGainsReadOnly other) {
        this.setKp(other.getKp());
        this.setKd(other.getKd());
        this.setMaximumFeedback(other.getMaximumFeedback());
        this.setMaximumFeedbackRate(other.getMaximumFeedbackRate());
        this.setPositionDeadband(other.getPositionDeadband());
    }

    public void set(double kp, double kd, double maxFeedback, double maxFeedbackRate) {
        this.set(kp, kd, maxFeedback, maxFeedbackRate, 0.0);
    }

    public void set(double kp, double kd, double maxFeedback, double maxFeedbackRate, double positionDeadband) {
        this.setKp(kp);
        this.setKd(kd);
        this.setMaximumFeedback(maxFeedback);
        this.setMaximumFeedbackRate(maxFeedbackRate);
        this.setPositionDeadband(positionDeadband);
    }

    @Override
    public double getKd() {
        return this.kd;
    }

    @Override
    public double getMaximumFeedback() {
        return this.maximumFeedback;
    }

    public void setMaximumFeedback(double maximumFeedback) {
        this.maximumFeedback = maximumFeedback;
    }

    @Override
    public double getMaximumFeedbackRate() {
        return this.maximumFeedbackRate;
    }

    public void setMaximumFeedbackRate(double maximumFeedbackRate) {
        this.maximumFeedbackRate = maximumFeedbackRate;
    }

    @Override
    public double getPositionDeadband() {
        return this.positionDeadband;
    }

    public void setPositionDeadband(double positionDeadband) {
        this.positionDeadband = positionDeadband;
    }

    public boolean equals(Object object) {
        if (object instanceof PDGains) {
            PDGains other = (PDGains)object;
            if (Double.compare(this.zeta, other.zeta) != 0) {
                return false;
            }
            return PDGainsReadOnly.super.equals(other);
        }
        if (object instanceof PDGainsReadOnly) {
            return PDGainsReadOnly.super.equals((PDGainsReadOnly)object);
        }
        return false;
    }
}

