/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.controllers;

import us.ihmc.robotics.controllers.TangentialDampingGains;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;

public class YoTangentialDampingGains
implements TangentialDampingGains {
    private final YoDouble kdParallelMaxReductionRatio;
    private final YoDouble dampingParallelToMotionDeadband;
    private final YoDouble positionErrorForMinimumKd;

    public YoTangentialDampingGains(String suffix, YoRegistry registry) {
        this.kdParallelMaxReductionRatio = new YoDouble("kdParallelMaxReductionRatio" + suffix, registry);
        this.dampingParallelToMotionDeadband = new YoDouble("parallelDampingDeadband" + suffix, registry);
        this.positionErrorForMinimumKd = new YoDouble("maxParallelDampingError" + suffix, registry);
        this.reset();
    }

    public void reset() {
        this.kdParallelMaxReductionRatio.set(1.0);
        this.dampingParallelToMotionDeadband.set(Double.POSITIVE_INFINITY);
        this.dampingParallelToMotionDeadband.set(Double.POSITIVE_INFINITY);
    }

    public void set(TangentialDampingGains tangentialDampingGains) {
        if (tangentialDampingGains != null) {
            this.set(tangentialDampingGains.getKdReductionRatio(), tangentialDampingGains.getParallelDampingDeadband(), tangentialDampingGains.getPositionErrorForMinimumKd());
        }
    }

    @Override
    public void set(double kdReductionRatio, double parallelDampingDeadband, double positionErrorForMinimumKd) {
        this.setKdReductionRatio(kdReductionRatio);
        this.setParallelDampingDeadband(parallelDampingDeadband);
        this.setPositionErrorForMinimumKd(positionErrorForMinimumKd);
    }

    public void setKdReductionRatio(double kdReductionRatio) {
        this.kdParallelMaxReductionRatio.set(kdReductionRatio);
    }

    public void setParallelDampingDeadband(double parallelDampingDeadband) {
        this.dampingParallelToMotionDeadband.set(parallelDampingDeadband);
    }

    public void setPositionErrorForMinimumKd(double positionErrorForMinimumKd) {
        this.positionErrorForMinimumKd.set(positionErrorForMinimumKd);
    }

    @Override
    public double getKdReductionRatio() {
        return this.kdParallelMaxReductionRatio.getDoubleValue();
    }

    @Override
    public double getParallelDampingDeadband() {
        return this.dampingParallelToMotionDeadband.getDoubleValue();
    }

    @Override
    public double getPositionErrorForMinimumKd() {
        return this.positionErrorForMinimumKd.getDoubleValue();
    }
}

